/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;

public class ArraySelection<T>
extends Selection<T> {
    private Array<T> array;
    private boolean rangeSelect = true;
    private T rangeStart;

    public ArraySelection(Array<T> array) {
        this.array = array;
    }

    @Override
    protected void changed() {
        this.rangeStart = null;
    }

    @Override
    public void choose(T object) {
        if (object != null) {
            if (this.isDisabled) {
                return;
            }
            if (this.rangeSelect && this.multiple) {
                T t;
                int n;
                if (this.selected.size > 0 && UIUtils.shift() && (n = (t = this.rangeStart) == null ? -1 : this.array.indexOf(t, false)) != -1) {
                    int n2;
                    t = this.rangeStart;
                    this.snapshot();
                    int n3 = this.array.indexOf(object, false);
                    if (n > n3) {
                        n2 = n;
                        n = n3;
                    } else {
                        n2 = n3;
                    }
                    n3 = n;
                    if (!UIUtils.ctrl()) {
                        this.selected.clear(8);
                        n3 = n;
                    }
                    while (n3 <= n2) {
                        this.selected.add(this.array.get(n3));
                        ++n3;
                    }
                    if (this.fireChangeEvent()) {
                        this.revert();
                    } else {
                        this.changed();
                    }
                    this.rangeStart = t;
                    this.cleanup();
                    return;
                }
                super.choose(object);
                this.rangeStart = object;
                return;
            }
            super.choose(object);
            return;
        }
        object = new IllegalArgumentException("item cannot be null.");
        throw object;
    }

    public boolean getRangeSelect() {
        return this.rangeSelect;
    }

    public void setRangeSelect(boolean bl) {
        this.rangeSelect = bl;
    }

    public void validate() {
        Array array = this.array;
        if (array.size == 0) {
            this.clear();
            return;
        }
        ObjectSet.ObjectSetIterator objectSetIterator = this.items().iterator();
        while (objectSetIterator.hasNext()) {
            if (array.contains(objectSetIterator.next(), false)) continue;
            objectSetIterator.remove();
        }
        if (this.required && this.selected.size == 0) {
            this.set(array.first());
        }
    }
}

