/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.DefaultRenderableSorter;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.DefaultTextureBinder;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.g3d.utils.RenderableSorter;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FlushablePool;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ModelBatch
implements Disposable {
    protected Camera camera;
    protected final RenderContext context;
    private final boolean ownContext;
    protected final Array<Renderable> renderables;
    protected final RenderablePool renderablesPool = new RenderablePool();
    protected final ShaderProvider shaderProvider;
    protected final RenderableSorter sorter;

    public ModelBatch() {
        this(null, null, null);
    }

    public ModelBatch(FileHandle fileHandle, FileHandle fileHandle2) {
        this(null, new DefaultShaderProvider(fileHandle, fileHandle2), null);
    }

    public ModelBatch(RenderContext renderContext) {
        this(renderContext, null, null);
    }

    public ModelBatch(RenderContext renderContext, RenderableSorter renderableSorter) {
        this(renderContext, null, renderableSorter);
    }

    public ModelBatch(RenderContext renderContext, ShaderProvider shaderProvider) {
        this(renderContext, shaderProvider, null);
    }

    public ModelBatch(RenderContext object, ShaderProvider shaderProvider, RenderableSorter object2) {
        this.renderables = new Array();
        RenderableSorter renderableSorter = object2;
        if (object2 == null) {
            renderableSorter = new DefaultRenderableSorter();
        }
        this.sorter = renderableSorter;
        boolean bl = object == null;
        this.ownContext = bl;
        object2 = object;
        if (object == null) {
            object2 = new RenderContext(new DefaultTextureBinder(1, 1));
        }
        this.context = object2;
        object = shaderProvider;
        if (shaderProvider == null) {
            object = new DefaultShaderProvider();
        }
        this.shaderProvider = object;
    }

    public ModelBatch(RenderableSorter renderableSorter) {
        this(null, null, renderableSorter);
    }

    public ModelBatch(ShaderProvider shaderProvider) {
        this(null, shaderProvider, null);
    }

    public ModelBatch(ShaderProvider shaderProvider, RenderableSorter renderableSorter) {
        this(null, shaderProvider, renderableSorter);
    }

    public ModelBatch(String string2, String string3) {
        this(null, new DefaultShaderProvider(string2, string3), null);
    }

    public void begin(Camera camera) {
        if (this.camera == null) {
            this.camera = camera;
            if (this.ownContext) {
                this.context.begin();
            }
            return;
        }
        throw new GdxRuntimeException("Call end() first.");
    }

    @Override
    public void dispose() {
        this.shaderProvider.dispose();
    }

    public void end() {
        this.flush();
        if (this.ownContext) {
            this.context.end();
        }
        this.camera = null;
    }

    public void flush() {
        this.sorter.sort(this.camera, this.renderables);
        Shader shader = null;
        for (int i = 0; i < this.renderables.size; ++i) {
            Renderable renderable = this.renderables.get(i);
            Shader shader2 = shader;
            if (shader != renderable.shader) {
                if (shader != null) {
                    shader.end();
                }
                shader2 = renderable.shader;
                shader2.begin(this.camera, this.context);
            }
            shader2.render(renderable);
            shader = shader2;
        }
        if (shader != null) {
            shader.end();
        }
        this.renderablesPool.flush();
        this.renderables.clear();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public RenderContext getRenderContext() {
        return this.context;
    }

    public RenderableSorter getRenderableSorter() {
        return this.sorter;
    }

    public ShaderProvider getShaderProvider() {
        return this.shaderProvider;
    }

    public boolean ownsRenderContext() {
        return this.ownContext;
    }

    public void render(Renderable renderable) {
        renderable.shader = this.shaderProvider.getShader(renderable);
        this.renderables.add(renderable);
    }

    public void render(RenderableProvider object) {
        object.getRenderables(this.renderables, this.renderablesPool);
        for (int i = this.renderables.size; i < this.renderables.size; ++i) {
            object = this.renderables.get(i);
            ((Renderable)object).shader = this.shaderProvider.getShader((Renderable)object);
        }
    }

    public void render(RenderableProvider object, Environment environment) {
        object.getRenderables(this.renderables, this.renderablesPool);
        for (int i = this.renderables.size; i < this.renderables.size; ++i) {
            object = this.renderables.get(i);
            ((Renderable)object).environment = environment;
            ((Renderable)object).shader = this.shaderProvider.getShader((Renderable)object);
        }
    }

    public void render(RenderableProvider object, Environment environment, Shader shader) {
        object.getRenderables(this.renderables, this.renderablesPool);
        for (int i = this.renderables.size; i < this.renderables.size; ++i) {
            object = this.renderables.get(i);
            ((Renderable)object).environment = environment;
            ((Renderable)object).shader = shader;
            ((Renderable)object).shader = this.shaderProvider.getShader((Renderable)object);
        }
    }

    public void render(RenderableProvider object, Shader shader) {
        object.getRenderables(this.renderables, this.renderablesPool);
        for (int i = this.renderables.size; i < this.renderables.size; ++i) {
            object = this.renderables.get(i);
            ((Renderable)object).shader = shader;
            ((Renderable)object).shader = this.shaderProvider.getShader((Renderable)object);
        }
    }

    public <T extends RenderableProvider> void render(Iterable<T> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.render((RenderableProvider)object.next());
        }
    }

    public <T extends RenderableProvider> void render(Iterable<T> object, Environment environment) {
        object = object.iterator();
        while (object.hasNext()) {
            this.render((RenderableProvider)object.next(), environment);
        }
    }

    public <T extends RenderableProvider> void render(Iterable<T> object, Environment environment, Shader shader) {
        object = object.iterator();
        while (object.hasNext()) {
            this.render((RenderableProvider)object.next(), environment, shader);
        }
    }

    public <T extends RenderableProvider> void render(Iterable<T> object, Shader shader) {
        object = object.iterator();
        while (object.hasNext()) {
            this.render((RenderableProvider)object.next(), shader);
        }
    }

    public void setCamera(Camera camera) {
        if (this.camera != null) {
            if (this.renderables.size > 0) {
                this.flush();
            }
            this.camera = camera;
            return;
        }
        throw new GdxRuntimeException("Call begin() first.");
    }

    protected static class RenderablePool
    extends FlushablePool<Renderable> {
        protected RenderablePool() {
        }

        @Override
        protected Renderable newObject() {
            return new Renderable();
        }

        @Override
        public Renderable obtain() {
            Renderable renderable = (Renderable)super.obtain();
            renderable.environment = null;
            renderable.material = null;
            renderable.meshPart.set("", null, 0, 0, 0);
            renderable.shader = null;
            renderable.userData = null;
            return renderable;
        }
    }
}

