/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioManager;
import android.media.SoundPool;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.IntArray;

final class AndroidSound
implements Sound {
    final AudioManager manager;
    final int soundId;
    final SoundPool soundPool;
    final IntArray streamIds = new IntArray(8);

    AndroidSound(SoundPool soundPool, AudioManager audioManager, int n) {
        this.soundPool = soundPool;
        this.manager = audioManager;
        this.soundId = n;
    }

    @Override
    public void dispose() {
        this.soundPool.unload(this.soundId);
    }

    @Override
    public long loop() {
        return this.loop(1.0f);
    }

    @Override
    public long loop(float f) {
        int n;
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if ((n = this.soundPool.play(this.soundId, f, f, 1, -1, 1.0f)) == 0) {
            return -1L;
        }
        this.streamIds.insert(0, n);
        return n;
    }

    @Override
    public long loop(float f, float f2, float f3) {
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if (f3 < 0.0f) {
            float f4 = Math.abs(f3);
            f3 = f;
            f4 = f * (1.0f - f4);
            f = f3;
            f3 = f4;
        } else if (f3 > 0.0f) {
            float f5 = Math.abs(f3);
            f3 = f;
            f *= 1.0f - f5;
        } else {
            f3 = f;
        }
        int n = this.soundPool.play(this.soundId, f, f3, 1, -1, f2);
        if (n == 0) {
            return -1L;
        }
        this.streamIds.insert(0, n);
        return n;
    }

    @Override
    public void pause() {
        this.soundPool.autoPause();
    }

    @Override
    public void pause(long l) {
        this.soundPool.pause((int)l);
    }

    @Override
    public long play() {
        return this.play(1.0f);
    }

    @Override
    public long play(float f) {
        int n;
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if ((n = this.soundPool.play(this.soundId, f, f, 1, 0, 1.0f)) == 0) {
            return -1L;
        }
        this.streamIds.insert(0, n);
        return n;
    }

    @Override
    public long play(float f, float f2, float f3) {
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        if (f3 < 0.0f) {
            float f4 = Math.abs(f3);
            f3 = f;
            f4 = f * (1.0f - f4);
            f = f3;
            f3 = f4;
        } else if (f3 > 0.0f) {
            float f5 = Math.abs(f3);
            f3 = f;
            f *= 1.0f - f5;
        } else {
            f3 = f;
        }
        int n = this.soundPool.play(this.soundId, f, f3, 1, 0, f2);
        if (n == 0) {
            return -1L;
        }
        this.streamIds.insert(0, n);
        return n;
    }

    @Override
    public void resume() {
        this.soundPool.autoResume();
    }

    @Override
    public void resume(long l) {
        this.soundPool.resume((int)l);
    }

    @Override
    public void setLooping(long l, boolean bl) {
        SoundPool soundPool = this.soundPool;
        int n = (int)l;
        int n2 = bl ? -1 : 0;
        soundPool.setLoop(n, n2);
    }

    @Override
    public void setPan(long l, float f, float f2) {
        if (f < 0.0f) {
            f = f2 * (1.0f - Math.abs(f));
        } else if (f > 0.0f) {
            float f3 = f2 * (1.0f - Math.abs(f));
            f = f2;
            f2 = f3;
        } else {
            f = f2;
        }
        this.soundPool.setVolume((int)l, f2, f);
    }

    @Override
    public void setPitch(long l, float f) {
        this.soundPool.setRate((int)l, f);
    }

    @Override
    public void setVolume(long l, float f) {
        this.soundPool.setVolume((int)l, f, f);
    }

    @Override
    public void stop() {
        int n = this.streamIds.size;
        for (int i = 0; i < n; ++i) {
            this.soundPool.stop(this.streamIds.get(i));
        }
    }

    @Override
    public void stop(long l) {
        this.soundPool.stop((int)l);
    }
}

