/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Process;
import android.util.DisplayMetrics;
import android.view.View;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGL20;
import com.badlogic.gdx.backends.android.AndroidGL30;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20API18;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewAPI18;
import com.badlogic.gdx.backends.android.surfaceview.GdxEglConfigChooser;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureArray;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.WindowedMean;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SnapshotArray;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class AndroidGraphics
implements GLSurfaceView.Renderer,
Graphics {
    private static final String LOG_TAG = "AndroidGraphics";
    static volatile boolean enforceContinuousRendering;
    AndroidApplicationBase app;
    private Graphics.BufferFormat bufferFormat;
    protected final AndroidApplicationConfiguration config;
    volatile boolean created = false;
    protected float deltaTime = 0.0f;
    private float density = 1.0f;
    volatile boolean destroy = false;
    EGLContext eglContext;
    String extensions;
    protected int fps;
    protected long frameId = -1L;
    protected long frameStart;
    protected int frames = 0;
    GL20 gl20;
    GL30 gl30;
    GLVersion glVersion;
    int height;
    private boolean isContinuous = true;
    protected long lastFrameTime = System.nanoTime();
    protected WindowedMean mean;
    volatile boolean pause = false;
    private float ppcX = 0.0f;
    private float ppcY = 0.0f;
    private float ppiX = 0.0f;
    private float ppiY = 0.0f;
    volatile boolean resume = false;
    volatile boolean running = false;
    Object synch;
    int[] value;
    final View view;
    int width;

    public AndroidGraphics(AndroidApplicationBase androidApplicationBase, AndroidApplicationConfiguration androidApplicationConfiguration, ResolutionStrategy resolutionStrategy) {
        this(androidApplicationBase, androidApplicationConfiguration, resolutionStrategy, true);
    }

    public AndroidGraphics(AndroidApplicationBase androidApplicationBase, AndroidApplicationConfiguration androidApplicationConfiguration, ResolutionStrategy resolutionStrategy, boolean bl) {
        this.frameStart = System.nanoTime();
        this.mean = new WindowedMean(5);
        this.bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 0, 0, false);
        this.value = new int[1];
        this.synch = new Object();
        this.config = androidApplicationConfiguration;
        this.app = androidApplicationBase;
        this.view = this.createGLSurfaceView(androidApplicationBase, resolutionStrategy);
        this.preserveEGLContextOnPause();
        if (bl) {
            this.view.setFocusable(true);
            this.view.setFocusableInTouchMode(true);
        }
    }

    private int getAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
        if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.value)) {
            return this.value[0];
        }
        return n2;
    }

    protected boolean checkGL20() {
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        EGLDisplay eGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        eGL10.eglInitialize(eGLDisplay, new int[2]);
        EGLConfig[] eGLConfigArray = new EGLConfig[10];
        int[] nArray = new int[1];
        eGL10.eglChooseConfig(eGLDisplay, new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344}, eGLConfigArray, 10, nArray);
        eGL10.eglTerminate(eGLDisplay);
        boolean bl = false;
        if (nArray[0] > 0) {
            bl = true;
        }
        return bl;
    }

    public void clearManagedCaches() {
        Mesh.clearAllMeshes(this.app);
        Texture.clearAllTextures(this.app);
        Cubemap.clearAllCubemaps(this.app);
        TextureArray.clearAllTextureArrays(this.app);
        ShaderProgram.clearAllShaderPrograms(this.app);
        FrameBuffer.clearAllFrameBuffers(this.app);
        this.logManagedCachesStatus();
    }

    protected View createGLSurfaceView(AndroidApplicationBase object, ResolutionStrategy resolutionStrategy) {
        if (this.checkGL20()) {
            GLSurfaceView.EGLConfigChooser eGLConfigChooser = this.getEglConfigChooser();
            if (Build.VERSION.SDK_INT <= 10 && this.config.useGLSurfaceView20API18) {
                object = new GLSurfaceView20API18(object.getContext(), resolutionStrategy);
                if (eGLConfigChooser != null) {
                    ((GLSurfaceViewAPI18)((Object)object)).setEGLConfigChooser(eGLConfigChooser);
                } else {
                    ((GLSurfaceViewAPI18)((Object)object)).setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
                }
                ((GLSurfaceViewAPI18)((Object)object)).setRenderer(this);
                return object;
            }
            object = object.getContext();
            int n = this.config.useGL30 ? 3 : 2;
            object = new GLSurfaceView20((Context)object, resolutionStrategy, n);
            if (eGLConfigChooser != null) {
                object.setEGLConfigChooser(eGLConfigChooser);
            } else {
                object.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            object.setRenderer((GLSurfaceView.Renderer)this);
            return object;
        }
        throw new GdxRuntimeException("Libgdx requires OpenGL ES 2.0");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void destroy() {
        Object object = this.synch;
        synchronized (object) {
            boolean bl;
            this.running = false;
            this.destroy = true;
            while (bl = this.destroy) {
                try {
                    this.synch.wait();
                }
                catch (InterruptedException interruptedException) {
                    Gdx.app.log(LOG_TAG, "waiting for destroy synchronization failed!");
                }
            }
            return;
        }
    }

    @Override
    public int getBackBufferHeight() {
        return this.height;
    }

    @Override
    public int getBackBufferWidth() {
        return this.width;
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public float getDeltaTime() {
        float f = this.mean.getMean() == 0.0f ? this.deltaTime : this.mean.getMean();
        return f;
    }

    @Override
    public float getDensity() {
        return this.density;
    }

    @Override
    public Graphics.DisplayMode getDisplayMode() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return new AndroidDisplayMode(displayMetrics.widthPixels, displayMetrics.heightPixels, 0, 0);
    }

    @Override
    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDisplayMode()};
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    protected GLSurfaceView.EGLConfigChooser getEglConfigChooser() {
        return new GdxEglConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.numSamples);
    }

    @Override
    public long getFrameId() {
        return this.frameId;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public GL20 getGL20() {
        return this.gl20;
    }

    @Override
    public GL30 getGL30() {
        return this.gl30;
    }

    @Override
    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    @Override
    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    @Override
    public float getPpcX() {
        return this.ppcX;
    }

    @Override
    public float getPpcY() {
        return this.ppcY;
    }

    @Override
    public float getPpiX() {
        return this.ppiX;
    }

    @Override
    public float getPpiY() {
        return this.ppiY;
    }

    @Override
    public Graphics.Monitor getPrimaryMonitor() {
        return new AndroidMonitor(0, 0, "Primary Monitor");
    }

    @Override
    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.AndroidGL;
    }

    public View getView() {
        return this.view;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    @Override
    public boolean isGL30Available() {
        boolean bl = this.gl30 != null;
        return bl;
    }

    protected void logConfig(EGLConfig object) {
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        Object object2 = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int n = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12324, 0);
        int n2 = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12323, 0);
        int n3 = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12322, 0);
        int n4 = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12321, 0);
        int n5 = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12325, 0);
        int n6 = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12326, 0);
        int n7 = Math.max(this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12337, 0), this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12513, 0));
        boolean bl = this.getAttrib(eGL10, (EGLDisplay)object2, (EGLConfig)object, 12513, 0) != 0;
        object = Gdx.app;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("framebuffer: (");
        ((StringBuilder)object2).append(n);
        ((StringBuilder)object2).append(", ");
        ((StringBuilder)object2).append(n2);
        ((StringBuilder)object2).append(", ");
        ((StringBuilder)object2).append(n3);
        ((StringBuilder)object2).append(", ");
        ((StringBuilder)object2).append(n4);
        ((StringBuilder)object2).append(")");
        object.log(LOG_TAG, ((StringBuilder)object2).toString());
        object = Gdx.app;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("depthbuffer: (");
        ((StringBuilder)object2).append(n5);
        ((StringBuilder)object2).append(")");
        object.log(LOG_TAG, ((StringBuilder)object2).toString());
        object2 = Gdx.app;
        object = new StringBuilder();
        ((StringBuilder)object).append("stencilbuffer: (");
        ((StringBuilder)object).append(n6);
        ((StringBuilder)object).append(")");
        object2.log(LOG_TAG, ((StringBuilder)object).toString());
        object2 = Gdx.app;
        object = new StringBuilder();
        ((StringBuilder)object).append("samples: (");
        ((StringBuilder)object).append(n7);
        ((StringBuilder)object).append(")");
        object2.log(LOG_TAG, ((StringBuilder)object).toString());
        object = Gdx.app;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("coverage sampling: (");
        ((StringBuilder)object2).append(bl);
        ((StringBuilder)object2).append(")");
        object.log(LOG_TAG, ((StringBuilder)object2).toString());
        this.bufferFormat = new Graphics.BufferFormat(n, n2, n3, n4, n5, n6, n7, bl);
    }

    protected void logManagedCachesStatus() {
        Gdx.app.log(LOG_TAG, Mesh.getManagedStatus());
        Gdx.app.log(LOG_TAG, Texture.getManagedStatus());
        Gdx.app.log(LOG_TAG, Cubemap.getManagedStatus());
        Gdx.app.log(LOG_TAG, ShaderProgram.getManagedStatus());
        Gdx.app.log(LOG_TAG, FrameBuffer.getManagedStatus());
    }

    @Override
    public Cursor newCursor(Pixmap pixmap, int n, int n2) {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDrawFrame(GL10 object) {
        int n;
        int n2;
        LifecycleListener[] lifecycleListenerArray;
        boolean bl;
        boolean bl2;
        boolean bl3;
        long l;
        block34: {
            l = System.nanoTime();
            this.deltaTime = (float)(l - this.lastFrameTime) / 1.0E9f;
            this.lastFrameTime = l;
            if (!this.resume) {
                this.mean.addValue(this.deltaTime);
            } else {
                this.deltaTime = 0.0f;
            }
            object = this.synch;
            synchronized (object) {
                bl3 = this.running;
                bl2 = this.pause;
                bl = this.destroy;
                boolean bl4 = this.resume;
                if (this.resume) {
                    this.resume = false;
                }
                if (this.pause) {
                    this.pause = false;
                    this.synch.notifyAll();
                }
                if (this.destroy) {
                    this.destroy = false;
                    this.synch.notifyAll();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 14] lbl23 : MonitorExitStatement: MONITOREXIT : var1_1
                if (!bl4) break block34;
                object = this.app.getLifecycleListeners();
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                lifecycleListenerArray = (LifecycleListener[])((SnapshotArray)object).begin();
                n2 = ((SnapshotArray)object).size;
                for (n = 0; n < n2; ++n) {
                    lifecycleListenerArray[n].resume();
                }
                ((SnapshotArray)object).end();
            }
            this.app.getApplicationListener().resume();
            Gdx.app.log(LOG_TAG, "resumed");
        }
        if (bl3) {
            lifecycleListenerArray = this.app.getRunnables();
            synchronized (lifecycleListenerArray) {
                this.app.getExecutedRunnables().clear();
                this.app.getExecutedRunnables().addAll(this.app.getRunnables());
                this.app.getRunnables().clear();
            }
            for (n = 0; n < this.app.getExecutedRunnables().size; ++n) {
                try {
                    this.app.getExecutedRunnables().get(n).run();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.app.getInput().processEvents();
            ++this.frameId;
            this.app.getApplicationListener().render();
        }
        if (bl2) {
            object = this.app.getLifecycleListeners();
            synchronized (object) {
                lifecycleListenerArray = (LifecycleListener[])((SnapshotArray)object).begin();
                n2 = ((SnapshotArray)object).size;
                for (n = 0; n < n2; ++n) {
                    lifecycleListenerArray[n].pause();
                }
            }
            this.app.getApplicationListener().pause();
            Gdx.app.log(LOG_TAG, "paused");
        }
        if (bl) {
            object = this.app.getLifecycleListeners();
            synchronized (object) {
                lifecycleListenerArray = (LifecycleListener[])((SnapshotArray)object).begin();
                n2 = ((SnapshotArray)object).size;
                for (n = 0; n < n2; ++n) {
                    lifecycleListenerArray[n].dispose();
                }
            }
            this.app.getApplicationListener().dispose();
            Gdx.app.log(LOG_TAG, "destroyed");
        }
        if (l - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = l;
        }
        ++this.frames;
    }

    public void onPauseGLSurfaceView() {
        View view = this.view;
        if (view != null) {
            if (view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)view).onPause();
            }
            if ((view = this.view) instanceof GLSurfaceView) {
                ((GLSurfaceView)view).onPause();
            }
        }
    }

    public void onResumeGLSurfaceView() {
        View view = this.view;
        if (view != null) {
            if (view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)view).onResume();
            }
            if ((view = this.view) instanceof GLSurfaceView) {
                ((GLSurfaceView)view).onResume();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.updatePpi();
        gL10.glViewport(0, 0, this.width, this.height);
        if (!this.created) {
            this.app.getApplicationListener().create();
            this.created = true;
            synchronized (this) {
                this.running = true;
            }
        }
        this.app.getApplicationListener().resize(n, n2);
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        this.setupGL(gL10);
        this.logConfig(eGLConfig);
        this.updatePpi();
        Mesh.invalidateAllMeshes(this.app);
        Texture.invalidateAllTextures(this.app);
        Cubemap.invalidateAllCubemaps(this.app);
        TextureArray.invalidateAllTextureArrays(this.app);
        ShaderProgram.invalidateAllShaderPrograms(this.app);
        FrameBuffer.invalidateAllFrameBuffers(this.app);
        this.logManagedCachesStatus();
        eGLConfig = this.app.getWindowManager().getDefaultDisplay();
        this.width = eGLConfig.getWidth();
        this.height = eGLConfig.getHeight();
        this.mean = new WindowedMean(5);
        this.lastFrameTime = System.nanoTime();
        gL10.glViewport(0, 0, this.width, this.height);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void pause() {
        Object object = this.synch;
        synchronized (object) {
            boolean bl;
            if (!this.running) {
                return;
            }
            this.running = false;
            this.pause = true;
            while (bl = this.pause) {
                try {
                    this.synch.wait(4000L);
                    if (!this.pause) continue;
                    Gdx.app.error(LOG_TAG, "waiting for pause synchronization took too long; assuming deadlock and killing");
                    Process.killProcess((int)Process.myPid());
                }
                catch (InterruptedException interruptedException) {
                    Gdx.app.log(LOG_TAG, "waiting for pause synchronization failed!");
                }
            }
            return;
        }
    }

    protected void preserveEGLContextOnPause() {
        if (Build.VERSION.SDK_INT >= 11 && this.view instanceof GLSurfaceView20 || this.view instanceof GLSurfaceView20API18) {
            try {
                this.view.getClass().getMethod("setPreserveEGLContextOnPause", Boolean.TYPE).invoke((Object)this.view, true);
            }
            catch (Exception exception) {
                Gdx.app.log(LOG_TAG, "Method GLSurfaceView.setPreserveEGLContextOnPause not found");
            }
        }
    }

    @Override
    public void requestRendering() {
        View view = this.view;
        if (view != null) {
            if (view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)view).requestRender();
            }
            if ((view = this.view) instanceof GLSurfaceView) {
                ((GLSurfaceView)view).requestRender();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resume() {
        Object object = this.synch;
        synchronized (object) {
            this.running = true;
            this.resume = true;
            return;
        }
    }

    @Override
    public void setContinuousRendering(boolean bl) {
        if (this.view != null) {
            bl = enforceContinuousRendering || bl;
            this.isContinuous = bl;
            int n = this.isContinuous;
            View view = this.view;
            if (view instanceof GLSurfaceViewAPI18) {
                ((GLSurfaceViewAPI18)view).setRenderMode(n);
            }
            if ((view = this.view) instanceof GLSurfaceView) {
                ((GLSurfaceView)view).setRenderMode(n);
            }
            this.mean.clear();
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    @Override
    public void setGL20(GL20 gL20) {
        this.gl20 = gL20;
        if (this.gl30 == null) {
            Gdx.gl = gL20;
            Gdx.gl20 = gL20;
        }
    }

    @Override
    public void setGL30(GL30 gL30) {
        this.gl30 = gL30;
        if (gL30 != null) {
            GL20 gL20;
            Gdx.gl = gL20 = (this.gl20 = gL30);
            Gdx.gl20 = gL20;
            Gdx.gl30 = gL30;
        }
    }

    @Override
    public void setResizable(boolean bl) {
    }

    @Override
    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    @Override
    public void setTitle(String string2) {
    }

    @Override
    public void setUndecorated(boolean bl) {
        this.app.getApplicationWindow().setFlags(1024, bl ? 1 : 0);
    }

    @Override
    public void setVSync(boolean bl) {
    }

    @Override
    public boolean setWindowedMode(int n, int n2) {
        return false;
    }

    protected void setupGL(GL10 gL10) {
        String string2 = gL10.glGetString(7938);
        Object object = gL10.glGetString(7936);
        Object object2 = gL10.glGetString(7937);
        this.glVersion = new GLVersion(Application.ApplicationType.Android, string2, (String)object, (String)object2);
        if (this.config.useGL30 && this.glVersion.getMajorVersion() > 2) {
            if (this.gl30 != null) {
                return;
            }
            this.gl30 = object = new AndroidGL30();
            this.gl20 = object;
            Gdx.gl = object = this.gl30;
            Gdx.gl20 = object;
            Gdx.gl30 = object;
        } else {
            if (this.gl20 != null) {
                return;
            }
            this.gl20 = new AndroidGL20();
            Gdx.gl = object = this.gl20;
            Gdx.gl20 = object;
        }
        object2 = Gdx.app;
        object = new StringBuilder();
        ((StringBuilder)object).append("OGL renderer: ");
        ((StringBuilder)object).append(gL10.glGetString(7937));
        object2.log(LOG_TAG, ((StringBuilder)object).toString());
        object = Gdx.app;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("OGL vendor: ");
        ((StringBuilder)object2).append(gL10.glGetString(7936));
        object.log(LOG_TAG, ((StringBuilder)object2).toString());
        object = Gdx.app;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("OGL version: ");
        ((StringBuilder)object2).append(gL10.glGetString(7938));
        object.log(LOG_TAG, ((StringBuilder)object2).toString());
        object = Gdx.app;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("OGL extensions: ");
        ((StringBuilder)object2).append(gL10.glGetString(7939));
        object.log(LOG_TAG, ((StringBuilder)object2).toString());
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return false;
    }

    @Override
    public boolean supportsExtension(String string2) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(string2);
    }

    protected void updatePpi() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.app.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        this.ppiX = displayMetrics.xdpi;
        this.ppiY = displayMetrics.ydpi;
        this.ppcX = displayMetrics.xdpi / 2.54f;
        this.ppcY = displayMetrics.ydpi / 2.54f;
        this.density = displayMetrics.density;
    }

    private class AndroidDisplayMode
    extends Graphics.DisplayMode {
        protected AndroidDisplayMode(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }
    }

    private class AndroidMonitor
    extends Graphics.Monitor {
        public AndroidMonitor(int n, int n2, String string2) {
            super(n, n2, string2);
        }
    }
}

