/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.APKExpansionSupport;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidZipFileHandle;
import com.badlogic.gdx.backends.android.ZipResourceFile;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;

public class AndroidFiles
implements Files {
    protected final AssetManager assets;
    private ZipResourceFile expansionFile;
    protected final String localpath;
    protected final String sdcard;

    public AndroidFiles(AssetManager assetManager) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Environment.getExternalStorageDirectory().getAbsolutePath());
        stringBuilder.append("/");
        this.sdcard = stringBuilder.toString();
        this.expansionFile = null;
        this.assets = assetManager;
        this.localpath = this.sdcard;
    }

    public AndroidFiles(AssetManager object, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Environment.getExternalStorageDirectory().getAbsolutePath());
        stringBuilder.append("/");
        this.sdcard = stringBuilder.toString();
        this.expansionFile = null;
        this.assets = object;
        if (!string2.endsWith("/")) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("/");
            string2 = ((StringBuilder)object).toString();
        }
        this.localpath = string2;
    }

    private FileHandle getZipFileHandleIfExists(FileHandle fileHandle, String object) {
        try {
            this.assets.open((String)object).close();
            return fileHandle;
        }
        catch (Exception exception) {
            object = new AndroidZipFileHandle((String)object);
            if (!((FileHandle)object).isDirectory()) {
                return object;
            }
            if (((FileHandle)object).exists()) {
                return object;
            }
            return fileHandle;
        }
    }

    @Override
    public FileHandle absolute(String string2) {
        return new AndroidFileHandle(null, string2, Files.FileType.Absolute);
    }

    @Override
    public FileHandle classpath(String string2) {
        return new AndroidFileHandle(null, string2, Files.FileType.Classpath);
    }

    @Override
    public FileHandle external(String string2) {
        return new AndroidFileHandle(null, string2, Files.FileType.External);
    }

    public ZipResourceFile getExpansionFile() {
        return this.expansionFile;
    }

    @Override
    public String getExternalStoragePath() {
        return this.sdcard;
    }

    @Override
    public FileHandle getFileHandle(String string2, Files.FileType fileType) {
        Object object = fileType == Files.FileType.Internal ? this.assets : null;
        AndroidFileHandle androidFileHandle = new AndroidFileHandle((AssetManager)object, string2, fileType);
        object = androidFileHandle;
        if (this.expansionFile != null) {
            object = androidFileHandle;
            if (fileType == Files.FileType.Internal) {
                object = this.getZipFileHandleIfExists(androidFileHandle, string2);
            }
        }
        return object;
    }

    @Override
    public String getLocalStoragePath() {
        return this.localpath;
    }

    @Override
    public FileHandle internal(String string2) {
        AndroidFileHandle androidFileHandle;
        FileHandle fileHandle = androidFileHandle = new AndroidFileHandle(this.assets, string2, Files.FileType.Internal);
        if (this.expansionFile != null) {
            fileHandle = this.getZipFileHandleIfExists(androidFileHandle, string2);
        }
        return fileHandle;
    }

    @Override
    public boolean isExternalStorageAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    @Override
    public boolean isLocalStorageAvailable() {
        return true;
    }

    @Override
    public FileHandle local(String string2) {
        return new AndroidFileHandle(null, string2, Files.FileType.Local);
    }

    public boolean setAPKExpansion(int n, int n2) {
        block5: {
            try {
                Context context;
                if (Gdx.app instanceof Activity) {
                    context = ((Activity)Gdx.app).getBaseContext();
                } else {
                    if (!(Gdx.app instanceof Fragment)) break block5;
                    context = ((Fragment)Gdx.app).getActivity().getBaseContext();
                }
                this.expansionFile = APKExpansionSupport.getAPKExpansionZipFile(context, n, n2);
                boolean bl = this.expansionFile != null;
                return bl;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("APK expansion main version ");
                stringBuilder.append(n);
                stringBuilder.append(" or patch version ");
                stringBuilder.append(n2);
                stringBuilder.append(" couldn't be opened!");
                throw new GdxRuntimeException(stringBuilder.toString());
            }
        }
        GdxRuntimeException gdxRuntimeException = new GdxRuntimeException("APK expansion not supported for application type");
        throw gdxRuntimeException;
    }
}

