/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lz;

import java.io.IOException;
import java.io.OutputStream;

public class OutWindow {
    byte[] _buffer;
    int _pos;
    OutputStream _stream;
    int _streamPos;
    int _windowSize = 0;

    public void CopyBlock(int n, int n2) throws IOException {
        int n3;
        n = n3 = this._pos - n - 1;
        int n4 = n2;
        if (n3 < 0) {
            n = n3 + this._windowSize;
            n4 = n2;
        }
        while (n4 != 0) {
            n2 = n;
            if (n >= this._windowSize) {
                n2 = 0;
            }
            byte[] byArray = this._buffer;
            n = this._pos;
            this._pos = n + 1;
            byArray[n] = byArray[n2];
            if (this._pos >= this._windowSize) {
                this.Flush();
            }
            --n4;
            n = n2 + 1;
        }
    }

    public void Create(int n) {
        if (this._buffer == null || this._windowSize != n) {
            this._buffer = new byte[n];
        }
        this._windowSize = n;
        this._pos = 0;
        this._streamPos = 0;
    }

    public void Flush() throws IOException {
        int n = this._pos;
        int n2 = this._streamPos;
        if ((n -= n2) == 0) {
            return;
        }
        this._stream.write(this._buffer, n2, n);
        if (this._pos >= this._windowSize) {
            this._pos = 0;
        }
        this._streamPos = this._pos;
    }

    public byte GetByte(int n) {
        int n2;
        n = n2 = this._pos - n - 1;
        if (n2 < 0) {
            n = n2 + this._windowSize;
        }
        return this._buffer[n];
    }

    public void Init(boolean bl) {
        if (!bl) {
            this._streamPos = 0;
            this._pos = 0;
        }
    }

    public void PutByte(byte by) throws IOException {
        byte[] byArray = this._buffer;
        int n = this._pos;
        this._pos = n + 1;
        byArray[n] = by;
        if (this._pos >= this._windowSize) {
            this.Flush();
        }
    }

    public void ReleaseStream() throws IOException {
        this.Flush();
        this._stream = null;
    }

    public void SetStream(OutputStream outputStream) throws IOException {
        this.ReleaseStream();
        this._stream = outputStream;
    }
}

