/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharedLibraryLoader {
    public static String abi;
    public static boolean is64Bit;
    public static boolean isARM;
    public static boolean isAndroid;
    public static boolean isIos;
    public static boolean isLinux;
    public static boolean isMac;
    public static boolean isWindows;
    private static final HashSet<String> loadedLibraries;
    private String nativesJar;

    static {
        isWindows = System.getProperty("os.name").contains("Windows");
        isLinux = System.getProperty("os.name").contains("Linux");
        isMac = System.getProperty("os.name").contains("Mac");
        isIos = false;
        isAndroid = false;
        isARM = System.getProperty("os.arch").startsWith("arm");
        boolean bl = System.getProperty("os.arch").equals("amd64") || System.getProperty("os.arch").equals("x86_64");
        is64Bit = bl;
        String string2 = System.getProperty("sun.arch.abi") != null ? System.getProperty("sun.arch.abi") : "";
        abi = string2;
        bl = "iOS".equals(System.getProperty("moe.platform.name"));
        string2 = System.getProperty("java.runtime.name");
        if (string2 != null && string2.contains("Android Runtime")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        if (bl || !isAndroid && !isWindows && !isLinux && !isMac) {
            isIos = true;
            isAndroid = false;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        loadedLibraries = new HashSet();
    }

    public SharedLibraryLoader() {
    }

    public SharedLibraryLoader(String string2) {
        this.nativesJar = string2;
    }

    private boolean canExecute(File file) {
        Method method;
        block3: {
            try {
                method = File.class.getMethod("canExecute", new Class[0]);
                if (!((Boolean)method.invoke((Object)file, new Object[0])).booleanValue()) break block3;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE).invoke((Object)file, true, false);
        boolean bl = (Boolean)method.invoke((Object)file, new Object[0]);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canWrite(File file) {
        block6: {
            Object object = file.getParentFile();
            if (file.exists()) {
                if (!file.canWrite() || !this.canExecute(file)) return false;
                file = new File((File)object, UUID.randomUUID().toString());
            } else {
                ((File)object).mkdirs();
                if (!((File)object).isDirectory()) {
                    return false;
                }
            }
            try {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).close();
                boolean bl = this.canExecute(file);
                if (bl) break block6;
                file.delete();
            }
            catch (Throwable throwable) {
                file.delete();
                throw throwable;
            }
            catch (Throwable throwable) {
                file.delete();
                return false;
            }
            return false;
        }
        file.delete();
        return true;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File extractFile(String string2, String object, File file) throws IOException {
        Object object2;
        block19: {
            void var1_6;
            block17: {
                StringBuilder stringBuilder;
                block18: {
                    boolean bl = file.exists();
                    byte[] byArray = null;
                    stringBuilder = null;
                    if (bl) {
                        try {
                            object2 = new FileInputStream(file);
                            object2 = this.crc((InputStream)object2);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                    object2 = null;
                    if (object2 != null) {
                        if (((String)object2).equals(object)) return file;
                    }
                    object = this.readFile(string2);
                    file.getParentFile().mkdirs();
                    object2 = new FileOutputStream(file);
                    try {
                        int n;
                        block20: {
                            byArray = new byte[4096];
                            break block20;
                            catch (Throwable throwable) {
                                object2 = null;
                                break block17;
                            }
                            catch (IOException iOException) {
                                object2 = null;
                                break block18;
                            }
                            catch (Throwable throwable) {
                                object2 = null;
                                object = byArray;
                                break block17;
                            }
                            catch (IOException iOException) {
                                object2 = null;
                                object = stringBuilder;
                                break block18;
                            }
                        }
                        while ((n = ((InputStream)object).read(byArray)) != -1) {
                            ((FileOutputStream)object2).write(byArray, 0, n);
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        break block17;
                    }
                    catch (IOException iOException) {}
                }
                try {
                    void var5_14;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Error extracting file: ");
                    stringBuilder.append(string2);
                    stringBuilder.append("\nTo: ");
                    stringBuilder.append(file.getAbsolutePath());
                    GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(stringBuilder.toString(), (Throwable)var5_14);
                    throw gdxRuntimeException;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            StreamUtils.closeQuietly((Closeable)object);
            StreamUtils.closeQuietly((Closeable)object2);
            throw var1_6;
        }
        StreamUtils.closeQuietly((Closeable)object);
        StreamUtils.closeQuietly((Closeable)object2);
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getExtractedFile(String object, String string2) {
        Comparable<File> comparable;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("java.io.tmpdir"));
        stringBuilder.append("/libgdx");
        stringBuilder.append(System.getProperty("user.name"));
        stringBuilder.append("/");
        stringBuilder.append((String)object);
        File file = new File(stringBuilder.toString(), string2);
        if (this.canWrite(file)) {
            return file;
        }
        try {
            File file2;
            boolean bl;
            comparable = File.createTempFile((String)object, null);
            if (((File)comparable).delete() && (bl = this.canWrite(file2 = new File((File)comparable, string2)))) {
                return file2;
            }
        }
        catch (IOException iOException) {}
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(System.getProperty("user.home"));
        ((StringBuilder)comparable).append("/.libgdx/");
        ((StringBuilder)comparable).append((String)object);
        comparable = new File(((StringBuilder)comparable).toString(), string2);
        if (this.canWrite((File)comparable)) {
            return comparable;
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(".temp/");
        ((StringBuilder)comparable).append((String)object);
        object = new File(((StringBuilder)comparable).toString(), string2);
        if (this.canWrite((File)object)) {
            return object;
        }
        if (System.getenv("APP_SANDBOX_CONTAINER_ID") != null) {
            return file;
        }
        return null;
    }

    public static boolean isLoaded(String string2) {
        synchronized (SharedLibraryLoader.class) {
            boolean bl = loadedLibraries.contains(string2);
            return bl;
        }
    }

    private Throwable loadFile(String string2, String string3, File file) {
        try {
            System.load(this.extractFile(string2, string3, file).getAbsolutePath());
            return null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFile(String object) {
        Serializable serializable;
        String string2 = this.crc(this.readFile((String)object));
        String string3 = new File((String)object).getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("java.io.tmpdir"));
        stringBuilder.append("/libgdx");
        stringBuilder.append(System.getProperty("user.name"));
        stringBuilder.append("/");
        stringBuilder.append(string2);
        Throwable throwable = this.loadFile((String)object, string2, new File(stringBuilder.toString(), string3));
        if (throwable == null) {
            return;
        }
        try {
            serializable = File.createTempFile(string2, null);
            if (((File)serializable).delete() && (serializable = this.loadFile((String)object, string2, (File)serializable)) == null) {
                return;
            }
        }
        catch (Throwable throwable2) {}
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(System.getProperty("user.home"));
        ((StringBuilder)serializable).append("/.libgdx/");
        ((StringBuilder)serializable).append(string2);
        if (this.loadFile((String)object, string2, new File(((StringBuilder)serializable).toString(), string3)) == null) {
            return;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(".temp/");
        ((StringBuilder)serializable).append(string2);
        if (this.loadFile((String)object, string2, new File(((StringBuilder)serializable).toString(), string3)) == null) {
            return;
        }
        object = new File(System.getProperty("java.library.path"), (String)object);
        if (((File)object).exists()) {
            System.load(((File)object).getAbsolutePath());
            return;
        }
        throw new GdxRuntimeException(throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream readFile(String string2) {
        Object object = this.nativesJar;
        if (object == null) {
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("/");
            ((StringBuilder)object2).append(string2);
            object2 = SharedLibraryLoader.class.getResourceAsStream(((StringBuilder)object2).toString());
            if (object2 != null) {
                return object2;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unable to read file for extraction: ");
            ((StringBuilder)object2).append(string2);
            throw new GdxRuntimeException(((StringBuilder)object2).toString());
        }
        try {
            Object object3 = new ZipFile((String)object);
            object = ((ZipFile)object3).getEntry(string2);
            if (object != null) {
                return ((ZipFile)object3).getInputStream((ZipEntry)object);
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Couldn't find '");
            ((StringBuilder)object3).append(string2);
            ((StringBuilder)object3).append("' in JAR: ");
            ((StringBuilder)object3).append(this.nativesJar);
            object = new GdxRuntimeException(((StringBuilder)object3).toString());
            throw object;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error reading '");
            stringBuilder.append(string2);
            stringBuilder.append("' in JAR: ");
            stringBuilder.append(this.nativesJar);
            throw new GdxRuntimeException(stringBuilder.toString(), iOException);
        }
    }

    public static void setLoaded(String string2) {
        synchronized (SharedLibraryLoader.class) {
            loadedLibraries.add(string2);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String crc(InputStream var1_1) {
        if (var1_1 != null) {
            block7: {
                var2_2 = new CRC32();
                var3_4 = new byte[4096];
                while (true) {
                    var4_6 = var1_1.read(var3_4);
                    if (var4_6 == -1) break block7;
                    var2_2.update(var3_4, 0, var4_6);
                    continue;
                    break;
                }
                catch (Throwable var2_3) {
                    StreamUtils.closeQuietly((Closeable)var1_1);
                    throw var2_3;
                }
            }
lbl15:
            // 2 sources

            while (true) {
                StreamUtils.closeQuietly((Closeable)var1_1);
                return Long.toString(var2_2.getValue(), 16);
            }
        }
        var1_1 = new IllegalArgumentException("input cannot be null.");
        throw var1_1;
        catch (Exception var3_5) {
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File extractFile(String object, String object2) throws IOException {
        Object object3;
        String string2;
        block5: {
            try {
                string2 = this.crc(this.readFile((String)object));
                object3 = object2;
                if (object2 != null) break block5;
                object3 = string2;
            }
            catch (RuntimeException runtimeException) {
                object = new File(System.getProperty("java.library.path"), (String)object);
                if (!((File)object).exists()) throw runtimeException;
                return object;
            }
        }
        object2 = new File((String)object);
        object2 = object3 = this.getExtractedFile((String)object3, ((File)object2).getName());
        if (object3 != null) return this.extractFile((String)object, string2, (File)object2);
        object3 = UUID.randomUUID().toString();
        object2 = new File((String)object);
        object2 = this.getExtractedFile((String)object3, ((File)object2).getName());
        if (object2 != null) return this.extractFile((String)object, string2, (File)object2);
        object2 = new GdxRuntimeException("Unable to find writable path to extract file. Is the user home directory writable?");
        throw object2;
    }

    public void extractFileTo(String string2, File file) throws IOException {
        this.extractFile(string2, this.crc(this.readFile(string2)), new File(file, new File(string2).getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String string2) {
        if (isIos) {
            return;
        }
        synchronized (SharedLibraryLoader.class) {
            if (SharedLibraryLoader.isLoaded(string2)) {
                return;
            }
            String string3 = this.mapLibraryName(string2);
            try {
                if (isAndroid) {
                    System.loadLibrary(string3);
                } else {
                    this.loadFile(string3);
                }
                SharedLibraryLoader.setLoaded(string2);
            }
            catch (Throwable throwable) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Couldn't load shared library '");
                stringBuilder.append(string3);
                stringBuilder.append("' for target: ");
                stringBuilder.append(System.getProperty("os.name"));
                string2 = is64Bit ? ", 64-bit" : ", 32-bit";
                stringBuilder.append(string2);
                GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(stringBuilder.toString(), throwable);
                throw gdxRuntimeException;
            }
            return;
        }
    }

    public String mapLibraryName(String charSequence) {
        if (isWindows) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            charSequence = is64Bit ? "64.dll" : ".dll";
            stringBuilder.append((String)charSequence);
            return stringBuilder.toString();
        }
        if (isLinux) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("lib");
            stringBuilder.append((String)charSequence);
            if (isARM) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("arm");
                ((StringBuilder)charSequence).append(abi);
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = "";
            }
            stringBuilder.append((String)charSequence);
            charSequence = is64Bit ? "64.so" : ".so";
            stringBuilder.append((String)charSequence);
            return stringBuilder.toString();
        }
        CharSequence charSequence2 = charSequence;
        if (isMac) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("lib");
            ((StringBuilder)charSequence2).append((String)charSequence);
            charSequence = is64Bit ? "64.dylib" : ".dylib";
            ((StringBuilder)charSequence2).append((String)charSequence);
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        return charSequence2;
    }
}

