/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class LongArray {
    public long[] items;
    public boolean ordered;
    public int size;

    public LongArray() {
        this(true, 16);
    }

    public LongArray(int n) {
        this(true, n);
    }

    public LongArray(LongArray longArray) {
        this.ordered = longArray.ordered;
        int n = this.size = longArray.size;
        this.items = new long[n];
        System.arraycopy(longArray.items, 0, this.items, 0, n);
    }

    public LongArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new long[n];
    }

    public LongArray(boolean bl, long[] lArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(lArray, n, this.items, 0, n2);
    }

    public LongArray(long[] lArray) {
        this(true, lArray, 0, lArray.length);
    }

    public static LongArray with(long ... lArray) {
        return new LongArray(lArray);
    }

    public void add(long l) {
        long[] lArray = this.items;
        int n = this.size;
        long[] lArray2 = lArray;
        if (n == lArray.length) {
            lArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        lArray2[n] = l;
    }

    public void add(long l, long l2) {
        long[] lArray = this.items;
        int n = this.size;
        long[] lArray2 = lArray;
        if (n + 1 >= lArray.length) {
            lArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        lArray2[n] = l;
        lArray2[n + 1] = l2;
        this.size = n + 2;
    }

    public void add(long l, long l2, long l3) {
        long[] lArray = this.items;
        int n = this.size;
        long[] lArray2 = lArray;
        if (n + 2 >= lArray.length) {
            lArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        lArray2[n] = l;
        lArray2[n + 1] = l2;
        lArray2[n + 2] = l3;
        this.size = n + 3;
    }

    public void add(long l, long l2, long l3, long l4) {
        long[] lArray = this.items;
        int n = this.size;
        long[] lArray2 = lArray;
        if (n + 3 >= lArray.length) {
            lArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        lArray2[n] = l;
        lArray2[n + 1] = l2;
        lArray2[n + 2] = l3;
        lArray2[n + 3] = l4;
        this.size = n + 4;
    }

    public void addAll(LongArray longArray) {
        this.addAll(longArray.items, 0, longArray.size);
    }

    public void addAll(LongArray longArray, int n, int n2) {
        if (n + n2 <= longArray.size) {
            this.addAll(longArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(longArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(long ... lArray) {
        this.addAll(lArray, 0, lArray.length);
    }

    public void addAll(long[] lArray, int n, int n2) {
        long[] lArray2 = this.items;
        int n3 = this.size + n2;
        long[] lArray3 = lArray2;
        if (n3 > lArray2.length) {
            lArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(lArray, n, lArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(long l) {
        long[] lArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (lArray[i] != l) continue;
            return true;
        }
        return false;
    }

    public long[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof LongArray)) {
            return false;
        }
        Object object2 = (LongArray)object;
        if (!((LongArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((LongArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((LongArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public long first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public long get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        long[] lArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + (int)(lArray[i] ^ lArray[i] >>> 32);
        }
        return n2;
    }

    public void incr(int n, long l) {
        if (n < this.size) {
            long[] lArray = this.items;
            lArray[n] = lArray[n] + l;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int indexOf(long l) {
        long[] lArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] != l) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, long l) {
        int n2 = this.size;
        if (n <= n2) {
            long[] lArray;
            long[] lArray2 = lArray = this.items;
            if (n2 == lArray.length) {
                lArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(lArray2, n, lArray2, n + 1, this.size - n);
            } else {
                lArray2[this.size] = lArray2[n];
            }
            ++this.size;
            lArray2[n] = l;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public int lastIndexOf(char c) {
        long[] lArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (lArray[i] != (long)c) continue;
            return i;
        }
        return -1;
    }

    public void mul(int n, long l) {
        if (n < this.size) {
            long[] lArray = this.items;
            lArray[n] = lArray[n] * l;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public long peek() {
        return this.items[this.size - 1];
    }

    public long pop() {
        int n;
        long[] lArray = this.items;
        this.size = n = this.size - 1;
        return lArray[n];
    }

    public long random() {
        int n = this.size;
        if (n == 0) {
            return 0L;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(LongArray longArray) {
        int n = this.size;
        long[] lArray = this.items;
        int n2 = longArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            long l = longArray.get(i);
            int n5 = 0;
            while (true) {
                n4 = n3;
                if (n5 >= n3) break;
                if (l == lArray[n5]) {
                    this.removeIndex(n5);
                    n4 = n3 - 1;
                    break;
                }
                ++n5;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public long removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            long[] lArray = this.items;
            long l = lArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(lArray, n + 1, lArray, n, this.size - n);
            } else {
                lArray[n] = lArray[this.size];
            }
            return l;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    long[] lArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(lArray, n2, lArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    long[] lArray = this.items;
                    System.arraycopy(lArray, n2, lArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean removeValue(long l) {
        long[] lArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] != l) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    protected long[] resize(int n) {
        long[] lArray = new long[n];
        System.arraycopy(this.items, 0, lArray, 0, Math.min(this.size, lArray.length));
        this.items = lArray;
        return lArray;
    }

    public void reverse() {
        long[] lArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            long l = lArray[i];
            lArray[i] = lArray[n3];
            lArray[n3] = l;
        }
    }

    public void set(int n, long l) {
        if (n < this.size) {
            this.items[n] = l;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public long[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public long[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        long[] lArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            long l = lArray[i];
            lArray[i] = lArray[n];
            lArray[n] = l;
        }
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                long[] lArray = this.items;
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public long[] toArray() {
        int n = this.size;
        long[] lArray = new long[n];
        System.arraycopy(this.items, 0, lArray, 0, n);
        return lArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        long[] lArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        long[] lArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(lArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

