/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class IntArray {
    public int[] items;
    public boolean ordered;
    public int size;

    public IntArray() {
        this(true, 16);
    }

    public IntArray(int n) {
        this(true, n);
    }

    public IntArray(IntArray intArray) {
        this.ordered = intArray.ordered;
        int n = this.size = intArray.size;
        this.items = new int[n];
        System.arraycopy(intArray.items, 0, this.items, 0, n);
    }

    public IntArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new int[n];
    }

    public IntArray(boolean bl, int[] nArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(nArray, n, this.items, 0, n2);
    }

    public IntArray(int[] nArray) {
        this(true, nArray, 0, nArray.length);
    }

    public static IntArray with(int ... nArray) {
        return new IntArray(nArray);
    }

    public void add(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        int[] nArray2 = nArray;
        if (n2 == nArray.length) {
            nArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
        }
        n2 = this.size;
        this.size = n2 + 1;
        nArray2[n2] = n;
    }

    public void add(int n, int n2) {
        int[] nArray = this.items;
        int n3 = this.size;
        int[] nArray2 = nArray;
        if (n3 + 1 >= nArray.length) {
            nArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        n3 = this.size;
        nArray2[n3] = n;
        nArray2[n3 + 1] = n2;
        this.size = n3 + 2;
    }

    public void add(int n, int n2, int n3) {
        int[] nArray = this.items;
        int n4 = this.size;
        int[] nArray2 = nArray;
        if (n4 + 2 >= nArray.length) {
            nArray2 = this.resize(Math.max(8, (int)((float)n4 * 1.75f)));
        }
        n4 = this.size;
        nArray2[n4] = n;
        nArray2[n4 + 1] = n2;
        nArray2[n4 + 2] = n3;
        this.size = n4 + 3;
    }

    public void add(int n, int n2, int n3, int n4) {
        int[] nArray = this.items;
        int n5 = this.size;
        int[] nArray2 = nArray;
        if (n5 + 3 >= nArray.length) {
            nArray2 = this.resize(Math.max(8, (int)((float)n5 * 1.8f)));
        }
        n5 = this.size;
        nArray2[n5] = n;
        nArray2[n5 + 1] = n2;
        nArray2[n5 + 2] = n3;
        nArray2[n5 + 3] = n4;
        this.size = n5 + 4;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray.items, 0, intArray.size);
    }

    public void addAll(IntArray intArray, int n, int n2) {
        if (n + n2 <= intArray.size) {
            this.addAll(intArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(intArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(int ... nArray) {
        this.addAll(nArray, 0, nArray.length);
    }

    public void addAll(int[] nArray, int n, int n2) {
        int[] nArray2 = this.items;
        int n3 = this.size + n2;
        int[] nArray3 = nArray2;
        if (n3 > nArray2.length) {
            nArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(nArray, n, nArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(int n) {
        int[] nArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public int[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof IntArray)) {
            return false;
        }
        Object object2 = (IntArray)object;
        if (!((IntArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((IntArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((IntArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public int first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public int get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        int[] nArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + nArray[i];
        }
        return n2;
    }

    public void incr(int n, int n2) {
        if (n < this.size) {
            int[] nArray = this.items;
            nArray[n] = nArray[n] + n2;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int indexOf(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, int n2) {
        int n3 = this.size;
        if (n <= n3) {
            int[] nArray;
            int[] nArray2 = nArray = this.items;
            if (n3 == nArray.length) {
                nArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(nArray2, n, nArray2, n + 1, this.size - n);
            } else {
                nArray2[this.size] = nArray2[n];
            }
            ++this.size;
            nArray2[n] = n2;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public int lastIndexOf(int n) {
        int[] nArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void mul(int n, int n2) {
        if (n < this.size) {
            int[] nArray = this.items;
            nArray[n] = nArray[n] * n2;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public int peek() {
        return this.items[this.size - 1];
    }

    public int pop() {
        int n;
        int[] nArray = this.items;
        this.size = n = this.size - 1;
        return nArray[n];
    }

    public int random() {
        int n = this.size;
        if (n == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(IntArray intArray) {
        int n = this.size;
        int[] nArray = this.items;
        int n2 = intArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = intArray.get(i);
            int n6 = 0;
            while (true) {
                n4 = n3;
                if (n6 >= n3) break;
                if (n5 == nArray[n6]) {
                    this.removeIndex(n6);
                    n4 = n3 - 1;
                    break;
                }
                ++n6;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public int removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            int[] nArray = this.items;
            int n3 = nArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(nArray, n + 1, nArray, n, this.size - n);
            } else {
                nArray[n] = nArray[this.size];
            }
            return n3;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    int[] nArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(nArray, n2, nArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    int[] nArray = this.items;
                    System.arraycopy(nArray, n2, nArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean removeValue(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    protected int[] resize(int n) {
        int[] nArray = new int[n];
        System.arraycopy(this.items, 0, nArray, 0, Math.min(this.size, nArray.length));
        this.items = nArray;
        return nArray;
    }

    public void reverse() {
        int[] nArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            int n4 = nArray[i];
            nArray[i] = nArray[n3];
            nArray[n3] = n4;
        }
    }

    public void set(int n, int n2) {
        if (n < this.size) {
            this.items[n] = n2;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public int[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        int[] nArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                int[] nArray = this.items;
                n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int[] toArray() {
        int n = this.size;
        int[] nArray = new int[n];
        System.arraycopy(this.items, 0, nArray, 0, n);
        return nArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

