/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class FloatArray {
    public float[] items;
    public boolean ordered;
    public int size;

    public FloatArray() {
        this(true, 16);
    }

    public FloatArray(int n) {
        this(true, n);
    }

    public FloatArray(FloatArray floatArray) {
        this.ordered = floatArray.ordered;
        int n = this.size = floatArray.size;
        this.items = new float[n];
        System.arraycopy(floatArray.items, 0, this.items, 0, n);
    }

    public FloatArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new float[n];
    }

    public FloatArray(boolean bl, float[] fArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(fArray, n, this.items, 0, n2);
    }

    public FloatArray(float[] fArray) {
        this(true, fArray, 0, fArray.length);
    }

    public static FloatArray with(float ... fArray) {
        return new FloatArray(fArray);
    }

    public void add(float f) {
        float[] fArray = this.items;
        int n = this.size;
        float[] fArray2 = fArray;
        if (n == fArray.length) {
            fArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        fArray2[n] = f;
    }

    public void add(float f, float f2) {
        float[] fArray = this.items;
        int n = this.size;
        float[] fArray2 = fArray;
        if (n + 1 >= fArray.length) {
            fArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        fArray2[n] = f;
        fArray2[n + 1] = f2;
        this.size = n + 2;
    }

    public void add(float f, float f2, float f3) {
        float[] fArray = this.items;
        int n = this.size;
        float[] fArray2 = fArray;
        if (n + 2 >= fArray.length) {
            fArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        fArray2[n] = f;
        fArray2[n + 1] = f2;
        fArray2[n + 2] = f3;
        this.size = n + 3;
    }

    public void add(float f, float f2, float f3, float f4) {
        float[] fArray = this.items;
        int n = this.size;
        float[] fArray2 = fArray;
        if (n + 3 >= fArray.length) {
            fArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        fArray2[n] = f;
        fArray2[n + 1] = f2;
        fArray2[n + 2] = f3;
        fArray2[n + 3] = f4;
        this.size = n + 4;
    }

    public void addAll(FloatArray floatArray) {
        this.addAll(floatArray.items, 0, floatArray.size);
    }

    public void addAll(FloatArray floatArray, int n, int n2) {
        if (n + n2 <= floatArray.size) {
            this.addAll(floatArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(floatArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(float ... fArray) {
        this.addAll(fArray, 0, fArray.length);
    }

    public void addAll(float[] fArray, int n, int n2) {
        float[] fArray2 = this.items;
        int n3 = this.size + n2;
        float[] fArray3 = fArray2;
        if (n3 > fArray2.length) {
            fArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(fArray, n, fArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(float f) {
        float[] fArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (fArray[i] != f) continue;
            return true;
        }
        return false;
    }

    public float[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof FloatArray)) {
            return false;
        }
        Object object2 = (FloatArray)object;
        if (!((FloatArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((FloatArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((FloatArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object, float f) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatArray)) {
            return false;
        }
        Object object2 = (FloatArray)object;
        int n = this.size;
        if (n != ((FloatArray)object2).size) {
            return false;
        }
        if (!this.ordered) {
            return false;
        }
        if (!((FloatArray)object2).ordered) {
            return false;
        }
        object = this.items;
        object2 = ((FloatArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs((float)(object[i] - object2[i])) > f)) continue;
            return false;
        }
        return true;
    }

    public float first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public float get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        float[] fArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + Float.floatToIntBits(fArray[i]);
        }
        return n2;
    }

    public void incr(int n, float f) {
        if (n < this.size) {
            float[] fArray = this.items;
            fArray[n] = fArray[n] + f;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int indexOf(float f) {
        float[] fArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, float f) {
        int n2 = this.size;
        if (n <= n2) {
            float[] fArray;
            float[] fArray2 = fArray = this.items;
            if (n2 == fArray.length) {
                fArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(fArray2, n, fArray2, n + 1, this.size - n);
            } else {
                fArray2[this.size] = fArray2[n];
            }
            ++this.size;
            fArray2[n] = f;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public int lastIndexOf(char c) {
        float[] fArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (fArray[i] != (float)c) continue;
            return i;
        }
        return -1;
    }

    public void mul(int n, float f) {
        if (n < this.size) {
            float[] fArray = this.items;
            fArray[n] = fArray[n] * f;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public float peek() {
        return this.items[this.size - 1];
    }

    public float pop() {
        int n;
        float[] fArray = this.items;
        this.size = n = this.size - 1;
        return fArray[n];
    }

    public float random() {
        int n = this.size;
        if (n == 0) {
            return 0.0f;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(FloatArray floatArray) {
        int n = this.size;
        float[] fArray = this.items;
        int n2 = floatArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            float f = floatArray.get(i);
            int n5 = 0;
            while (true) {
                n4 = n3;
                if (n5 >= n3) break;
                if (f == fArray[n5]) {
                    this.removeIndex(n5);
                    n4 = n3 - 1;
                    break;
                }
                ++n5;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public float removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            float[] fArray = this.items;
            float f = fArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(fArray, n + 1, fArray, n, this.size - n);
            } else {
                fArray[n] = fArray[this.size];
            }
            return f;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    float[] fArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(fArray, n2, fArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    float[] fArray = this.items;
                    System.arraycopy(fArray, n2, fArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean removeValue(float f) {
        float[] fArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    protected float[] resize(int n) {
        float[] fArray = new float[n];
        System.arraycopy(this.items, 0, fArray, 0, Math.min(this.size, fArray.length));
        this.items = fArray;
        return fArray;
    }

    public void reverse() {
        float[] fArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            float f = fArray[i];
            fArray[i] = fArray[n3];
            fArray[n3] = f;
        }
    }

    public void set(int n, float f) {
        if (n < this.size) {
            this.items[n] = f;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public float[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public float[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        float[] fArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            float f = fArray[i];
            fArray[i] = fArray[n];
            fArray[n] = f;
        }
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                float[] fArray = this.items;
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public float[] toArray() {
        int n = this.size;
        float[] fArray = new float[n];
        System.arraycopy(this.items, 0, fArray, 0, n);
        return fArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        float[] fArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(fArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(fArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        float[] fArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(fArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(fArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

