/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.utils.Timer;

public class DragScrollListener
extends DragListener {
    static final Vector2 tmpCoords = new Vector2();
    Interpolation interpolation = Interpolation.exp5In;
    float maxSpeed = 75.0f;
    float minSpeed = 15.0f;
    long rampTime = 1750L;
    private ScrollPane scroll;
    private Timer.Task scrollDown;
    private Timer.Task scrollUp;
    long startTime;
    float tickSecs = 0.05f;

    public DragScrollListener(final ScrollPane scrollPane) {
        this.scroll = scrollPane;
        this.scrollUp = new Timer.Task(){

            @Override
            public void run() {
                DragScrollListener.this.scroll(scrollPane.getScrollY() - DragScrollListener.this.getScrollPixels());
            }
        };
        this.scrollDown = new Timer.Task(){

            @Override
            public void run() {
                DragScrollListener.this.scroll(scrollPane.getScrollY() + DragScrollListener.this.getScrollPixels());
            }
        };
    }

    @Override
    public void drag(InputEvent object, float f, float f2, int n) {
        ((Event)object).getListenerActor().localToActorCoordinates(this.scroll, tmpCoords.set(f, f2));
        if (DragScrollListener.tmpCoords.y >= this.scroll.getHeight()) {
            this.scrollDown.cancel();
            if (!this.scrollUp.isScheduled()) {
                this.startTime = System.currentTimeMillis();
                object = this.scrollUp;
                f = this.tickSecs;
                Timer.schedule((Timer.Task)object, f, f);
            }
            return;
        }
        if (DragScrollListener.tmpCoords.y < 0.0f) {
            this.scrollUp.cancel();
            if (!this.scrollDown.isScheduled()) {
                this.startTime = System.currentTimeMillis();
                object = this.scrollDown;
                f = this.tickSecs;
                Timer.schedule((Timer.Task)object, f, f);
            }
            return;
        }
        this.scrollUp.cancel();
        this.scrollDown.cancel();
    }

    @Override
    public void dragStop(InputEvent inputEvent, float f, float f2, int n) {
        this.scrollUp.cancel();
        this.scrollDown.cancel();
    }

    float getScrollPixels() {
        return this.interpolation.apply(this.minSpeed, this.maxSpeed, Math.min(1.0f, (float)(System.currentTimeMillis() - this.startTime) / (float)this.rampTime));
    }

    protected void scroll(float f) {
        this.scroll.setScrollY(f);
    }

    public void setup(float f, float f2, float f3, float f4) {
        this.minSpeed = f;
        this.maxSpeed = f2;
        this.tickSecs = f3;
        this.rampTime = (long)(f4 * 1000.0f);
    }
}

