/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;

public class ImageTextButton
extends Button {
    private final Image image;
    private Label label;
    private ImageTextButtonStyle style;

    public ImageTextButton(String string2, ImageTextButtonStyle imageTextButtonStyle) {
        super(imageTextButtonStyle);
        this.style = imageTextButtonStyle;
        this.defaults().space(3.0f);
        this.image = new Image();
        this.image.setScaling(Scaling.fit);
        this.label = new Label((CharSequence)string2, new Label.LabelStyle(imageTextButtonStyle.font, imageTextButtonStyle.fontColor));
        this.label.setAlignment(1);
        this.add(this.image);
        this.add(this.label);
        this.setStyle(imageTextButtonStyle);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public ImageTextButton(String string2, Skin skin) {
        this(string2, skin.get(ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextButton(String string2, Skin skin, String string3) {
        this(string2, skin.get(string3, ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    @Override
    public void draw(Batch batch, float f) {
        this.updateImage();
        Color color2 = this.isDisabled() && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (color2 != null) {
            this.label.getStyle().fontColor = color2;
        }
        super.draw(batch, f);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell(this.image);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell getLabelCell() {
        return this.getCell(this.label);
    }

    @Override
    public ImageTextButtonStyle getStyle() {
        return this.style;
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public void setLabel(Label label) {
        this.getLabelCell().setActor(label);
        this.label = label;
    }

    @Override
    public void setStyle(Button.ButtonStyle buttonStyle) {
        if (buttonStyle instanceof ImageTextButtonStyle) {
            Object object;
            super.setStyle(buttonStyle);
            buttonStyle = (ImageTextButtonStyle)buttonStyle;
            this.style = buttonStyle;
            if (this.image != null) {
                this.updateImage();
            }
            if ((object = this.label) != null) {
                object = ((Label)object).getStyle();
                ((Label.LabelStyle)object).font = ((ImageTextButtonStyle)buttonStyle).font;
                ((Label.LabelStyle)object).fontColor = ((ImageTextButtonStyle)buttonStyle).fontColor;
                this.label.setStyle((Label.LabelStyle)object);
            }
            return;
        }
        throw new IllegalArgumentException("style must be a ImageTextButtonStyle.");
    }

    public void setText(CharSequence charSequence) {
        this.label.setText(charSequence);
    }

    @Override
    public String toString() {
        String string2 = this.getName();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getClass().getName();
        int n = string3.lastIndexOf(46);
        string2 = string3;
        if (n != -1) {
            string2 = string3.substring(n + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        string3 = string2.indexOf(36) != -1 ? "ImageTextButton " : "";
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(this.image.getDrawable());
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.label.getText());
        return stringBuilder.toString();
    }

    protected void updateImage() {
        Drawable drawable2 = this.isDisabled() && this.style.imageDisabled != null ? this.style.imageDisabled : (this.isPressed() && this.style.imageDown != null ? this.style.imageDown : (this.isChecked && this.style.imageChecked != null ? (this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked) : (this.isOver() && this.style.imageOver != null ? this.style.imageOver : (this.style.imageUp != null ? this.style.imageUp : null))));
        this.image.setDrawable(drawable2);
    }

    public static class ImageTextButtonStyle
    extends TextButton.TextButtonStyle {
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageUp;

        public ImageTextButtonStyle() {
        }

        public ImageTextButtonStyle(ImageTextButtonStyle object) {
            super((TextButton.TextButtonStyle)object);
            Drawable drawable2 = ((ImageTextButtonStyle)object).imageUp;
            if (drawable2 != null) {
                this.imageUp = drawable2;
            }
            if ((drawable2 = ((ImageTextButtonStyle)object).imageDown) != null) {
                this.imageDown = drawable2;
            }
            if ((drawable2 = ((ImageTextButtonStyle)object).imageOver) != null) {
                this.imageOver = drawable2;
            }
            if ((drawable2 = ((ImageTextButtonStyle)object).imageChecked) != null) {
                this.imageChecked = drawable2;
            }
            if ((drawable2 = ((ImageTextButtonStyle)object).imageCheckedOver) != null) {
                this.imageCheckedOver = drawable2;
            }
            if ((object = ((ImageTextButtonStyle)object).imageDisabled) != null) {
                this.imageDisabled = object;
            }
        }

        public ImageTextButtonStyle(TextButton.TextButtonStyle textButtonStyle) {
            super(textButtonStyle);
        }

        public ImageTextButtonStyle(Drawable drawable2, Drawable drawable3, Drawable drawable4, BitmapFont bitmapFont) {
            super(drawable2, drawable3, drawable4, bitmapFont);
        }
    }
}

