/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector2;

public final class GeometryUtils {
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();

    public static boolean barycoordInsideTriangle(Vector2 vector2) {
        boolean bl = vector2.x >= 0.0f && vector2.y >= 0.0f && vector2.x + vector2.y <= 1.0f;
        return bl;
    }

    public static boolean colinear(float f, float f2, float f3, float f4, float f5, float f6) {
        boolean bl = Math.abs((f5 - f3) * (f4 - f2) - (f3 - f) * (f6 - f4)) < 1.0E-6f;
        return bl;
    }

    public static void ensureCCW(float[] fArray) {
        GeometryUtils.ensureCCW(fArray, 0, fArray.length);
    }

    public static void ensureCCW(float[] fArray, int n, int n2) {
        if (!GeometryUtils.isClockwise(fArray, n, n2)) {
            return;
        }
        int n3 = n2 / 2;
        for (int i = n; i < n3 + n; i += 2) {
            int n4 = n + n2 - 2 - i;
            float f = fArray[i];
            int n5 = i + 1;
            float f2 = fArray[n5];
            fArray[i] = fArray[n4];
            int n6 = n4 + 1;
            fArray[n5] = fArray[n6];
            fArray[n4] = f;
            fArray[n6] = f2;
        }
    }

    public static float fromBarycoord(Vector2 vector2, float f, float f2, float f3) {
        return (1.0f - vector2.x - vector2.y) * f + vector2.x * f2 + vector2.y * f3;
    }

    public static Vector2 fromBarycoord(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        float f = 1.0f - vector2.x - vector2.y;
        vector25.x = vector22.x * f + vector2.x * vector23.x + vector2.y * vector24.x;
        vector25.y = f * vector22.y + vector2.x * vector23.y + vector2.y * vector24.y;
        return vector25;
    }

    public static boolean isClockwise(float[] fArray, int n, int n2) {
        boolean bl = false;
        if (n2 <= 2) {
            return false;
        }
        n2 = n2 + n - 2;
        float f = fArray[n2];
        float f2 = fArray[n2 + 1];
        float f3 = 0.0f;
        while (n <= n2) {
            float f4 = fArray[n];
            float f5 = fArray[n + 1];
            f3 += f * f5 - f2 * f4;
            n += 2;
            f = f4;
            f2 = f5;
        }
        if (f3 < 0.0f) {
            bl = true;
        }
        return bl;
    }

    public static float lowestPositiveRoot(float f, float f2, float f3) {
        if ((f3 = f2 * f2 - 4.0f * f * f3) < 0.0f) {
            return Float.NaN;
        }
        f3 = (float)Math.sqrt(f3);
        float f4 = 1.0f / (f * 2.0f);
        f2 = -f2;
        f = (f2 - f3) * f4;
        if (f > (f2 = (f2 + f3) * f4)) {
            f3 = f2;
            f2 = f;
        } else {
            f3 = f;
        }
        if (f3 > 0.0f) {
            return f3;
        }
        if (f2 > 0.0f) {
            return f2;
        }
        return Float.NaN;
    }

    public static float polygonArea(float[] fArray, int n, int n2) {
        n2 = n2 + n - 2;
        float f = fArray[n2];
        float f2 = fArray[n2 + 1];
        float f3 = 0.0f;
        while (n <= n2) {
            float f4 = fArray[n];
            float f5 = fArray[n + 1];
            f3 += f * f5 - f2 * f4;
            n += 2;
            f = f4;
            f2 = f5;
        }
        return f3 * 0.5f;
    }

    public static Vector2 polygonCentroid(float[] object, int n, int n2, Vector2 vector2) {
        if (n2 >= 6) {
            n2 = n2 + n - 2;
            float f = object[n2];
            float f2 = object[n2 + 1];
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            while (n <= n2) {
                float f6 = object[n];
                float f7 = object[n + 1];
                float f8 = f * f7 - f6 * f2;
                f5 += f8;
                f3 += (f + f6) * f8;
                f4 += (f2 + f7) * f8;
                n += 2;
                f = f6;
                f2 = f7;
            }
            if (f5 == 0.0f) {
                vector2.x = 0.0f;
                vector2.y = 0.0f;
            } else {
                f = f5 * 0.5f * 6.0f;
                vector2.x = f3 / f;
                vector2.y = f4 / f;
            }
            return vector2;
        }
        object = new IllegalArgumentException("A polygon must have 3 or more coordinate pairs.");
        throw object;
    }

    public static Vector2 quadrilateralCentroid(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Vector2 vector2) {
        f3 = (f3 + f + f5) / 3.0f;
        f4 = (f4 + f2 + f6) / 3.0f;
        f = (f + f7 + f5) / 3.0f;
        f2 = (f2 + f8 + f6) / 3.0f;
        vector2.x = f3 - (f3 - f) / 2.0f;
        vector2.y = f4 - (f4 - f2) / 2.0f;
        return vector2;
    }

    public static Vector2 toBarycoord(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24, Vector2 vector25) {
        vector23 = tmp1.set(vector23).sub(vector22);
        vector24 = tmp2.set(vector24).sub(vector22);
        vector2 = tmp3.set(vector2).sub(vector22);
        float f = vector23.dot(vector23);
        float f2 = vector23.dot(vector24);
        float f3 = vector24.dot(vector24);
        float f4 = vector2.dot(vector23);
        float f5 = vector2.dot(vector24);
        float f6 = f * f3 - f2 * f2;
        vector25.x = (f3 * f4 - f2 * f5) / f6;
        vector25.y = (f * f5 - f2 * f4) / f6;
        return vector25;
    }

    public static float triangleArea(float f, float f2, float f3, float f4, float f5, float f6) {
        return Math.abs((f - f5) * (f4 - f2) - (f - f3) * (f6 - f2)) * 0.5f;
    }

    public static Vector2 triangleCentroid(float f, float f2, float f3, float f4, float f5, float f6, Vector2 vector2) {
        vector2.x = (f + f3 + f5) / 3.0f;
        vector2.y = (f2 + f4 + f6) / 3.0f;
        return vector2;
    }

    public static Vector2 triangleCircumcenter(float f, float f2, float f3, float f4, float f5, float f6, Vector2 vector2) {
        float f7 = f5 - f3;
        float f8 = f4 - f2;
        float f9 = f3 - f;
        float f10 = f6 - f4;
        float f11 = f7 * f8 - f9 * f10;
        if (!(Math.abs(f11) < 1.0E-6f)) {
            float f12 = f * f + f2 * f2;
            f4 = f3 * f3 + f4 * f4;
            f3 = f5 * f5 + f6 * f6;
            vector2.set((f10 * f12 + (f2 - f6) * f4 + f8 * f3) / (f11 *= 2.0f), -(f12 * f7 + f4 * (f - f5) + f3 * f9) / f11);
            return vector2;
        }
        throw new IllegalArgumentException("Triangle points must not be colinear.");
    }

    public static float triangleCircumradius(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f4 - f2;
        if (Math.abs(f7) < 1.0E-6f) {
            f7 = -(f5 - f3) / (f6 - f4);
            f5 = (f5 + f3) / 2.0f;
            f6 = (f4 + f6) / 2.0f;
            f4 = (f3 + f) / 2.0f;
            f3 = f7 * (f4 - f5) + f6;
        } else {
            float f8 = f6 - f4;
            if (Math.abs(f8) < 1.0E-6f) {
                f6 = -(f3 - f) / f7;
                f7 = (f + f3) / 2.0f;
                f8 = (f4 + f2) / 2.0f;
                f4 = (f5 + f3) / 2.0f;
                f3 = f6 * (f4 - f7) + f8;
            } else {
                f7 = -(f3 - f) / f7;
                float f9 = -(f5 - f3) / f8;
                f8 = (f + f3) / 2.0f;
                f5 = (f3 + f5) / 2.0f;
                f3 = (f2 + f4) / 2.0f;
                f4 = (f7 * f8 - f5 * f9 + (f4 + f6) / 2.0f - f3) / (f7 - f9);
                f3 = f7 * (f4 - f8) + f3;
            }
        }
        return (float)Math.sqrt((f -= f4) * f + (f2 -= f3) * f2);
    }

    public static float triangleQuality(float f, float f2, float f3, float f4, float f5, float f6) {
        return Math.min((float)Math.sqrt(f * f + f2 * f2), Math.min((float)Math.sqrt(f3 * f3 + f4 * f4), (float)Math.sqrt(f5 * f5 + f6 * f6))) / GeometryUtils.triangleCircumradius(f, f2, f3, f4, f5, f6);
    }
}

