/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Bezier<T extends Vector<T>>
implements Path<T> {
    public Array<T> points = new Array();
    private T tmp;
    private T tmp2;
    private T tmp3;

    public Bezier() {
    }

    public Bezier(Array<T> array, int n, int n2) {
        this.set(array, n, n2);
    }

    public Bezier(T ... TArray) {
        this.set((Vector[])TArray);
    }

    public Bezier(T[] TArray, int n, int n2) {
        this.set((Vector[])TArray, n, n2);
    }

    public static <T extends Vector<T>> T cubic(T t, float f, T t2, T t3, T t4, T t5, T t6) {
        float f2 = 1.0f - f;
        float f3 = f2 * f2;
        float f4 = f * f;
        return t.set(t2).scl((float)(f3 * f2)).add(t6.set(t3).scl((float)(f3 * 3.0f * f))).add(t6.set(t4).scl((float)(f2 * 3.0f * f4))).add(t6.set(t5).scl((float)(f4 * f)));
    }

    public static <T extends Vector<T>> T cubic_derivative(T t, float f, T t2, T t3, T t4, T t5, T t6) {
        float f2 = 1.0f - f;
        return t.set(t3).sub(t2).scl((float)(f2 * f2 * 3.0f)).add(t6.set(t4).sub(t3).scl((float)(f2 * f * 6.0f))).add(t6.set(t5).sub(t4).scl((float)(f * f * 3.0f)));
    }

    public static <T extends Vector<T>> T linear(T t, float f, T t2, T t3, T t4) {
        return t.set(t2).scl((float)(1.0f - f)).add(t4.set(t3).scl((float)f));
    }

    public static <T extends Vector<T>> T linear_derivative(T t, float f, T t2, T t3, T t4) {
        return t.set(t3).sub(t2);
    }

    public static <T extends Vector<T>> T quadratic(T t, float f, T t2, T t3, T t4, T t5) {
        float f2 = 1.0f - f;
        return t.set(t2).scl((float)(f2 * f2)).add(t5.set(t3).scl((float)(f2 * 2.0f * f))).add(t5.set(t4).scl((float)(f * f)));
    }

    public static <T extends Vector<T>> T quadratic_derivative(T t, float f, T t2, T t3, T t4, T t5) {
        return t.set(t3).sub(t2).scl((float)2.0f).scl(1.0f - f).add(t5.set(t4).sub(t3).scl((float)f).scl(2.0f));
    }

    @Override
    public float approxLength(int n) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            this.tmp2.set(this.tmp3);
            this.valueAt(this.tmp3, (float)i / ((float)n - 1.0f));
            float f2 = f;
            if (i > 0) {
                f2 = f + this.tmp2.dst(this.tmp3);
            }
            f = f2;
        }
        return f;
    }

    @Override
    public float approximate(T object) {
        Vector vector = (Vector)this.points.get(0);
        Object object2 = this.points;
        object2 = (Vector)((Array)object2).get(((Array)object2).size - 1);
        float f = vector.dst2(object2);
        float f2 = object.dst2((Object)object2);
        float f3 = object.dst2((Vector)vector);
        float f4 = (float)Math.sqrt(f);
        return MathUtils.clamp((f4 - (f2 + f - f3) / (2.0f * f4)) / f4, 0.0f, 1.0f);
    }

    @Override
    public T derivativeAt(T t, float f) {
        int n = this.points.size;
        if (n == 2) {
            Bezier.linear_derivative(t, f, (Vector)this.points.get(0), (Vector)this.points.get(1), this.tmp);
        } else if (n == 3) {
            Bezier.quadratic_derivative(t, f, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), this.tmp);
        } else if (n == 4) {
            Bezier.cubic_derivative(t, f, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), (Vector)this.points.get(3), this.tmp);
        }
        return t;
    }

    @Override
    public float locate(T t) {
        return this.approximate(t);
    }

    public Bezier set(Array<T> array, int n, int n2) {
        if (n2 >= 2 && n2 <= 4) {
            if (this.tmp == null) {
                this.tmp = ((Vector)array.get(0)).cpy();
            }
            if (this.tmp2 == null) {
                this.tmp2 = ((Vector)array.get(0)).cpy();
            }
            if (this.tmp3 == null) {
                this.tmp3 = ((Vector)array.get(0)).cpy();
            }
            this.points.clear();
            this.points.addAll(array, n, n2);
            return this;
        }
        throw new GdxRuntimeException("Only first, second and third degree Bezier curves are supported.");
    }

    public Bezier set(T ... TArray) {
        return this.set((Vector[])TArray, 0, TArray.length);
    }

    public Bezier set(T[] TArray, int n, int n2) {
        if (n2 >= 2 && n2 <= 4) {
            if (this.tmp == null) {
                this.tmp = TArray[0].cpy();
            }
            if (this.tmp2 == null) {
                this.tmp2 = TArray[0].cpy();
            }
            if (this.tmp3 == null) {
                this.tmp3 = TArray[0].cpy();
            }
            this.points.clear();
            this.points.addAll(TArray, n, n2);
            return this;
        }
        throw new GdxRuntimeException("Only first, second and third degree Bezier curves are supported.");
    }

    @Override
    public T valueAt(T t, float f) {
        int n = this.points.size;
        if (n == 2) {
            Bezier.linear(t, f, (Vector)this.points.get(0), (Vector)this.points.get(1), this.tmp);
        } else if (n == 3) {
            Bezier.quadratic(t, f, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), this.tmp);
        } else if (n == 4) {
            Bezier.cubic(t, f, (Vector)this.points.get(0), (Vector)this.points.get(1), (Vector)this.points.get(2), (Vector)this.points.get(3), this.tmp);
        }
        return t;
    }
}

