/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;

public class ShapeCache
implements RenderableProvider,
Disposable {
    private final MeshBuilder builder;
    private boolean building;
    private final String id;
    private final Mesh mesh;
    private final Renderable renderable = new Renderable();

    public ShapeCache() {
        this(5000, 5000, new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(4, 4, "a_color")), 1);
    }

    public ShapeCache(int n, int n2, VertexAttributes vertexAttributes, int n3) {
        this.id = "id";
        this.mesh = new Mesh(false, n, n2, vertexAttributes);
        this.builder = new MeshBuilder();
        this.renderable.meshPart.mesh = this.mesh;
        this.renderable.meshPart.primitiveType = n3;
        this.renderable.material = new Material();
    }

    public MeshPartBuilder begin() {
        return this.begin(1);
    }

    public MeshPartBuilder begin(int n) {
        if (!this.building) {
            this.building = true;
            this.builder.begin(this.mesh.getVertexAttributes());
            this.builder.part("id", n, this.renderable.meshPart);
            return this.builder;
        }
        throw new GdxRuntimeException("Call end() after calling begin()");
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
    }

    public void end() {
        if (this.building) {
            this.building = false;
            this.builder.end(this.mesh);
            return;
        }
        throw new GdxRuntimeException("Call begin() prior to calling end()");
    }

    public Material getMaterial() {
        return this.renderable.material;
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        array.add(this.renderable);
    }

    public Matrix4 getWorldTransform() {
        return this.renderable.worldTransform;
    }
}

