/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.utils.BaseAnimationController;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;

public class AnimationController
extends BaseAnimationController {
    public boolean allowSameAnimation;
    protected final Pool<AnimationDesc> animationPool = new Pool<AnimationDesc>(){

        @Override
        protected AnimationDesc newObject() {
            return new AnimationDesc();
        }
    };
    public AnimationDesc current;
    public boolean inAction;
    private boolean justChangedAnimation = false;
    public boolean paused;
    public AnimationDesc previous;
    public AnimationDesc queued;
    public float queuedTransitionTime;
    public float transitionCurrentTime;
    public float transitionTargetTime;

    public AnimationController(ModelInstance modelInstance) {
        super(modelInstance);
    }

    private AnimationDesc obtain(Animation animation, float f, float f2, int n, float f3, AnimationListener animationListener) {
        if (animation == null) {
            return null;
        }
        AnimationDesc animationDesc = this.animationPool.obtain();
        animationDesc.animation = animation;
        animationDesc.listener = animationListener;
        animationDesc.loopCount = n;
        animationDesc.speed = f3;
        animationDesc.offset = f;
        float f4 = 0.0f;
        float f5 = f2;
        if (f2 < 0.0f) {
            f5 = animation.duration - f;
        }
        animationDesc.duration = f5;
        f = f4;
        if (f3 < 0.0f) {
            f = animationDesc.duration;
        }
        animationDesc.time = f;
        return animationDesc;
    }

    private AnimationDesc obtain(AnimationDesc animationDesc) {
        return this.obtain(animationDesc.animation, animationDesc.offset, animationDesc.duration, animationDesc.loopCount, animationDesc.speed, animationDesc.listener);
    }

    private AnimationDesc obtain(String string2, float f, float f2, int n, float f3, AnimationListener object) {
        if (string2 == null) {
            return null;
        }
        Animation animation = this.target.getAnimation(string2);
        if (animation != null) {
            return this.obtain(animation, f, f2, n, f3, (AnimationListener)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unknown animation: ");
        ((StringBuilder)object).append(string2);
        throw new GdxRuntimeException(((StringBuilder)object).toString());
    }

    protected AnimationDesc action(Animation animation, float f, float f2, int n, float f3, AnimationListener animationListener, float f4) {
        return this.action(this.obtain(animation, f, f2, n, f3, animationListener), f4);
    }

    protected AnimationDesc action(AnimationDesc animationDesc, float f) {
        if (animationDesc.loopCount >= 0) {
            AnimationDesc animationDesc2 = this.current;
            if (animationDesc2 != null && animationDesc2.loopCount != 0) {
                animationDesc2 = this.inAction ? null : this.obtain(this.current);
                this.inAction = false;
                this.animate(animationDesc, f);
                this.inAction = true;
                if (animationDesc2 != null) {
                    this.queue(animationDesc2, f);
                }
            } else {
                this.animate(animationDesc, f);
            }
            return animationDesc;
        }
        throw new GdxRuntimeException("An action cannot be continuous");
    }

    public AnimationDesc action(String string2, float f, float f2, int n, float f3, AnimationListener animationListener, float f4) {
        return this.action(this.obtain(string2, f, f2, n, f3, animationListener), f4);
    }

    public AnimationDesc action(String string2, int n, float f, AnimationListener animationListener, float f2) {
        return this.action(string2, 0.0f, -1.0f, n, f, animationListener, f2);
    }

    protected AnimationDesc animate(Animation animation, float f, float f2, int n, float f3, AnimationListener animationListener, float f4) {
        return this.animate(this.obtain(animation, f, f2, n, f3, animationListener), f4);
    }

    protected AnimationDesc animate(AnimationDesc animationDesc, float f) {
        AnimationDesc animationDesc2 = this.current;
        if (animationDesc2 == null) {
            this.current = animationDesc;
        } else if (this.inAction) {
            this.queue(animationDesc, f);
        } else if (!this.allowSameAnimation && animationDesc != null && animationDesc2.animation == animationDesc.animation) {
            animationDesc.time = this.current.time;
            this.animationPool.free(this.current);
            this.current = animationDesc;
        } else {
            animationDesc2 = this.previous;
            if (animationDesc2 != null) {
                this.removeAnimation(animationDesc2.animation);
                this.animationPool.free(this.previous);
            }
            this.previous = this.current;
            this.current = animationDesc;
            this.transitionCurrentTime = 0.0f;
            this.transitionTargetTime = f;
        }
        return animationDesc;
    }

    public AnimationDesc animate(String string2, float f) {
        return this.animate(string2, 1, 1.0f, null, f);
    }

    public AnimationDesc animate(String string2, float f, float f2, int n, float f3, AnimationListener animationListener, float f4) {
        return this.animate(this.obtain(string2, f, f2, n, f3, animationListener), f4);
    }

    public AnimationDesc animate(String string2, int n, float f, AnimationListener animationListener, float f2) {
        return this.animate(string2, 0.0f, -1.0f, n, f, animationListener, f2);
    }

    public AnimationDesc animate(String string2, int n, AnimationListener animationListener, float f) {
        return this.animate(string2, n, 1.0f, animationListener, f);
    }

    public AnimationDesc animate(String string2, AnimationListener animationListener, float f) {
        return this.animate(string2, 1, 1.0f, animationListener, f);
    }

    protected AnimationDesc queue(Animation animation, float f, float f2, int n, float f3, AnimationListener animationListener, float f4) {
        return this.queue(this.obtain(animation, f, f2, n, f3, animationListener), f4);
    }

    protected AnimationDesc queue(AnimationDesc animationDesc, float f) {
        AnimationDesc animationDesc2 = this.current;
        if (animationDesc2 != null && animationDesc2.loopCount != 0) {
            animationDesc2 = this.queued;
            if (animationDesc2 != null) {
                this.animationPool.free(animationDesc2);
            }
            this.queued = animationDesc;
            this.queuedTransitionTime = f;
            if (this.current.loopCount < 0) {
                this.current.loopCount = 1;
            }
        } else {
            this.animate(animationDesc, f);
        }
        return animationDesc;
    }

    public AnimationDesc queue(String string2, float f, float f2, int n, float f3, AnimationListener animationListener, float f4) {
        return this.queue(this.obtain(string2, f, f2, n, f3, animationListener), f4);
    }

    public AnimationDesc queue(String string2, int n, float f, AnimationListener animationListener, float f2) {
        return this.queue(string2, 0.0f, -1.0f, n, f, animationListener, f2);
    }

    protected AnimationDesc setAnimation(Animation animation, float f, float f2, int n, float f3, AnimationListener animationListener) {
        return this.setAnimation(this.obtain(animation, f, f2, n, f3, animationListener));
    }

    protected AnimationDesc setAnimation(AnimationDesc animationDesc) {
        AnimationDesc animationDesc2 = this.current;
        if (animationDesc2 == null) {
            this.current = animationDesc;
        } else {
            if (!this.allowSameAnimation && animationDesc != null && animationDesc2.animation == animationDesc.animation) {
                animationDesc.time = this.current.time;
            } else {
                this.removeAnimation(this.current.animation);
            }
            this.animationPool.free(this.current);
            this.current = animationDesc;
        }
        this.justChangedAnimation = true;
        return animationDesc;
    }

    public AnimationDesc setAnimation(String string2) {
        return this.setAnimation(string2, 1, 1.0f, null);
    }

    public AnimationDesc setAnimation(String string2, float f, float f2, int n, float f3, AnimationListener animationListener) {
        return this.setAnimation(this.obtain(string2, f, f2, n, f3, animationListener));
    }

    public AnimationDesc setAnimation(String string2, int n) {
        return this.setAnimation(string2, n, 1.0f, null);
    }

    public AnimationDesc setAnimation(String string2, int n, float f, AnimationListener animationListener) {
        return this.setAnimation(string2, 0.0f, -1.0f, n, f, animationListener);
    }

    public AnimationDesc setAnimation(String string2, int n, AnimationListener animationListener) {
        return this.setAnimation(string2, n, 1.0f, animationListener);
    }

    public AnimationDesc setAnimation(String string2, AnimationListener animationListener) {
        return this.setAnimation(string2, 1, 1.0f, animationListener);
    }

    public void update(float f) {
        if (this.paused) {
            return;
        }
        AnimationDesc animationDesc = this.previous;
        if (animationDesc != null) {
            float f2;
            this.transitionCurrentTime = f2 = this.transitionCurrentTime + f;
            if (f2 >= this.transitionTargetTime) {
                this.removeAnimation(animationDesc.animation);
                this.justChangedAnimation = true;
                this.animationPool.free(this.previous);
                this.previous = null;
            }
        }
        if (this.justChangedAnimation) {
            this.target.calculateTransforms();
            this.justChangedAnimation = false;
        }
        if ((animationDesc = this.current) != null && animationDesc.loopCount != 0 && this.current.animation != null) {
            if ((f = this.current.update(f)) != 0.0f && (animationDesc = this.queued) != null) {
                this.inAction = false;
                this.animate(animationDesc, this.queuedTransitionTime);
                this.queued = null;
                this.update(f);
                return;
            }
            animationDesc = this.previous;
            if (animationDesc != null) {
                this.applyAnimations(animationDesc.animation, this.previous.offset + this.previous.time, this.current.animation, this.current.offset + this.current.time, this.transitionCurrentTime / this.transitionTargetTime);
            } else {
                this.applyAnimation(this.current.animation, this.current.offset + this.current.time);
            }
        }
    }

    public static class AnimationDesc {
        public Animation animation;
        public float duration;
        public AnimationListener listener;
        public int loopCount;
        public float offset;
        public float speed;
        public float time;

        protected AnimationDesc() {
        }

        protected float update(float f) {
            if (this.loopCount != 0 && this.animation != null) {
                int n;
                int n2;
                float f2 = this.speed * f;
                boolean bl = MathUtils.isZero(this.duration);
                float f3 = 0.0f;
                if (!bl) {
                    this.time += f2;
                    n2 = (int)Math.abs(this.time / this.duration);
                    n = n2++;
                    if (this.time < 0.0f) {
                        while (true) {
                            f = this.time;
                            n = n2;
                            if (!(f < 0.0f)) break;
                            this.time = f + this.duration;
                        }
                    }
                    this.time = Math.abs(this.time % this.duration);
                } else {
                    n = 1;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    AnimationListener animationListener;
                    int n3 = this.loopCount;
                    if (n3 > 0) {
                        this.loopCount = n3 - 1;
                    }
                    if (this.loopCount != 0 && (animationListener = this.listener) != null) {
                        animationListener.onLoop(this);
                    }
                    if (this.loopCount != 0) continue;
                    float f4 = n - 1 - n2;
                    float f5 = this.duration;
                    f = f2 < 0.0f ? f5 - this.time : this.time;
                    if (!(f2 < 0.0f)) {
                        f3 = this.duration;
                    }
                    this.time = f3;
                    animationListener = this.listener;
                    if (animationListener != null) {
                        animationListener.onEnd(this);
                    }
                    return f4 * f5 + f;
                }
                return 0.0f;
            }
            return f;
        }
    }

    public static interface AnimationListener {
        public void onEnd(AnimationDesc var1);

        public void onLoop(AnimationDesc var1);
    }
}

