/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.graphics.g3d.particles.values.RangedNumericValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class ScaledNumericValue
extends RangedNumericValue {
    private float highMax;
    private float highMin;
    private boolean relative = false;
    private float[] scaling = new float[]{1.0f};
    public float[] timeline = new float[]{0.0f};

    public float getHighMax() {
        return this.highMax;
    }

    public float getHighMin() {
        return this.highMin;
    }

    public float getScale(float f) {
        int n;
        int n2;
        block3: {
            n2 = this.timeline.length;
            for (n = 1; n < n2; ++n) {
                if (!(this.timeline[n] > f)) {
                    continue;
                }
                break block3;
            }
            n = -1;
        }
        if (n == -1) {
            return this.scaling[n2 - 1];
        }
        n2 = n - 1;
        float[] fArray = this.scaling;
        float f2 = fArray[n2];
        float[] fArray2 = this.timeline;
        float f3 = fArray2[n2];
        return f2 + (fArray[n] - f2) * ((f - f3) / (fArray2[n] - f3));
    }

    public float[] getScaling() {
        return this.scaling;
    }

    public float[] getTimeline() {
        return this.timeline;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void load(ScaledNumericValue scaledNumericValue) {
        super.load(scaledNumericValue);
        this.highMax = scaledNumericValue.highMax;
        this.highMin = scaledNumericValue.highMin;
        this.scaling = new float[scaledNumericValue.scaling.length];
        float[] fArray = scaledNumericValue.scaling;
        float[] fArray2 = this.scaling;
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        this.timeline = new float[scaledNumericValue.timeline.length];
        fArray = scaledNumericValue.timeline;
        fArray2 = this.timeline;
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        this.relative = scaledNumericValue.relative;
    }

    public float newHighValue() {
        float f = this.highMin;
        return f + (this.highMax - f) * MathUtils.random();
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        super.read(json, jsonValue);
        this.highMin = json.readValue("highMin", Float.TYPE, jsonValue).floatValue();
        this.highMax = json.readValue("highMax", Float.TYPE, jsonValue).floatValue();
        this.relative = json.readValue("relative", Boolean.TYPE, jsonValue);
        this.scaling = json.readValue("scaling", float[].class, jsonValue);
        this.timeline = json.readValue("timeline", float[].class, jsonValue);
    }

    public void setHigh(float f) {
        this.highMin = f;
        this.highMax = f;
    }

    public void setHigh(float f, float f2) {
        this.highMin = f;
        this.highMax = f2;
    }

    public void setHighMax(float f) {
        this.highMax = f;
    }

    public void setHighMin(float f) {
        this.highMin = f;
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void setScaling(float[] fArray) {
        this.scaling = fArray;
    }

    public void setTimeline(float[] fArray) {
        this.timeline = fArray;
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("highMin", Float.valueOf(this.highMin));
        json.writeValue("highMax", Float.valueOf(this.highMax));
        json.writeValue("relative", this.relative);
        json.writeValue("scaling", this.scaling);
        json.writeValue("timeline", this.timeline);
    }
}

