/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ParticleControllerFinalizerInfluencer
extends Influencer {
    ParallelArray.ObjectChannel<ParticleController> controllerChannel;
    boolean hasRotation;
    boolean hasScale;
    ParallelArray.FloatChannel positionChannel;
    ParallelArray.FloatChannel rotationChannel;
    ParallelArray.FloatChannel scaleChannel;

    @Override
    public void allocateChannels() {
        this.positionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Position);
    }

    @Override
    public ParticleControllerFinalizerInfluencer copy() {
        return new ParticleControllerFinalizerInfluencer();
    }

    @Override
    public void init() {
        this.controllerChannel = (ParallelArray.ObjectChannel)this.controller.particles.getChannel(ParticleChannels.ParticleController);
        if (this.controllerChannel != null) {
            this.scaleChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Scale);
            this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Rotation3D);
            ParallelArray.FloatChannel floatChannel = this.scaleChannel;
            boolean bl = true;
            boolean bl2 = floatChannel != null;
            this.hasScale = bl2;
            bl2 = this.rotationChannel != null ? bl : false;
            this.hasRotation = bl2;
            return;
        }
        throw new GdxRuntimeException("ParticleController channel not found, specify an influencer which will allocate it please.");
    }

    @Override
    public void update() {
        int n = this.controller.particles.size;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            float f;
            float f2;
            float f3;
            float f4;
            ParticleController particleController = ((ParticleController[])this.controllerChannel.data)[n2];
            float f5 = this.hasScale ? this.scaleChannel.data[n2] : 1.0f;
            if (this.hasRotation) {
                int n4 = this.rotationChannel.strideSize * n2;
                f4 = this.rotationChannel.data[n4 + 0];
                f3 = this.rotationChannel.data[n4 + 1];
                f2 = this.rotationChannel.data[n4 + 2];
                f = this.rotationChannel.data[n4 + 3];
            } else {
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 1.0f;
            }
            particleController.setTransform(this.positionChannel.data[n3 + 0], this.positionChannel.data[n3 + 1], this.positionChannel.data[n3 + 2], f4, f3, f2, f, f5);
            particleController.update();
            ++n2;
            n3 += this.positionChannel.strideSize;
        }
    }
}

