/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.ArrayMap;

public class NodePart {
    public Matrix4[] bones;
    public boolean enabled = true;
    public ArrayMap<Node, Matrix4> invBoneBindTransforms;
    public Material material;
    public MeshPart meshPart;

    public NodePart() {
    }

    public NodePart(MeshPart meshPart, Material material) {
        this.meshPart = meshPart;
        this.material = material;
    }

    public NodePart copy() {
        return new NodePart().set(this);
    }

    protected NodePart set(NodePart matrix4Array) {
        this.meshPart = new MeshPart(matrix4Array.meshPart);
        this.material = matrix4Array.material;
        this.enabled = matrix4Array.enabled;
        ArrayMap<Node, Matrix4> arrayMap = matrix4Array.invBoneBindTransforms;
        if (arrayMap == null) {
            this.invBoneBindTransforms = null;
            this.bones = null;
        } else {
            ArrayMap<Node, Matrix4> arrayMap2 = this.invBoneBindTransforms;
            if (arrayMap2 == null) {
                this.invBoneBindTransforms = new ArrayMap(true, arrayMap.size, Node.class, Matrix4.class);
            } else {
                arrayMap2.clear();
            }
            this.invBoneBindTransforms.putAll(matrix4Array.invBoneBindTransforms);
            matrix4Array = this.bones;
            if (matrix4Array == null || matrix4Array.length != this.invBoneBindTransforms.size) {
                this.bones = new Matrix4[this.invBoneBindTransforms.size];
            }
            for (int i = 0; i < (matrix4Array = this.bones).length; ++i) {
                if (matrix4Array[i] != null) continue;
                matrix4Array[i] = new Matrix4();
            }
        }
        return this;
    }

    public Renderable setRenderable(Renderable renderable) {
        renderable.material = this.material;
        renderable.meshPart.set(this.meshPart);
        renderable.bones = this.bones;
        return renderable;
    }
}

