/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;

public class Node {
    private final Array<Node> children;
    public final Matrix4 globalTransform;
    public String id;
    public boolean inheritTransform = true;
    public boolean isAnimated;
    public final Matrix4 localTransform;
    protected Node parent;
    public Array<NodePart> parts;
    public final Quaternion rotation;
    public final Vector3 scale;
    public final Vector3 translation = new Vector3();

    public Node() {
        this.rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale = new Vector3(1.0f, 1.0f, 1.0f);
        this.localTransform = new Matrix4();
        this.globalTransform = new Matrix4();
        this.parts = new Array(2);
        this.children = new Array(2);
    }

    public static Node getNode(Array<Node> array, String string2, boolean bl, boolean bl2) {
        Node node;
        int n;
        int n2 = array.size;
        int n3 = 0;
        if (bl2) {
            for (n = 0; n < n2; ++n) {
                node = array.get(n);
                if (!node.id.equalsIgnoreCase(string2)) continue;
                return node;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                node = array.get(n);
                if (!node.id.equals(string2)) continue;
                return node;
            }
        }
        if (bl) {
            for (n = n3; n < n2; ++n) {
                node = Node.getNode(array.get((int)n).children, string2, true, bl2);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public <T extends Node> int addChild(T t) {
        return this.insertChild(-1, t);
    }

    public <T extends Node> int addChildren(Iterable<T> iterable) {
        return this.insertChildren(-1, iterable);
    }

    public <T extends Node> void attachTo(T node) {
        node.addChild((Node)this);
    }

    public void calculateBoneTransforms(boolean bl) {
        for (NodePart nodePart : this.parts) {
            if (nodePart.invBoneBindTransforms == null || nodePart.bones == null || nodePart.invBoneBindTransforms.size != nodePart.bones.length) continue;
            int n = nodePart.invBoneBindTransforms.size;
            for (int i = 0; i < n; ++i) {
                nodePart.bones[i].set(((Node[])nodePart.invBoneBindTransforms.keys)[i].globalTransform).mul(((Matrix4[])nodePart.invBoneBindTransforms.values)[i]);
            }
        }
        if (bl) {
            Iterator<Object> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).calculateBoneTransforms(true);
            }
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox);
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox, boolean bl) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox, bl);
    }

    public Matrix4 calculateLocalTransform() {
        if (!this.isAnimated) {
            this.localTransform.set(this.translation, this.rotation, this.scale);
        }
        return this.localTransform;
    }

    public void calculateTransforms(boolean bl) {
        this.calculateLocalTransform();
        this.calculateWorldTransform();
        if (bl) {
            Iterator<Node> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                iterator.next().calculateTransforms(true);
            }
        }
    }

    public Matrix4 calculateWorldTransform() {
        Node node;
        if (this.inheritTransform && (node = this.parent) != null) {
            this.globalTransform.set(node.globalTransform).mul(this.localTransform);
        } else {
            this.globalTransform.set(this.localTransform);
        }
        return this.globalTransform;
    }

    public Node copy() {
        return new Node().set(this);
    }

    public void detach() {
        Node node = this.parent;
        if (node != null) {
            node.removeChild(this);
            this.parent = null;
        }
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        return this.extendBoundingBox(boundingBox, true);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox, boolean bl) {
        int n;
        int n2 = this.parts.size;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Object object = this.parts.get(n);
            if (!((NodePart)object).enabled) continue;
            object = ((NodePart)object).meshPart;
            if (bl) {
                ((MeshPart)object).mesh.extendBoundingBox(boundingBox, ((MeshPart)object).offset, ((MeshPart)object).size, this.globalTransform);
                continue;
            }
            ((MeshPart)object).mesh.extendBoundingBox(boundingBox, ((MeshPart)object).offset, ((MeshPart)object).size);
        }
        n2 = this.children.size;
        for (n = n3; n < n2; ++n) {
            this.children.get(n).extendBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    public Node getChild(int n) {
        return this.children.get(n);
    }

    public Node getChild(String string2, boolean bl, boolean bl2) {
        return Node.getNode(this.children, string2, bl, bl2);
    }

    public int getChildCount() {
        return this.children.size;
    }

    public Iterable<Node> getChildren() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        Array<Node> array = this.children;
        boolean bl = array != null && array.size > 0;
        return bl;
    }

    public boolean hasParent() {
        boolean bl = this.parent != null;
        return bl;
    }

    public <T extends Node> int insertChild(int n, T t) {
        Node node;
        for (node = this; node != null; node = node.getParent()) {
            if (node != t) {
                continue;
            }
            throw new GdxRuntimeException("Cannot add a parent as a child");
        }
        node = t.getParent();
        if (node != null && !node.removeChild(t)) {
            throw new GdxRuntimeException("Could not remove child from its current parent");
        }
        if (n >= 0 && n < this.children.size) {
            this.children.insert(n, t);
        } else {
            n = this.children.size;
            this.children.add(t);
        }
        t.parent = this;
        return n;
    }

    public <T extends Node> int insertChildren(int n, Iterable<T> object) {
        int n2;
        block4: {
            block3: {
                if (n < 0) break block3;
                n2 = n;
                if (n <= this.children.size) break block4;
            }
            n2 = this.children.size;
        }
        object = object.iterator();
        n = n2;
        while (object.hasNext()) {
            this.insertChild(n, (Node)object.next());
            ++n;
        }
        return n2;
    }

    public <T extends Node> boolean removeChild(T t) {
        if (!this.children.removeValue(t, true)) {
            return false;
        }
        t.parent = null;
        return true;
    }

    protected Node set(Node object) {
        this.detach();
        this.id = ((Node)object).id;
        this.isAnimated = ((Node)object).isAnimated;
        this.inheritTransform = ((Node)object).inheritTransform;
        this.translation.set(((Node)object).translation);
        this.rotation.set(((Node)object).rotation);
        this.scale.set(((Node)object).scale);
        this.localTransform.set(((Node)object).localTransform);
        this.globalTransform.set(((Node)object).globalTransform);
        this.parts.clear();
        for (NodePart nodePart : ((Node)object).parts) {
            this.parts.add(nodePart.copy());
        }
        this.children.clear();
        object = ((Node)object).getChildren().iterator();
        while (object.hasNext()) {
            this.addChild(((Node)object.next()).copy());
        }
        return this;
    }
}

