/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.environment;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.ShadowMap;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;

public class DirectionalShadowLight
extends DirectionalLight
implements ShadowMap,
Disposable {
    protected Camera cam;
    protected FrameBuffer fbo;
    protected float halfDepth;
    protected float halfHeight;
    protected final TextureDescriptor textureDesc;
    protected final Vector3 tmpV = new Vector3();

    public DirectionalShadowLight(int n, int n2, float f, float f2, float f3, float f4) {
        Object object;
        this.fbo = new FrameBuffer(Pixmap.Format.RGBA8888, n, n2, true);
        this.cam = new OrthographicCamera(f, f2);
        Object object2 = this.cam;
        ((Camera)object2).near = f3;
        ((Camera)object2).far = f4;
        this.halfHeight = f2 * 0.5f;
        this.halfDepth = f3 + (f4 - f3) * 0.5f;
        this.textureDesc = new TextureDescriptor();
        object2 = this.textureDesc;
        ((TextureDescriptor)object2).magFilter = object = Texture.TextureFilter.Nearest;
        ((TextureDescriptor)object2).minFilter = object;
        object = this.textureDesc;
        object2 = Texture.TextureWrap.ClampToEdge;
        ((TextureDescriptor)object).vWrap = object2;
        ((TextureDescriptor)object).uWrap = object2;
    }

    public void begin() {
        int n = this.fbo.getWidth();
        int n2 = this.fbo.getHeight();
        this.fbo.begin();
        Gdx.gl.glViewport(0, 0, n, n2);
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(3089);
        Gdx.gl.glScissor(1, 1, n - 2, n2 - 2);
    }

    public void begin(Camera camera) {
        this.update(camera);
        this.begin();
    }

    public void begin(Vector3 vector3, Vector3 vector32) {
        this.update(vector3, vector32);
        this.begin();
    }

    @Override
    public void dispose() {
        FrameBuffer frameBuffer = this.fbo;
        if (frameBuffer != null) {
            frameBuffer.dispose();
        }
        this.fbo = null;
    }

    public void end() {
        Gdx.gl.glDisable(3089);
        this.fbo.end();
    }

    public Camera getCamera() {
        return this.cam;
    }

    @Override
    public TextureDescriptor getDepthMap() {
        this.textureDesc.texture = this.fbo.getColorBufferTexture();
        return this.textureDesc;
    }

    public FrameBuffer getFrameBuffer() {
        return this.fbo;
    }

    @Override
    public Matrix4 getProjViewTrans() {
        return this.cam.combined;
    }

    public void update(Camera camera) {
        this.update(this.tmpV.set(camera.direction).scl(this.halfHeight), camera.direction);
    }

    public void update(Vector3 vector3, Vector3 vector32) {
        this.cam.position.set(this.direction).scl(-this.halfDepth).add(vector3);
        this.cam.direction.set(this.direction).nor();
        this.cam.normalizeUp();
        this.cam.update();
    }
}

