/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.RenderableSorter;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FlushablePool;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import java.util.Comparator;
import java.util.Iterator;

public class ModelCache
implements RenderableProvider,
Disposable {
    private boolean building;
    private Camera camera;
    private Array<Renderable> items;
    private MeshBuilder meshBuilder;
    private FlushablePool<MeshPart> meshPartPool;
    private MeshPool meshPool;
    private Array<Renderable> renderables = new Array();
    private FlushablePool<Renderable> renderablesPool = new FlushablePool<Renderable>(){

        @Override
        protected Renderable newObject() {
            return new Renderable();
        }
    };
    private RenderableSorter sorter;
    private Array<Renderable> tmp;

    public ModelCache() {
        this(new Sorter(), new SimpleMeshPool());
    }

    public ModelCache(RenderableSorter renderableSorter, MeshPool meshPool) {
        this.meshPartPool = new FlushablePool<MeshPart>(){

            @Override
            protected MeshPart newObject() {
                return new MeshPart();
            }
        };
        this.items = new Array();
        this.tmp = new Array();
        this.sorter = renderableSorter;
        this.meshPool = meshPool;
        this.meshBuilder = new MeshBuilder();
    }

    private Renderable obtainRenderable(Material material, int n) {
        Renderable renderable = this.renderablesPool.obtain();
        renderable.bones = null;
        renderable.environment = null;
        renderable.material = material;
        renderable.meshPart.mesh = null;
        renderable.meshPart.offset = 0;
        renderable.meshPart.size = 0;
        renderable.meshPart.primitiveType = n;
        renderable.meshPart.center.set(0.0f, 0.0f, 0.0f);
        renderable.meshPart.halfExtents.set(0.0f, 0.0f, 0.0f);
        renderable.meshPart.radius = -1.0f;
        renderable.shader = null;
        renderable.userData = null;
        renderable.worldTransform.idt();
        return renderable;
    }

    public void add(Renderable renderable) {
        if (this.building) {
            if (renderable.bones == null) {
                this.items.add(renderable);
            } else {
                this.renderables.add(renderable);
            }
            return;
        }
        throw new GdxRuntimeException("Can only add items to the ModelCache in between .begin() and .end()");
    }

    public void add(RenderableProvider renderableProvider) {
        renderableProvider.getRenderables(this.tmp, this.renderablesPool);
        int n = this.tmp.size;
        for (int i = 0; i < n; ++i) {
            this.add(this.tmp.get(i));
        }
        this.tmp.clear();
    }

    public <T extends RenderableProvider> void add(Iterable<T> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.add((RenderableProvider)object.next());
        }
    }

    public void begin() {
        this.begin(null);
    }

    public void begin(Camera camera) {
        if (!this.building) {
            this.building = true;
            this.camera = camera;
            this.renderablesPool.flush();
            this.renderables.clear();
            this.items.clear();
            this.meshPartPool.flush();
            this.meshPool.flush();
            return;
        }
        throw new GdxRuntimeException("Call end() after calling begin()");
    }

    @Override
    public void dispose() {
        if (!this.building) {
            this.meshPool.dispose();
            return;
        }
        throw new GdxRuntimeException("Cannot dispose a ModelCache in between .begin() and .end()");
    }

    public void end() {
        if (this.building) {
            this.building = false;
            if (this.items.size == 0) {
                return;
            }
            this.sorter.sort(this.camera, this.items);
            int n = this.items.size;
            n = this.renderables.size;
            Object object = this.items.get(0);
            Object object2 = ((Renderable)object).meshPart.mesh.getVertexAttributes();
            Material material = ((Renderable)object).material;
            int n2 = ((Renderable)object).meshPart.primitiveType;
            n = this.renderables.size;
            this.meshBuilder.begin((VertexAttributes)object2);
            MeshPart meshPart = this.meshBuilder.part("", n2, this.meshPartPool.obtain());
            this.renderables.add(this.obtainRenderable(material, n2));
            int n3 = this.items.size;
            for (int i = 0; i < n3; ++i) {
                Renderable renderable = this.items.get(i);
                VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
                Material material2 = renderable.material;
                int n4 = renderable.meshPart.primitiveType;
                boolean bl = vertexAttributes.equals(object2) && renderable.meshPart.size + this.meshBuilder.getNumVertices() < Short.MAX_VALUE;
                boolean bl2 = bl && n4 == n2 && material2.same(material, true);
                object = object2;
                int n5 = n;
                MeshPart meshPart2 = meshPart;
                if (!bl2) {
                    object = object2;
                    n2 = n;
                    if (!bl) {
                        object = this.meshBuilder;
                        object = ((MeshBuilder)object).end(this.meshPool.obtain((VertexAttributes)object2, ((MeshBuilder)object).getNumVertices(), this.meshBuilder.getNumIndices()));
                        while (n < this.renderables.size) {
                            this.renderables.get((int)n).meshPart.mesh = object;
                            ++n;
                        }
                        this.meshBuilder.begin(vertexAttributes);
                        object = vertexAttributes;
                        n2 = n;
                    }
                    meshPart2 = this.meshBuilder.part("", n4, this.meshPartPool.obtain());
                    object2 = this.renderables;
                    object2 = (Renderable)((Array)object2).get(((Array)object2).size - 1);
                    ((Renderable)object2).meshPart.offset = meshPart.offset;
                    ((Renderable)object2).meshPart.size = meshPart.size;
                    this.renderables.add(this.obtainRenderable(material2, n4));
                    material = material2;
                    n = n4;
                    n5 = n2;
                    n2 = n;
                }
                this.meshBuilder.setVertexTransform(renderable.worldTransform);
                this.meshBuilder.addMesh(renderable.meshPart.mesh, renderable.meshPart.offset, renderable.meshPart.size);
                object2 = object;
                n = n5;
                meshPart = meshPart2;
            }
            object = this.meshBuilder;
            object = ((MeshBuilder)object).end(this.meshPool.obtain((VertexAttributes)object2, ((MeshBuilder)object).getNumVertices(), this.meshBuilder.getNumIndices()));
            while (n < this.renderables.size) {
                this.renderables.get((int)n).meshPart.mesh = object;
                ++n;
            }
            object = this.renderables;
            object = ((Array)object).get(((Array)object).size - 1);
            ((Renderable)object).meshPart.offset = meshPart.offset;
            ((Renderable)object).meshPart.size = meshPart.size;
            return;
        }
        GdxRuntimeException gdxRuntimeException = new GdxRuntimeException("Call begin() prior to calling end()");
        throw gdxRuntimeException;
    }

    @Override
    public void getRenderables(Array<Renderable> object, Pool<Renderable> object22) {
        if (!this.building) {
            for (Renderable renderable : this.renderables) {
                renderable.shader = null;
                renderable.environment = null;
            }
            ((Array)object).addAll(this.renderables);
            return;
        }
        object = new GdxRuntimeException("Cannot render a ModelCache in between .begin() and .end()");
        throw object;
    }

    public static interface MeshPool
    extends Disposable {
        public void flush();

        public Mesh obtain(VertexAttributes var1, int var2, int var3);
    }

    public static class SimpleMeshPool
    implements MeshPool {
        private Array<Mesh> freeMeshes = new Array();
        private Array<Mesh> usedMeshes = new Array();

        @Override
        public void dispose() {
            Iterator<Mesh> iterator = this.usedMeshes.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
            this.usedMeshes.clear();
            iterator = this.freeMeshes.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
            this.freeMeshes.clear();
        }

        @Override
        public void flush() {
            this.freeMeshes.addAll(this.usedMeshes);
            this.usedMeshes.clear();
        }

        @Override
        public Mesh obtain(VertexAttributes object, int n, int n2) {
            int n3 = this.freeMeshes.size;
            for (int i = 0; i < n3; ++i) {
                Mesh mesh = this.freeMeshes.get(i);
                if (!mesh.getVertexAttributes().equals(object) || mesh.getMaxVertices() < n || mesh.getMaxIndices() < n2) continue;
                this.freeMeshes.removeIndex(i);
                this.usedMeshes.add(mesh);
                return mesh;
            }
            object = new Mesh(false, 32768, Math.max(32768, 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1)), (VertexAttributes)object);
            this.usedMeshes.add((Mesh)object);
            return object;
        }
    }

    public static class Sorter
    implements RenderableSorter,
    Comparator<Renderable> {
        @Override
        public int compare(Renderable renderable, Renderable renderable2) {
            int n;
            int n2 = n = renderable.meshPart.mesh.getVertexAttributes().compareTo(renderable2.meshPart.mesh.getVertexAttributes());
            if (n == 0) {
                n2 = n = renderable.material.compareTo(renderable2.material);
                if (n == 0) {
                    return renderable.meshPart.primitiveType - renderable2.meshPart.primitiveType;
                }
            }
            return n2;
        }

        @Override
        public void sort(Camera camera, Array<Renderable> array) {
            array.sort(this);
        }
    }

    public static class TightMeshPool
    implements MeshPool {
        private Array<Mesh> freeMeshes = new Array();
        private Array<Mesh> usedMeshes = new Array();

        @Override
        public void dispose() {
            Iterator<Mesh> iterator = this.usedMeshes.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
            this.usedMeshes.clear();
            iterator = this.freeMeshes.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
            this.freeMeshes.clear();
        }

        @Override
        public void flush() {
            this.freeMeshes.addAll(this.usedMeshes);
            this.usedMeshes.clear();
        }

        @Override
        public Mesh obtain(VertexAttributes object, int n, int n2) {
            int n3 = this.freeMeshes.size;
            for (int i = 0; i < n3; ++i) {
                Mesh mesh = this.freeMeshes.get(i);
                if (!mesh.getVertexAttributes().equals(object) || mesh.getMaxVertices() != n || mesh.getMaxIndices() != n2) continue;
                this.freeMeshes.removeIndex(i);
                this.usedMeshes.add(mesh);
                return mesh;
            }
            object = new Mesh(true, n, n2, (VertexAttributes)object);
            this.usedMeshes.add((Mesh)object);
            return object;
        }
    }
}

