/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class ParticleEffectPool
extends Pool<PooledEffect> {
    private final ParticleEffect effect;

    public ParticleEffectPool(ParticleEffect particleEffect, int n, int n2) {
        super(n, n2);
        this.effect = particleEffect;
    }

    @Override
    public void free(PooledEffect pooledEffect) {
        super.free(pooledEffect);
        pooledEffect.reset(false);
        if (pooledEffect.xSizeScale != this.effect.xSizeScale || pooledEffect.ySizeScale != this.effect.ySizeScale || pooledEffect.motionScale != this.effect.motionScale) {
            Array<ParticleEmitter> array = pooledEffect.getEmitters();
            Array<ParticleEmitter> array2 = this.effect.getEmitters();
            for (int i = 0; i < array.size; ++i) {
                ParticleEmitter particleEmitter = array.get(i);
                ParticleEmitter particleEmitter2 = array2.get(i);
                particleEmitter.matchSize(particleEmitter2);
                particleEmitter.matchMotion(particleEmitter2);
            }
            pooledEffect.xSizeScale = this.effect.xSizeScale;
            pooledEffect.ySizeScale = this.effect.ySizeScale;
            pooledEffect.motionScale = this.effect.motionScale;
        }
    }

    @Override
    protected PooledEffect newObject() {
        PooledEffect pooledEffect = new PooledEffect(this.effect);
        pooledEffect.start();
        return pooledEffect;
    }

    public class PooledEffect
    extends ParticleEffect {
        PooledEffect(ParticleEffect particleEffect) {
            super(particleEffect);
        }

        public void free() {
            ParticleEffectPool.this.free(this);
        }
    }
}

