/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lzma;

import com.badlogic.gdx.utils.compression.ICodeProgress;
import com.badlogic.gdx.utils.compression.lz.BinTree;
import com.badlogic.gdx.utils.compression.lzma.Base;
import com.badlogic.gdx.utils.compression.rangecoder.BitTreeEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Encoder {
    public static final int EMatchFinderTypeBT2 = 0;
    public static final int EMatchFinderTypeBT4 = 1;
    static byte[] g_FastPos;
    static final int kDefaultDictionaryLogSize = 22;
    static final int kIfinityPrice = 0xFFFFFFF;
    static final int kNumFastBytesDefault = 32;
    public static final int kNumLenSpecSymbols = 16;
    static final int kNumOpts = 4096;
    public static final int kPropSize = 5;
    int _additionalOffset;
    int _alignPriceCount;
    int[] _alignPrices;
    int _dictionarySize;
    int _dictionarySizePrev;
    int _distTableSize = 44;
    int[] _distancesPrices;
    boolean _finished;
    InputStream _inStream;
    short[] _isMatch;
    short[] _isRep;
    short[] _isRep0Long;
    short[] _isRepG0;
    short[] _isRepG1;
    short[] _isRepG2;
    LenPriceTableEncoder _lenEncoder;
    LiteralEncoder _literalEncoder;
    int _longestMatchLength;
    boolean _longestMatchWasFound;
    int[] _matchDistances;
    BinTree _matchFinder = null;
    int _matchFinderType;
    int _matchPriceCount;
    boolean _needReleaseMFStream;
    int _numDistancePairs;
    int _numFastBytes = 32;
    int _numFastBytesPrev;
    int _numLiteralContextBits;
    int _numLiteralPosStateBits;
    Optimal[] _optimum;
    int _optimumCurrentIndex;
    int _optimumEndIndex;
    BitTreeEncoder _posAlignEncoder;
    short[] _posEncoders;
    BitTreeEncoder[] _posSlotEncoder;
    int[] _posSlotPrices;
    int _posStateBits = 2;
    int _posStateMask = 3;
    byte _previousByte;
    com.badlogic.gdx.utils.compression.rangecoder.Encoder _rangeEncoder;
    int[] _repDistances;
    LenPriceTableEncoder _repMatchLenEncoder;
    int _state = Base.StateInit();
    boolean _writeEndMark;
    int backRes;
    boolean[] finished;
    long nowPos64;
    long[] processedInSize;
    long[] processedOutSize;
    byte[] properties;
    int[] repLens;
    int[] reps;
    int[] tempPrices;

    static {
        byte[] byArray = g_FastPos = new byte[2048];
        byArray[0] = (byte)0;
        byArray[1] = (byte)1;
        int n = 2;
        for (int i = 2; i < 22; ++i) {
            int n2 = 0;
            while (n2 < 1 << (i >> 1) - 1) {
                Encoder.g_FastPos[n] = (byte)i;
                ++n2;
                ++n;
            }
        }
    }

    public Encoder() {
        this._repDistances = new int[4];
        this._optimum = new Optimal[4096];
        this._rangeEncoder = new com.badlogic.gdx.utils.compression.rangecoder.Encoder();
        this._isMatch = new short[192];
        this._isRep = new short[12];
        this._isRepG0 = new short[12];
        this._isRepG1 = new short[12];
        this._isRepG2 = new short[12];
        this._isRep0Long = new short[192];
        this._posSlotEncoder = new BitTreeEncoder[4];
        this._posEncoders = new short[114];
        this._posAlignEncoder = new BitTreeEncoder(4);
        this._lenEncoder = new LenPriceTableEncoder();
        this._repMatchLenEncoder = new LenPriceTableEncoder();
        this._literalEncoder = new LiteralEncoder();
        this._matchDistances = new int[548];
        this._posSlotPrices = new int[256];
        this._distancesPrices = new int[512];
        this._alignPrices = new int[16];
        int n = 0;
        this._numLiteralPosStateBits = 0;
        this._numLiteralContextBits = 3;
        this._dictionarySize = 0x400000;
        this._dictionarySizePrev = -1;
        this._numFastBytesPrev = -1;
        this._matchFinderType = 1;
        this._writeEndMark = false;
        this._needReleaseMFStream = false;
        this.reps = new int[4];
        this.repLens = new int[4];
        this.processedInSize = new long[1];
        this.processedOutSize = new long[1];
        this.finished = new boolean[1];
        this.properties = new byte[5];
        this.tempPrices = new int[128];
        int n2 = 0;
        while (true) {
            if (n2 >= 4096) break;
            this._optimum[n2] = new Optimal();
            ++n2;
        }
        for (int i = n; i < 4; ++i) {
            this._posSlotEncoder[i] = new BitTreeEncoder(6);
        }
    }

    static int GetPosSlot(int n) {
        if (n < 2048) {
            return g_FastPos[n];
        }
        if (n < 0x200000) {
            return g_FastPos[n >> 10] + 20;
        }
        return g_FastPos[n >> 20] + 40;
    }

    static int GetPosSlot2(int n) {
        if (n < 131072) {
            return g_FastPos[n >> 6] + 12;
        }
        if (n < 0x8000000) {
            return g_FastPos[n >> 16] + 32;
        }
        return g_FastPos[n >> 26] + 52;
    }

    int Backward(int n) {
        this._optimumEndIndex = n;
        int n2 = this._optimum[n].PosPrev;
        int n3 = this._optimum[n].BackPrev;
        int n4 = n;
        n = n2;
        while (true) {
            Optimal[] optimalArray;
            if (this._optimum[n4].Prev1IsChar) {
                this._optimum[n].MakeAsChar();
                optimalArray = this._optimum;
                Optimal optimal = optimalArray[n];
                optimal.PosPrev = n2 = n - 1;
                if (optimalArray[n4].Prev2) {
                    optimalArray = this._optimum;
                    optimalArray[n2].Prev1IsChar = false;
                    optimalArray[n2].PosPrev = optimalArray[n4].PosPrev2;
                    optimalArray = this._optimum;
                    optimalArray[n2].BackPrev = optimalArray[n4].BackPrev2;
                }
            }
            int n5 = this._optimum[n].BackPrev;
            n2 = this._optimum[n].PosPrev;
            optimalArray = this._optimum;
            optimalArray[n].BackPrev = n3;
            optimalArray[n].PosPrev = n4;
            if (n <= 0) {
                this.backRes = optimalArray[0].BackPrev;
                this._optimumCurrentIndex = this._optimum[0].PosPrev;
                return this._optimumCurrentIndex;
            }
            n4 = n;
            n3 = n5;
            n = n2;
        }
    }

    void BaseInit() {
        this._state = Base.StateInit();
        this._previousByte = (byte)0;
        for (int i = 0; i < 4; ++i) {
            this._repDistances[i] = 0;
        }
    }

    boolean ChangePair(int n, int n2) {
        boolean bl = n < 0x2000000 && n2 >= n << 7;
        return bl;
    }

    public void Code(InputStream inputStream, OutputStream outputStream, long l, long l2, ICodeProgress iCodeProgress) throws IOException {
        this._needReleaseMFStream = false;
        try {
            this.SetStreams(inputStream, outputStream, l, l2);
            while (true) {
                this.CodeOneBlock(this.processedInSize, this.processedOutSize, this.finished);
                boolean bl = this.finished[0];
                if (bl) {
                    this.ReleaseStreams();
                    return;
                }
                if (iCodeProgress == null) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            this.ReleaseStreams();
            throw throwable;
        }
        {
            iCodeProgress.SetProgress(this.processedInSize[0], this.processedOutSize[0]);
            continue;
        }
    }

    public void CodeOneBlock(long[] lArray, long[] lArray2, boolean[] blArray) throws IOException {
        byte by;
        int n;
        int n2;
        lArray[0] = 0L;
        lArray2[0] = 0L;
        blArray[0] = true;
        Object object = this._inStream;
        if (object != null) {
            this._matchFinder.SetStream((InputStream)object);
            this._matchFinder.Init();
            this._needReleaseMFStream = true;
            this._inStream = null;
        }
        if (this._finished) {
            return;
        }
        this._finished = true;
        long l = this.nowPos64;
        if (l == 0L) {
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                this.Flush((int)this.nowPos64);
                return;
            }
            this.ReadMatchDistances();
            n2 = (int)this.nowPos64;
            n = this._posStateMask;
            this._rangeEncoder.Encode(this._isMatch, (this._state << 4) + (n & n2), 0);
            this._state = Base.StateUpdateChar(this._state);
            by = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
            this._literalEncoder.GetSubCoder((int)this.nowPos64, this._previousByte).Encode(this._rangeEncoder, by);
            this._previousByte = by;
            --this._additionalOffset;
            ++this.nowPos64;
        }
        if (this._matchFinder.GetNumAvailableBytes() == 0) {
            this.Flush((int)this.nowPos64);
            return;
        }
        while (true) {
            n = this.GetOptimum((int)this.nowPos64);
            n2 = this.backRes;
            int n3 = (int)this.nowPos64;
            int n4 = this._posStateMask & n3;
            n3 = (this._state << 4) + n4;
            if (n == 1 && n2 == -1) {
                this._rangeEncoder.Encode(this._isMatch, n3, 0);
                byte by2 = this._matchFinder.GetIndexByte(0 - this._additionalOffset);
                object = this._literalEncoder.GetSubCoder((int)this.nowPos64, this._previousByte);
                if (!Base.StateIsCharState(this._state)) {
                    by = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                    ((LiteralEncoder.Encoder2)object).EncodeMatched(this._rangeEncoder, by, by2);
                } else {
                    ((LiteralEncoder.Encoder2)object).Encode(this._rangeEncoder, by2);
                }
                this._previousByte = by2;
                this._state = Base.StateUpdateChar(this._state);
            } else {
                this._rangeEncoder.Encode(this._isMatch, n3, 1);
                if (n2 < 4) {
                    this._rangeEncoder.Encode(this._isRep, this._state, 1);
                    if (n2 == 0) {
                        this._rangeEncoder.Encode(this._isRepG0, this._state, 0);
                        if (n == 1) {
                            this._rangeEncoder.Encode(this._isRep0Long, n3, 0);
                        } else {
                            this._rangeEncoder.Encode(this._isRep0Long, n3, 1);
                        }
                    } else {
                        this._rangeEncoder.Encode(this._isRepG0, this._state, 1);
                        if (n2 == 1) {
                            this._rangeEncoder.Encode(this._isRepG1, this._state, 0);
                        } else {
                            this._rangeEncoder.Encode(this._isRepG1, this._state, 1);
                            this._rangeEncoder.Encode(this._isRepG2, this._state, n2 - 2);
                        }
                    }
                    if (n == 1) {
                        this._state = Base.StateUpdateShortRep(this._state);
                    } else {
                        this._repMatchLenEncoder.Encode(this._rangeEncoder, n - 2, n4);
                        this._state = Base.StateUpdateRep(this._state);
                    }
                    n3 = this._repDistances[n2];
                    if (n2 != 0) {
                        while (n2 >= 1) {
                            object = this._repDistances;
                            object[n2] = object[n2 - 1];
                            --n2;
                        }
                        this._repDistances[0] = n3;
                    }
                } else {
                    this._rangeEncoder.Encode(this._isRep, this._state, 0);
                    this._state = Base.StateUpdateMatch(this._state);
                    this._lenEncoder.Encode(this._rangeEncoder, n - 2, n4);
                    n3 = n2 - 4;
                    n2 = Encoder.GetPosSlot(n3);
                    n4 = Base.GetLenToPosState(n);
                    this._posSlotEncoder[n4].Encode(this._rangeEncoder, n2);
                    if (n2 >= 4) {
                        int n5 = (n2 >> 1) - 1;
                        n4 = (n2 & 1 | 2) << n5;
                        int n6 = n3 - n4;
                        if (n2 < 14) {
                            BitTreeEncoder.ReverseEncode(this._posEncoders, n4 - n2 - 1, this._rangeEncoder, n5, n6);
                        } else {
                            this._rangeEncoder.EncodeDirectBits(n6 >> 4, n5 - 4);
                            this._posAlignEncoder.ReverseEncode(this._rangeEncoder, n6 & 0xF);
                            ++this._alignPriceCount;
                        }
                    }
                    for (n2 = 3; n2 >= 1; --n2) {
                        object = this._repDistances;
                        object[n2] = object[n2 - 1];
                    }
                    this._repDistances[0] = n3;
                    ++this._matchPriceCount;
                }
                this._previousByte = this._matchFinder.GetIndexByte(n - 1 - this._additionalOffset);
            }
            this._additionalOffset -= n;
            this.nowPos64 += (long)n;
            if (this._additionalOffset != 0) continue;
            if (this._matchPriceCount >= 128) {
                this.FillDistancesPrices();
            }
            if (this._alignPriceCount >= 16) {
                this.FillAlignPrices();
            }
            lArray[0] = this.nowPos64;
            lArray2[0] = this._rangeEncoder.GetProcessedSizeAdd();
            if (this._matchFinder.GetNumAvailableBytes() == 0) {
                this.Flush((int)this.nowPos64);
                return;
            }
            if (this.nowPos64 - l >= 4096L) break;
        }
        this._finished = false;
        blArray[0] = false;
    }

    void Create() {
        if (this._matchFinder == null) {
            BinTree binTree = new BinTree();
            int n = 4;
            if (this._matchFinderType == 0) {
                n = 2;
            }
            binTree.SetType(n);
            this._matchFinder = binTree;
        }
        this._literalEncoder.Create(this._numLiteralPosStateBits, this._numLiteralContextBits);
        if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
            return;
        }
        this._matchFinder.Create(this._dictionarySize, 4096, this._numFastBytes, 274);
        this._dictionarySizePrev = this._dictionarySize;
        this._numFastBytesPrev = this._numFastBytes;
    }

    void FillAlignPrices() {
        for (int i = 0; i < 16; ++i) {
            this._alignPrices[i] = this._posAlignEncoder.ReverseGetPrice(i);
        }
        this._alignPriceCount = 0;
    }

    void FillDistancesPrices() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 4; n4 < 128; ++n4) {
            n3 = Encoder.GetPosSlot(n4);
            n2 = (n3 >> 1) - 1;
            n = (n3 & 1 | 2) << n2;
            this.tempPrices[n4] = BitTreeEncoder.ReverseGetPrice(this._posEncoders, n - n3 - 1, n2, n4 - n);
        }
        for (n = 0; n < 4; ++n) {
            Object object = this._posSlotEncoder[n];
            n3 = n << 6;
            for (n4 = 0; n4 < this._distTableSize; ++n4) {
                this._posSlotPrices[n3 + n4] = ((BitTreeEncoder)object).GetPrice(n4);
            }
            for (n4 = 14; n4 < this._distTableSize; ++n4) {
                object = this._posSlotPrices;
                n2 = n3 + n4;
                object[n2] = object[n2] + ((n4 >> 1) - 1 - 4 << 6);
            }
            int n5 = n * 128;
            n4 = 0;
            while (true) {
                if (n4 >= 4) break;
                this._distancesPrices[n5 + n4] = this._posSlotPrices[n3 + n4];
            }
            for (n2 = ++n4; n2 < 128; ++n2) {
                this._distancesPrices[n5 + n2] = this._posSlotPrices[Encoder.GetPosSlot(n2) + n3] + this.tempPrices[n2];
            }
        }
        this._matchPriceCount = 0;
    }

    void Flush(int n) throws IOException {
        this.ReleaseMFStream();
        this.WriteEndMarker(n & this._posStateMask);
        this._rangeEncoder.FlushData();
        this._rangeEncoder.FlushStream();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    int GetOptimum(int var1_1) throws IOException {
        var2_2 = this._optimumEndIndex;
        var3_3 = this._optimumCurrentIndex;
        if (var2_2 != var3_3) {
            var1_1 = this._optimum[var3_3].PosPrev;
            var2_2 = this._optimumCurrentIndex;
            this.backRes = this._optimum[var2_2].BackPrev;
            this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].PosPrev;
            return var1_1 - var2_2;
        }
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        if (!this._longestMatchWasFound) {
            var3_3 = this.ReadMatchDistances();
        } else {
            var3_3 = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        var4_4 = this._numDistancePairs;
        if (this._matchFinder.GetNumAvailableBytes() + 1 < 2) {
            this.backRes = -1;
            return 1;
        }
        var5_5 = 0;
        for (var2_2 = 0; var2_2 < 4; ++var2_2) {
            var6_6 /* !! */  = this.reps;
            var6_6 /* !! */ [var2_2] = this._repDistances[var2_2];
            this.repLens[var2_2] = this._matchFinder.GetMatchLen(-1, var6_6 /* !! */ [var2_2], 273);
            var6_6 /* !! */  = this.repLens;
            var7_7 = var5_5;
            if (var6_6 /* !! */ [var2_2] > var6_6 /* !! */ [var5_5]) {
                var7_7 = var2_2;
            }
            var5_5 = var7_7;
        }
        var6_6 /* !! */  = this.repLens;
        var2_2 = var6_6 /* !! */ [var5_5];
        var7_7 = this._numFastBytes;
        if (var2_2 >= var7_7) {
            this.backRes = var5_5;
            var1_1 = var6_6 /* !! */ [var5_5];
            this.MovePos(var1_1 - 1);
            return var1_1;
        }
        if (var3_3 >= var7_7) {
            this.backRes = this._matchDistances[var4_4 - 1] + 4;
            this.MovePos(var3_3 - 1);
            return var3_3;
        }
        var8_8 = this._matchFinder.GetIndexByte(-1);
        var9_9 = this._matchFinder.GetIndexByte(0 - this._repDistances[0] - 1 - 1);
        if (var3_3 < 2 && var8_8 != var9_9 && this.repLens[var5_5] < 2) {
            this.backRes = -1;
            return 1;
        }
        var6_6 /* !! */  = (int[])this._optimum;
        var10_10 = var6_6 /* !! */ [0];
        var10_10.State = var2_2 = this._state;
        var11_11 = this._posStateMask & var1_1;
        var6_6 /* !! */ [1].Price = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(var2_2 << 4) + var11_11]) + this._literalEncoder.GetSubCoder(var1_1, this._previousByte).GetPrice(Base.StateIsCharState(this._state) ^ true, var9_9, var8_8);
        this._optimum[1].MakeAsChar();
        var12_12 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(this._state << 4) + var11_11]);
        var13_13 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[this._state]) + var12_12;
        if (var9_9 == var8_8 && (var2_2 = this.GetRepLen1Price(this._state, var11_11) + var13_13) < this._optimum[1].Price) {
            var6_6 /* !! */  = (int[])this._optimum;
            var6_6 /* !! */ [1].Price = var2_2;
            var6_6 /* !! */ [1].MakeAsShortRep();
        }
        if ((var2_2 = var3_3 >= (var6_6 /* !! */  = this.repLens)[var5_5] ? var3_3 : var6_6 /* !! */ [var5_5]) < 2) {
            this.backRes = this._optimum[1].BackPrev;
            return 1;
        }
        var14_14 = this._optimum;
        var14_14[1].PosPrev = 0;
        var6_6 /* !! */  = (int[])var14_14[0];
        var10_10 = this.reps;
        var6_6 /* !! */ .Backs0 = var10_10[0];
        var14_14[0].Backs1 = var10_10[1];
        var14_14[0].Backs2 = var10_10[2];
        var14_14[0].Backs3 = var10_10[3];
        var5_5 = var2_2;
        while (true) {
            var6_6 /* !! */  = (int[])this._optimum;
            var7_7 = var5_5 - 1;
            var6_6 /* !! */ [var5_5].Price = 0xFFFFFFF;
            if (var7_7 < 2) {
                block68: {
                    for (var5_5 = 0; var5_5 < 4; ++var5_5) {
                        var7_7 = this.repLens[var5_5];
                        if (var7_7 < 2) continue;
                        var15_15 = this.GetPureRepPrice(var5_5, this._state, var11_11);
                        do {
                            var16_16 = this._repMatchLenEncoder.GetPrice(var7_7 - 2, var11_11) + (var15_15 + var13_13);
                            var6_6 /* !! */  = (int[])this._optimum[var7_7];
                            if (var16_16 >= var6_6 /* !! */ .Price) continue;
                            var6_6 /* !! */ .Price = var16_16;
                            var6_6 /* !! */ .PosPrev = 0;
                            var6_6 /* !! */ .BackPrev = var5_5;
                            var6_6 /* !! */ .Prev1IsChar = false;
                        } while (--var7_7 >= 2);
                    }
                    var15_15 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRep[this._state]);
                    var6_6 /* !! */  = this.repLens;
                    var5_5 = var6_6 /* !! */ [0] >= 2 ? var6_6 /* !! */ [0] + 1 : 2;
                    if (var5_5 <= var3_3) {
                        var3_3 = 0;
                        while (true) {
                            var7_7 = var3_3;
                            var13_13 = var5_5;
                            if (var5_5 <= this._matchDistances[var3_3]) break;
                            var3_3 += 2;
                        }
                        while (true) {
                            var5_5 = this._matchDistances[var7_7 + 1];
                            var3_3 = this.GetPosLenPrice(var5_5, var13_13, var11_11) + (var12_12 + var15_15);
                            var6_6 /* !! */  = (int[])this._optimum[var13_13];
                            if (var3_3 < var6_6 /* !! */ .Price) {
                                var6_6 /* !! */ .Price = var3_3;
                                var6_6 /* !! */ .PosPrev = 0;
                                var6_6 /* !! */ .BackPrev = var5_5 + 4;
                                var6_6 /* !! */ .Prev1IsChar = false;
                            }
                            var3_3 = var7_7;
                            if (var13_13 == this._matchDistances[var7_7]) {
                                var3_3 = var5_5 = var7_7 + 2;
                                if (var5_5 == var4_4) break;
                            }
                            ++var13_13;
                            var7_7 = var3_3;
                        }
                    }
                    var5_5 = 0;
                    var3_3 = var2_2;
                    var2_2 = var5_5;
                    block6: while (true) {
                        if ((var17_17 = var2_2 + 1) == var3_3) {
                            return this.Backward(var17_17);
                        }
                        var13_13 = this.ReadMatchDistances();
                        var16_16 = this._numDistancePairs;
                        if (var13_13 >= this._numFastBytes) {
                            this._longestMatchLength = var13_13;
                            this._longestMatchWasFound = true;
                            return this.Backward(var17_17);
                        }
                        var11_11 = var1_1 + 1;
                        var2_2 = this._optimum[var17_17].PosPrev;
                        if (this._optimum[var17_17].Prev1IsChar) {
                            --var2_2;
                            if (this._optimum[var17_17].Prev2) {
                                var6_6 /* !! */  = (int[])this._optimum;
                                var1_1 = var6_6 /* !! */ [var6_6 /* !! */ [var17_17].PosPrev2].State;
                                var1_1 = this._optimum[var17_17].BackPrev2 < 4 ? Base.StateUpdateRep(var1_1) : Base.StateUpdateMatch(var1_1);
                            } else {
                                var1_1 = this._optimum[var2_2].State;
                            }
                            var1_1 = Base.StateUpdateChar(var1_1);
                        } else {
                            var1_1 = this._optimum[var2_2].State;
                        }
                        if (var2_2 == var17_17 - 1) {
                            var2_2 = this._optimum[var17_17].IsShortRep() ? Base.StateUpdateShortRep(var1_1) : Base.StateUpdateChar(var1_1);
                        } else {
                            if (this._optimum[var17_17].Prev1IsChar && this._optimum[var17_17].Prev2) {
                                var2_2 = this._optimum[var17_17].PosPrev2;
                                var5_5 = this._optimum[var17_17].BackPrev2;
                                var1_1 = Base.StateUpdateRep(var1_1);
                            } else {
                                var5_5 = this._optimum[var17_17].BackPrev;
                                var1_1 = var5_5 < 4 ? Base.StateUpdateRep(var1_1) : Base.StateUpdateMatch(var1_1);
                            }
                            var10_10 = this._optimum[var2_2];
                            if (var5_5 < 4) {
                                if (var5_5 == 0) {
                                    this.reps[0] = var10_10.Backs0;
                                    this.reps[1] = var10_10.Backs1;
                                    this.reps[2] = var10_10.Backs2;
                                    this.reps[3] = var10_10.Backs3;
                                } else if (var5_5 == 1) {
                                    this.reps[0] = var10_10.Backs1;
                                    this.reps[1] = var10_10.Backs0;
                                    this.reps[2] = var10_10.Backs2;
                                    this.reps[3] = var10_10.Backs3;
                                } else if (var5_5 == 2) {
                                    this.reps[0] = var10_10.Backs2;
                                    this.reps[1] = var10_10.Backs0;
                                    this.reps[2] = var10_10.Backs1;
                                    this.reps[3] = var10_10.Backs3;
                                } else {
                                    this.reps[0] = var10_10.Backs3;
                                    this.reps[1] = var10_10.Backs0;
                                    this.reps[2] = var10_10.Backs1;
                                    this.reps[3] = var10_10.Backs2;
                                }
                            } else {
                                var6_6 /* !! */  = this.reps;
                                var6_6 /* !! */ [0] = var5_5 - 4;
                                var6_6 /* !! */ [1] = var10_10.Backs0;
                                this.reps[2] = var10_10.Backs1;
                                this.reps[3] = var10_10.Backs2;
                            }
                            var2_2 = var1_1;
                        }
                        var10_10 = this._optimum;
                        var10_10[var17_17].State = var2_2;
                        var14_14 = var10_10[var17_17];
                        var6_6 /* !! */  = this.reps;
                        var14_14.Backs0 = var6_6 /* !! */ [0];
                        var10_10[var17_17].Backs1 = var6_6 /* !! */ [1];
                        var10_10[var17_17].Backs2 = var6_6 /* !! */ [2];
                        var10_10[var17_17].Backs3 = var6_6 /* !! */ [3];
                        var4_4 = var10_10[var17_17].Price;
                        var8_8 = this._matchFinder.GetIndexByte(-1);
                        var9_9 = this._matchFinder.GetIndexByte(0 - this.reps[0] - 1 - 1);
                        var18_18 = this._posStateMask & var11_11;
                        var6_6 /* !! */  = this._isMatch;
                        var7_7 = (var2_2 << 4) + var18_18;
                        var19_19 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(var6_6 /* !! */ [var7_7]) + var4_4 + this._literalEncoder.GetSubCoder(var11_11, this._matchFinder.GetIndexByte(-2)).GetPrice(Base.StateIsCharState(var2_2) ^ true, var9_9, var8_8);
                        var6_6 /* !! */  = (int[])this._optimum;
                        var15_15 = var17_17 + 1;
                        var6_6 /* !! */  = (int[])var6_6 /* !! */ [var15_15];
                        if (var19_19 < var6_6 /* !! */ .Price) {
                            var6_6 /* !! */ .Price = var19_19;
                            var6_6 /* !! */ .PosPrev = var17_17;
                            var6_6 /* !! */ .MakeAsChar();
                            var5_5 = 1;
                        } else {
                            var5_5 = 0;
                        }
                        var1_1 = var3_3;
                        var20_20 = var4_4 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[var7_7]);
                        var12_12 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var2_2]) + var20_20;
                        if (var9_9 == var8_8 && (var6_6 /* !! */ .PosPrev >= var17_17 || var6_6 /* !! */ .BackPrev != 0) && (var3_3 = this.GetRepLen1Price(var2_2, var18_18) + var12_12) <= var6_6 /* !! */ .Price) {
                            var6_6 /* !! */ .Price = var3_3;
                            var6_6 /* !! */ .PosPrev = var17_17;
                            var6_6 /* !! */ .MakeAsShortRep();
                            var5_5 = 1;
                        }
                        if ((var4_4 = Math.min(4095 - var17_17, this._matchFinder.GetNumAvailableBytes() + 1)) >= 2) break;
                        var3_3 = var1_1;
                        var1_1 = var11_11;
lbl220:
                        // 2 sources

                        while (true) {
                            var2_2 = var17_17;
                            continue block6;
                            break;
                        }
                        break;
                    }
                    var7_7 = this._numFastBytes;
                    if (var4_4 <= var7_7) {
                        var7_7 = var4_4;
                    }
                    if (var5_5 == 0 && var9_9 != var8_8 && (var21_21 = this._matchFinder.GetMatchLen(0, this.reps[0], var3_3 = Math.min(var4_4 - 1, this._numFastBytes))) >= 2) {
                        var22_22 = Base.StateUpdateChar(var2_2);
                        var23_23 = var11_11 + 1 & this._posStateMask;
                        var24_24 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var22_22 << 4) + var23_23]);
                        var25_25 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var22_22]);
                        var26_26 = var15_15 + var21_21;
                        var3_3 = var13_13;
                        while (var1_1 < var26_26) {
                            var6_6 /* !! */  = (int[])this._optimum;
                            var6_6 /* !! */ [++var1_1].Price = 0xFFFFFFF;
                        }
                        var5_5 = var3_3;
                        var19_19 = var19_19 + var24_24 + var25_25 + this.GetRepPrice(0, var21_21, var22_22, var23_23);
                        var6_6 /* !! */  = (int[])this._optimum[var26_26];
                        var3_3 = var1_1;
                        var13_13 = var5_5;
                        if (var19_19 < var6_6 /* !! */ .Price) {
                            var6_6 /* !! */ .Price = var19_19;
                            var6_6 /* !! */ .PosPrev = var15_15;
                            var6_6 /* !! */ .BackPrev = 0;
                            var6_6 /* !! */ .Prev1IsChar = true;
                            var6_6 /* !! */ .Prev2 = false;
                            var3_3 = var1_1;
                            var13_13 = var5_5;
                        }
                    } else {
                        var3_3 = var1_1;
                    }
                    var5_5 = 2;
                    var1_1 = var3_3;
                    var3_3 = var5_5;
                    var5_5 = var11_11;
                    for (var15_15 = 0; var15_15 < 4; ++var15_15) {
                        var19_19 = this._matchFinder.GetMatchLen(-1, this.reps[var15_15], var7_7);
                        if (var19_19 < 2) continue;
                        var11_11 = var19_19;
                        while (true) {
                            if (var1_1 < (var26_26 = var17_17 + var11_11)) {
                                var6_6 /* !! */  = (int[])this._optimum;
                                var6_6 /* !! */ [++var1_1].Price = 0xFFFFFFF;
                                continue;
                            }
                            var24_24 = this.GetRepPrice(var15_15, var11_11, var2_2, var18_18) + var12_12;
                            var6_6 /* !! */  = (int[])this._optimum[var26_26];
                            if (var24_24 < var6_6 /* !! */ .Price) {
                                var6_6 /* !! */ .Price = var24_24;
                                var6_6 /* !! */ .PosPrev = var17_17;
                                var6_6 /* !! */ .BackPrev = var15_15;
                                var6_6 /* !! */ .Prev1IsChar = false;
                            }
                            if (--var11_11 < 2) break;
                        }
                        if (var15_15 == 0) {
                            var3_3 = var19_19 + 1;
                        }
                        if (var19_19 >= var4_4) continue;
                        var11_11 = Math.min(var4_4 - 1 - var19_19, this._numFastBytes);
                        if ((var11_11 = this._matchFinder.GetMatchLen(var19_19, this.reps[var15_15], var11_11)) < 2) continue;
                        var25_25 = Base.StateUpdateRep(var2_2);
                        var22_22 = var5_5 + var19_19;
                        var24_24 = this._posStateMask;
                        var26_26 = this.GetRepPrice(var15_15, var19_19, var2_2, var18_18);
                        var24_24 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(var25_25 << 4) + (var24_24 & var22_22)]);
                        var6_6 /* !! */  = (int[])this._literalEncoder;
                        var10_10 = this._matchFinder;
                        var23_23 = var19_19 - 1;
                        var23_23 = var6_6 /* !! */ .GetSubCoder(var22_22, var10_10.GetIndexByte(var23_23 - 1)).GetPrice(true, this._matchFinder.GetIndexByte(var23_23 - (this.reps[var15_15] + 1)), this._matchFinder.GetIndexByte(var23_23));
                        var25_25 = Base.StateUpdateChar(var25_25);
                        var22_22 = this._posStateMask & var22_22 + 1;
                        var21_21 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var25_25 << 4) + var22_22]);
                        var27_27 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var25_25]);
                        while (var1_1 < (var28_28 = var17_17 + (var19_19 + 1 + var11_11))) {
                            var6_6 /* !! */  = this._optimum;
                            var6_6 /* !! */ [++var1_1].Price = 0xFFFFFFF;
                        }
                        var11_11 = var12_12 + var26_26 + var24_24 + var23_23 + var21_21 + var27_27 + this.GetRepPrice(0, var11_11, var25_25, var22_22);
                        var6_6 /* !! */  = this._optimum[var28_28];
                        if (var11_11 >= var6_6 /* !! */ .Price) continue;
                        var6_6 /* !! */ .Price = var11_11;
                        var6_6 /* !! */ .PosPrev = var19_19 + var17_17 + 1;
                        var6_6 /* !! */ .BackPrev = 0;
                        var6_6 /* !! */ .Prev1IsChar = true;
                        var6_6 /* !! */ .Prev2 = true;
                        var6_6 /* !! */ .PosPrev2 = var17_17;
                        var6_6 /* !! */ .BackPrev2 = var15_15;
                    }
                    if (var13_13 > var7_7) {
                        var13_13 = 0;
                        while (var7_7 > (var6_6 /* !! */  = (int[])this._matchDistances)[var13_13]) {
                            var13_13 += 2;
                        }
                        var6_6 /* !! */ [var13_13] = var7_7;
                        var11_11 = var13_13 + 2;
                        var13_13 = var7_7;
                    } else {
                        var11_11 = var16_16;
                    }
                    if (var13_13 >= var3_3) {
                        var24_24 = var20_20 + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRep[var2_2]);
                        var7_7 = var1_1;
                        while (var7_7 < var17_17 + var13_13) {
                            var6_6 /* !! */  = (int[])this._optimum;
                            var6_6 /* !! */ [++var7_7].Price = 0xFFFFFFF;
                        }
                        var13_13 = 0;
                        while (true) {
                            var15_15 = var4_4;
                            var26_26 = var13_13;
                            var16_16 = var2_2;
                            var19_19 = var24_24;
                            var20_20 = var3_3;
                            var1_1 = var7_7;
                            var12_12 = var18_18;
                            if (var3_3 <= this._matchDistances[var13_13]) break;
                            var13_13 += 2;
                        }
                        while (true) {
                            var3_3 = this._matchDistances[var26_26 + 1];
                            var7_7 = this.GetPosLenPrice(var3_3, var20_20, var12_12) + var19_19;
                            var6_6 /* !! */  = (int[])this._optimum;
                            var2_2 = var17_17 + var20_20;
                            var6_6 /* !! */  = (int[])var6_6 /* !! */ [var2_2];
                            if (var7_7 < var6_6 /* !! */ .Price) {
                                var6_6 /* !! */ .Price = var7_7;
                                var6_6 /* !! */ .PosPrev = var17_17;
                                var6_6 /* !! */ .BackPrev = var3_3 + 4;
                                var6_6 /* !! */ .Prev1IsChar = false;
                            }
                            if (var20_20 == this._matchDistances[var26_26]) {
                                if (var20_20 < var15_15) {
                                    var13_13 = Math.min(var15_15 - 1 - var20_20, this._numFastBytes);
                                    if ((var13_13 = this._matchFinder.GetMatchLen(var20_20, var3_3, var13_13)) >= 2) {
                                        var24_24 = Base.StateUpdateMatch(var16_16);
                                        var23_23 = var5_5 + var20_20;
                                        var4_4 = this._posStateMask;
                                        var4_4 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isMatch[(var24_24 << 4) + (var4_4 & var23_23)]);
                                        var6_6 /* !! */  = this._literalEncoder;
                                        var10_10 = this._matchFinder;
                                        var18_18 = var20_20 - 1;
                                        var18_18 = var6_6 /* !! */ .GetSubCoder(var23_23, var10_10.GetIndexByte(var18_18 - 1)).GetPrice(true, this._matchFinder.GetIndexByte(var20_20 - (var3_3 + 1) - 1), this._matchFinder.GetIndexByte(var18_18));
                                        var24_24 = Base.StateUpdateChar(var24_24);
                                        var22_22 = this._posStateMask & var23_23 + 1;
                                        var25_25 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isMatch[(var24_24 << 4) + var22_22]);
                                        var23_23 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep[var24_24]);
                                        while (var1_1 < (var21_21 = var17_17 + (var20_20 + 1 + var13_13))) {
                                            var6_6 /* !! */  = this._optimum;
                                            var6_6 /* !! */ [++var1_1].Price = 0xFFFFFFF;
                                        }
                                        var7_7 = var7_7 + var4_4 + var18_18 + var25_25 + var23_23 + this.GetRepPrice(0, var13_13, var24_24, var22_22);
                                        var6_6 /* !! */  = this._optimum[var21_21];
                                        if (var7_7 < var6_6 /* !! */ .Price) {
                                            var6_6 /* !! */ .Price = var7_7;
                                            var6_6 /* !! */ .PosPrev = var2_2 + 1;
                                            var6_6 /* !! */ .BackPrev = 0;
                                            var6_6 /* !! */ .Prev1IsChar = true;
                                            var6_6 /* !! */ .Prev2 = true;
                                            var6_6 /* !! */ .PosPrev2 = var17_17;
                                            var6_6 /* !! */ .BackPrev2 = var3_3 + 4;
                                        }
                                    }
                                }
                                if ((var26_26 += 2) == var11_11) {
                                    var3_3 = var1_1;
                                    break block68;
                                }
                            }
                            ++var20_20;
                        }
                    }
                    var3_3 = var1_1;
                }
                var1_1 = var5_5;
                ** continue;
            }
            var5_5 = var7_7;
        }
    }

    int GetPosLenPrice(int n, int n2, int n3) {
        int n4 = Base.GetLenToPosState(n2);
        if (n < 128) {
            n = this._distancesPrices[n4 * 128 + n];
        } else {
            n4 = this._posSlotPrices[(n4 << 6) + Encoder.GetPosSlot2(n)];
            n = this._alignPrices[n & 0xF] + n4;
        }
        return n + this._lenEncoder.GetPrice(n2 - 2, n3);
    }

    int GetPureRepPrice(int n, int n2, int n3) {
        if (n == 0) {
            n = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRepG0[n2]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRep0Long[(n2 << 4) + n3]);
        } else {
            n3 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRepG0[n2]);
            if (n == 1) {
                n = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRepG1[n2]);
                n2 = n3;
            } else {
                n3 += com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._isRepG1[n2]);
                n = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice(this._isRepG2[n2], n - 2);
                n2 = n3;
            }
            n += n2;
        }
        return n;
    }

    int GetRepLen1Price(int n, int n2) {
        return com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRepG0[n]) + com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._isRep0Long[(n << 4) + n2]);
    }

    int GetRepPrice(int n, int n2, int n3, int n4) {
        return this._repMatchLenEncoder.GetPrice(n2 - 2, n4) + this.GetPureRepPrice(n, n3, n4);
    }

    void Init() {
        this.BaseInit();
        this._rangeEncoder.Init();
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isMatch);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRep0Long);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRep);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRepG0);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRepG1);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._isRepG2);
        com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._posEncoders);
        this._literalEncoder.Init();
        for (int i = 0; i < 4; ++i) {
            this._posSlotEncoder[i].Init();
        }
        this._lenEncoder.Init(1 << this._posStateBits);
        this._repMatchLenEncoder.Init(1 << this._posStateBits);
        this._posAlignEncoder.Init();
        this._longestMatchWasFound = false;
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        this._additionalOffset = 0;
    }

    void MovePos(int n) throws IOException {
        if (n > 0) {
            this._matchFinder.Skip(n);
            this._additionalOffset += n;
        }
    }

    int ReadMatchDistances() throws IOException {
        int n;
        this._numDistancePairs = this._matchFinder.GetMatches(this._matchDistances);
        int n2 = this._numDistancePairs;
        if (n2 > 0) {
            int n3;
            int[] nArray = this._matchDistances;
            n = n3 = nArray[n2 - 2];
            if (n3 == this._numFastBytes) {
                n = n3 + this._matchFinder.GetMatchLen(n3 - 1, nArray[n2 - 1], 273 - n3);
            }
        } else {
            n = 0;
        }
        ++this._additionalOffset;
        return n;
    }

    void ReleaseMFStream() {
        BinTree binTree = this._matchFinder;
        if (binTree != null && this._needReleaseMFStream) {
            binTree.ReleaseStream();
            this._needReleaseMFStream = false;
        }
    }

    void ReleaseOutStream() {
        this._rangeEncoder.ReleaseStream();
    }

    void ReleaseStreams() {
        this.ReleaseMFStream();
        this.ReleaseOutStream();
    }

    public boolean SetAlgorithm(int n) {
        return true;
    }

    public boolean SetDictionarySize(int n) {
        int n2 = 0;
        if (n >= 1 && n <= 0x20000000) {
            this._dictionarySize = n;
            while (n > 1 << n2) {
                ++n2;
            }
            this._distTableSize = n2 * 2;
            return true;
        }
        return false;
    }

    public void SetEndMarkerMode(boolean bl) {
        this._writeEndMark = bl;
    }

    public boolean SetLcLpPb(int n, int n2, int n3) {
        if (n2 >= 0 && n2 <= 4 && n >= 0 && n <= 8 && n3 >= 0 && n3 <= 4) {
            this._numLiteralPosStateBits = n2;
            this._numLiteralContextBits = n;
            this._posStateBits = n3;
            this._posStateMask = (1 << this._posStateBits) - 1;
            return true;
        }
        return false;
    }

    public boolean SetMatchFinder(int n) {
        if (n >= 0 && n <= 2) {
            int n2 = this._matchFinderType;
            this._matchFinderType = n;
            if (this._matchFinder != null && n2 != this._matchFinderType) {
                this._dictionarySizePrev = -1;
                this._matchFinder = null;
            }
            return true;
        }
        return false;
    }

    public boolean SetNumFastBytes(int n) {
        if (n >= 5 && n <= 273) {
            this._numFastBytes = n;
            return true;
        }
        return false;
    }

    void SetOutStream(OutputStream outputStream) {
        this._rangeEncoder.SetStream(outputStream);
    }

    void SetStreams(InputStream inputStream, OutputStream outputStream, long l, long l2) {
        this._inStream = inputStream;
        this._finished = false;
        this.Create();
        this.SetOutStream(outputStream);
        this.Init();
        this.FillDistancesPrices();
        this.FillAlignPrices();
        this._lenEncoder.SetTableSize(this._numFastBytes + 1 - 2);
        this._lenEncoder.UpdateTables(1 << this._posStateBits);
        this._repMatchLenEncoder.SetTableSize(this._numFastBytes + 1 - 2);
        this._repMatchLenEncoder.UpdateTables(1 << this._posStateBits);
        this.nowPos64 = 0L;
    }

    void SetWriteEndMarkerMode(boolean bl) {
        this._writeEndMark = bl;
    }

    public void WriteCoderProperties(OutputStream outputStream) throws IOException {
        this.properties[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
        int n = 0;
        while (n < 4) {
            byte[] byArray = this.properties;
            int n2 = n + 1;
            byArray[n2] = (byte)(this._dictionarySize >> n * 8);
            n = n2;
        }
        outputStream.write(this.properties, 0, 5);
    }

    void WriteEndMarker(int n) throws IOException {
        if (!this._writeEndMark) {
            return;
        }
        this._rangeEncoder.Encode(this._isMatch, (this._state << 4) + n, 1);
        this._rangeEncoder.Encode(this._isRep, this._state, 0);
        this._state = Base.StateUpdateMatch(this._state);
        this._lenEncoder.Encode(this._rangeEncoder, 0, n);
        n = Base.GetLenToPosState(2);
        this._posSlotEncoder[n].Encode(this._rangeEncoder, 63);
        this._rangeEncoder.EncodeDirectBits(0x3FFFFFF, 26);
        this._posAlignEncoder.ReverseEncode(this._rangeEncoder, 15);
    }

    class LenEncoder {
        short[] _choice = new short[2];
        BitTreeEncoder _highCoder;
        BitTreeEncoder[] _lowCoder = new BitTreeEncoder[16];
        BitTreeEncoder[] _midCoder = new BitTreeEncoder[16];

        public LenEncoder() {
            this._highCoder = new BitTreeEncoder(8);
            for (int i = 0; i < 16; ++i) {
                this._lowCoder[i] = new BitTreeEncoder(3);
                this._midCoder[i] = new BitTreeEncoder(3);
            }
        }

        public void Encode(com.badlogic.gdx.utils.compression.rangecoder.Encoder encoder, int n, int n2) throws IOException {
            if (n < 8) {
                encoder.Encode(this._choice, 0, 0);
                this._lowCoder[n2].Encode(encoder, n);
            } else {
                encoder.Encode(this._choice, 0, 1);
                if ((n -= 8) < 8) {
                    encoder.Encode(this._choice, 1, 0);
                    this._midCoder[n2].Encode(encoder, n);
                } else {
                    encoder.Encode(this._choice, 1, 1);
                    this._highCoder.Encode(encoder, n - 8);
                }
            }
        }

        public void Init(int n) {
            com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this._choice);
            for (int i = 0; i < n; ++i) {
                this._lowCoder[i].Init();
                this._midCoder[i].Init();
            }
            this._highCoder.Init();
        }

        public void SetPrices(int n, int n2, int[] nArray, int n3) {
            int n4;
            short[] sArray = this._choice;
            int n5 = 0;
            int n6 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(sArray[0]);
            int n7 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._choice[0]);
            int n8 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice0(this._choice[1]);
            int n9 = com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice1(this._choice[1]);
            while (true) {
                n4 = ++n5;
                if (n5 >= 8) break;
                if (n5 >= n2) {
                    return;
                }
                nArray[n3 + n5] = this._lowCoder[n].GetPrice(n5) + n6;
            }
            while (true) {
                if (n4 >= 16) break;
                if (n4 >= n2) {
                    return;
                }
                nArray[n3 + n4] = this._midCoder[n].GetPrice(n4 - 8) + (n8 + n7);
            }
            for (n5 = ++n4; n5 < n2; ++n5) {
                nArray[n3 + n5] = this._highCoder.GetPrice(n5 - 8 - 8) + (n7 + n9);
            }
        }
    }

    class LenPriceTableEncoder
    extends LenEncoder {
        int[] _counters;
        int[] _prices = new int[4352];
        int _tableSize;

        LenPriceTableEncoder() {
            this._counters = new int[16];
        }

        @Override
        public void Encode(com.badlogic.gdx.utils.compression.rangecoder.Encoder object, int object2, int n) throws IOException {
            super.Encode((com.badlogic.gdx.utils.compression.rangecoder.Encoder)object, (int)object2, n);
            object = this._counters;
            object2 = object[n] - true;
            object[n] = object2;
            if (object2 == 0) {
                this.UpdateTable(n);
            }
        }

        public int GetPrice(int n, int n2) {
            return this._prices[n2 * 272 + n];
        }

        public void SetTableSize(int n) {
            this._tableSize = n;
        }

        void UpdateTable(int n) {
            this.SetPrices(n, this._tableSize, this._prices, n * 272);
            this._counters[n] = this._tableSize;
        }

        public void UpdateTables(int n) {
            for (int i = 0; i < n; ++i) {
                this.UpdateTable(i);
            }
        }
    }

    class LiteralEncoder {
        Encoder2[] m_Coders;
        int m_NumPosBits;
        int m_NumPrevBits;
        int m_PosMask;

        LiteralEncoder() {
        }

        public void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            n2 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Encoder2[n2];
            for (n = 0; n < n2; ++n) {
                this.m_Coders[n] = new Encoder2();
            }
        }

        public Encoder2 GetSubCoder(int n, byte by) {
            Encoder2[] encoder2Array = this.m_Coders;
            int n2 = this.m_PosMask;
            int n3 = this.m_NumPrevBits;
            return encoder2Array[((n & n2) << n3) + ((by & 0xFF) >>> 8 - n3)];
        }

        public void Init() {
            int n = this.m_NumPrevBits;
            int n2 = this.m_NumPosBits;
            for (int i = 0; i < 1 << n + n2; ++i) {
                this.m_Coders[i].Init();
            }
        }

        class Encoder2 {
            short[] m_Encoders = new short[768];

            Encoder2() {
            }

            public void Encode(com.badlogic.gdx.utils.compression.rangecoder.Encoder encoder, byte by) throws IOException {
                int n = 1;
                for (int i = 7; i >= 0; --i) {
                    int n2 = by >> i & 1;
                    encoder.Encode(this.m_Encoders, n, n2);
                    n = n << 1 | n2;
                }
            }

            public void EncodeMatched(com.badlogic.gdx.utils.compression.rangecoder.Encoder encoder, byte by, byte by2) throws IOException {
                int n = 1;
                int n2 = 1;
                for (int i = 7; i >= 0; --i) {
                    int n3;
                    int n4 = by2 >> i & 1;
                    if (n2 != 0) {
                        n2 = by >> i & 1;
                        n3 = (n2 + 1 << 8) + n;
                        n2 = n2 == n4 ? 1 : 0;
                    } else {
                        n3 = n;
                    }
                    encoder.Encode(this.m_Encoders, n3, n4);
                    n = n << 1 | n4;
                }
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            public int GetPrice(boolean bl, byte by, byte by2) {
                int n;
                int n2;
                int n3 = 0;
                int n4 = 0;
                int n5 = 7;
                if (!bl) {
                    n2 = 1;
                    n = n5;
                } else {
                    int n6 = 1;
                    while (true) {
                        n3 = n4;
                        n = n5;
                        n2 = n6;
                        if (n5 < 0) break;
                        n2 = by >> n5 & 1;
                        n = by2 >> n5 & 1;
                        n4 += com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice(this.m_Encoders[(n2 + 1 << 8) + n6], n);
                        n6 = n6 << 1 | n;
                        if (n2 != n) {
                            n3 = n4;
                            n2 = n6;
                            n = n5 - 1;
                        }
                        --n5;
                    }
                }
                while (n >= 0) {
                    by = (byte)(by2 >> n & 1);
                    n3 += com.badlogic.gdx.utils.compression.rangecoder.Encoder.GetPrice(this.m_Encoders[n2], by);
                    n2 = n2 << 1 | by;
                    n5 = n;
                    n = n5 - 1;
                }
                return n3;
            }

            public void Init() {
                com.badlogic.gdx.utils.compression.rangecoder.Encoder.InitBitModels(this.m_Encoders);
            }
        }
    }

    class Optimal {
        public int BackPrev;
        public int BackPrev2;
        public int Backs0;
        public int Backs1;
        public int Backs2;
        public int Backs3;
        public int PosPrev;
        public int PosPrev2;
        public boolean Prev1IsChar;
        public boolean Prev2;
        public int Price;
        public int State;

        Optimal() {
        }

        public boolean IsShortRep() {
            boolean bl = this.BackPrev == 0;
            return bl;
        }

        public void MakeAsChar() {
            this.BackPrev = -1;
            this.Prev1IsChar = false;
        }

        public void MakeAsShortRep() {
            this.BackPrev = 0;
            this.Prev1IsChar = false;
        }
    }
}

