/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.NoSuchElementException;

public class OrderedSet<T>
extends ObjectSet<T> {
    final Array<T> items;
    OrderedSetIterator iterator1;
    OrderedSetIterator iterator2;

    public OrderedSet() {
        this.items = new Array();
    }

    public OrderedSet(int n) {
        super(n);
        this.items = new Array(this.capacity);
    }

    public OrderedSet(int n, float f) {
        super(n, f);
        this.items = new Array(this.capacity);
    }

    public OrderedSet(OrderedSet<? extends T> orderedSet) {
        super(orderedSet);
        this.items = new Array(this.capacity);
        this.items.addAll(orderedSet.items);
    }

    @Override
    public boolean add(T t) {
        if (!super.add(t)) {
            return false;
        }
        this.items.add(t);
        return true;
    }

    public boolean add(T t, int n) {
        if (!super.add(t)) {
            this.items.removeValue(t, true);
            this.items.insert(n, t);
            return false;
        }
        this.items.insert(n, t);
        return true;
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    @Override
    public void clear(int n) {
        this.items.clear();
        super.clear(n);
    }

    @Override
    public OrderedSetIterator<T> iterator() {
        if (Collections.allocateIterators) {
            return new OrderedSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new OrderedSetIterator(this);
            this.iterator2 = new OrderedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            OrderedSetIterator orderedSetIterator = this.iterator1;
            orderedSetIterator.valid = true;
            this.iterator2.valid = false;
            return orderedSetIterator;
        }
        this.iterator2.reset();
        OrderedSetIterator orderedSetIterator = this.iterator2;
        orderedSetIterator.valid = true;
        this.iterator1.valid = false;
        return orderedSetIterator;
    }

    public Array<T> orderedItems() {
        return this.items;
    }

    @Override
    public boolean remove(T t) {
        if (!super.remove(t)) {
            return false;
        }
        this.items.removeValue(t, false);
        return true;
    }

    public T removeIndex(int n) {
        T t = this.items.removeIndex(n);
        super.remove(t);
        return t;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        T[] TArray = this.items.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        stringBuilder.append(TArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[i]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public String toString(String string2) {
        return this.items.toString(string2);
    }

    public static class OrderedSetIterator<T>
    extends ObjectSet.ObjectSetIterator<T> {
        private Array<T> items;

        public OrderedSetIterator(OrderedSet<T> orderedSet) {
            super(orderedSet);
            this.items = orderedSet.items;
        }

        @Override
        public T next() {
            if (this.hasNext) {
                if (this.valid) {
                    T t = this.items.get(this.nextIndex);
                    int n = this.nextIndex;
                    boolean bl = true;
                    this.nextIndex = n + 1;
                    if (this.nextIndex >= this.set.size) {
                        bl = false;
                    }
                    this.hasNext = bl;
                    return t;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.nextIndex >= 0) {
                --this.nextIndex;
                ((OrderedSet)this.set).removeIndex(this.nextIndex);
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        @Override
        public void reset() {
            boolean bl = false;
            this.nextIndex = 0;
            if (this.set.size > 0) {
                bl = true;
            }
            this.hasNext = bl;
        }
    }
}

