/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectFloatMap<K>
implements Iterable<Entry<K>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    private int hashShift;
    K[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    float[] valueTable;
    private Values values1;
    private Values values2;

    public ObjectFloatMap() {
        this(51, 0.8f);
    }

    public ObjectFloatMap(int n) {
        this(n, 0.8f);
    }

    public ObjectFloatMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new Object[this.capacity + this.stashCapacity];
                    this.valueTable = new float[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public ObjectFloatMap(ObjectFloatMap<? extends K> objectFloatMap) {
        this((int)Math.floor((float)objectFloatMap.capacity * objectFloatMap.loadFactor), objectFloatMap.loadFactor);
        this.stashSize = objectFloatMap.stashSize;
        Object[] objectArray = objectFloatMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = objectFloatMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = objectFloatMap.size;
    }

    private boolean containsKeyStash(K k) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!k.equals(KArray[i])) continue;
            return true;
        }
        return false;
    }

    private float getAndIncrementStash(K object, float object2, float f) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!object.equals(KArray[i])) continue;
            object = this.valueTable;
            object2 = object[i];
            object[i] = f + object2;
            return object2;
        }
        this.put(object, f + object2);
        return object2;
    }

    private float getStash(K k, float f) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!k.equals(KArray[i])) continue;
            return this.valueTable[i];
        }
        return f;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(K k, float f, int n, K k2, int n2, K k3, int n3, K k4) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n4 = this.mask;
        int n5 = this.pushIterations;
        int n6 = n;
        int n7 = n2;
        n2 = n3;
        n = 0;
        n3 = n7;
        float f2 = f;
        K k5 = k;
        do {
            if ((n7 = MathUtils.random(2)) != 0) {
                if (n7 != 1) {
                    f = fArray[n2];
                    KArray[n2] = k5;
                    fArray[n2] = f2;
                    k = k4;
                } else {
                    f = fArray[n3];
                    KArray[n3] = k5;
                    fArray[n3] = f2;
                    k = k3;
                }
            } else {
                f = fArray[n6];
                KArray[n6] = k5;
                fArray[n6] = f2;
                k = k2;
            }
            n2 = k.hashCode();
            n6 = n2 & n4;
            k2 = KArray[n6];
            if (k2 == null) {
                KArray[n6] = k;
                fArray[n6] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n2);
            k3 = KArray[n3];
            if (k3 == null) {
                KArray[n3] = k;
                fArray[n3] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            k4 = KArray[n2 = this.hash3(n2)];
            if (k4 == null) {
                KArray[n2] = k;
                fArray[n2] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = n + 1;
            k5 = k;
            f2 = f;
            n = n7;
        } while (n7 != n5);
        this.putStash(k, f);
    }

    private void putResize(K k, float f) {
        Object object = this.keyTable;
        int n = k.hashCode();
        int n2 = n & this.mask;
        K k2 = object[n2];
        if (k2 == null) {
            object[n2] = k;
            this.valueTable[n2] = f;
            int n3 = this.size;
            this.size = n3 + 1;
            if (n3 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        K[] KArray = this.keyTable;
        int n4 = this.hash2(n);
        object = KArray[n4];
        if (object == null) {
            KArray[n4] = k;
            this.valueTable[n4] = f;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        KArray = this.keyTable;
        K k3 = KArray[n = this.hash3(n)];
        if (k3 == null) {
            KArray[n] = k;
            this.valueTable[n] = f;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, f, n2, k2, n4, object, n, k3);
    }

    private void putStash(K k, float f) {
        int n = this.stashSize;
        if (n == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(k, f);
            return;
        }
        int n2 = this.capacity + n;
        this.keyTable[n2] = k;
        this.valueTable[n2] = f;
        this.stashSize = n + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new Object[n + n4];
        this.valueTable = new float[n + n4];
        n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                K k = KArray[n];
                if (k == null) continue;
                this.putResize(k, fArray[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            KArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(K k) {
        int n = this.mask;
        int n2 = k.hashCode();
        if (!(k.equals(this.keyTable[n & n2]) || k.equals(this.keyTable[n = this.hash2(n2)]) || k.equals(this.keyTable[n2 = this.hash3(n2)]))) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    public boolean containsValue(float f) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            if (KArray[n2] != null && fArray[n2] == f) {
                return true;
            }
            n = n2;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<K> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectFloatMap)) {
            return false;
        }
        object = (ObjectFloatMap)object;
        if (((ObjectFloatMap)object).size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            float f = ((ObjectFloatMap)object).get(k, 0.0f);
            if (f == 0.0f && !((ObjectFloatMap)object).containsKey(k)) {
                return false;
            }
            if (f == fArray[i]) continue;
            return false;
        }
        return true;
    }

    public K findKey(float f) {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            if (KArray[n2] != null && fArray[n2] == f) {
                return KArray[n2];
            }
            n = n2;
        }
        return null;
    }

    public float get(K k, float f) {
        int n;
        int n2 = k.hashCode();
        int n3 = n = this.mask & n2;
        if (!k.equals(this.keyTable[n])) {
            n3 = n = this.hash2(n2);
            if (!k.equals(this.keyTable[n])) {
                n3 = n = this.hash3(n2);
                if (!k.equals(this.keyTable[n])) {
                    return this.getStash(k, f);
                }
            }
        }
        return this.valueTable[n3];
    }

    public float getAndIncrement(K object, float object2, float f) {
        int n;
        int n2 = object.hashCode();
        int n3 = n = this.mask & n2;
        if (!object.equals(this.keyTable[n])) {
            n3 = n = this.hash2(n2);
            if (!object.equals(this.keyTable[n])) {
                n3 = n = this.hash3(n2);
                if (!object.equals(this.keyTable[n])) {
                    return this.getAndIncrementStash((K)object, (float)object2, f);
                }
            }
        }
        object = this.valueTable;
        object2 = object[n3];
        object[n3] = f + object2;
        return object2;
    }

    public int hashCode() {
        K[] KArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            int n4 = n3;
            if (k != null) {
                n4 = n3 + k.hashCode() * 31 + Float.floatToIntBits(fArray[i]);
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public void put(K object, float f) {
        if (object != null) {
            K[] KArray = this.keyTable;
            int n = object.hashCode();
            int n2 = n & this.mask;
            K k = KArray[n2];
            if (object.equals(k)) {
                this.valueTable[n2] = f;
                return;
            }
            int n3 = this.hash2(n);
            K k2 = KArray[n3];
            if (object.equals(k2)) {
                this.valueTable[n3] = f;
                return;
            }
            int n4 = this.hash3(n);
            K k3 = KArray[n4];
            if (object.equals(k3)) {
                this.valueTable[n4] = f;
                return;
            }
            int n5 = this.capacity;
            int n6 = this.stashSize;
            for (n = n5; n < n6 + n5; ++n) {
                if (!object.equals(KArray[n])) continue;
                this.valueTable[n] = f;
                return;
            }
            if (k == null) {
                KArray[n2] = object;
                this.valueTable[n2] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (k2 == null) {
                KArray[n3] = object;
                this.valueTable[n3] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (k3 == null) {
                KArray[n4] = object;
                this.valueTable[n4] = f;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            this.push(object, f, n2, k, n3, k2, n4, k3);
            return;
        }
        object = new IllegalArgumentException("key cannot be null.");
        throw object;
    }

    public void putAll(ObjectFloatMap<? extends K> object) {
        for (Entry entry : ((ObjectFloatMap)object).entries()) {
            this.put(entry.key, entry.value);
        }
    }

    public float remove(K k, float f) {
        int n = k.hashCode();
        int n2 = this.mask & n;
        if (k.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            f = this.valueTable[n2];
            --this.size;
            return f;
        }
        n2 = this.hash2(n);
        if (k.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            f = this.valueTable[n2];
            --this.size;
            return f;
        }
        if (k.equals(this.keyTable[n = this.hash3(n)])) {
            this.keyTable[n] = null;
            f = this.valueTable[n];
            --this.size;
            return f;
        }
        return this.removeStash(k, f);
    }

    float removeStash(K k, float f) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!k.equals(KArray[i])) continue;
            f = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return f;
        }
        return f;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            K[] KArray = this.keyTable;
            KArray[n] = KArray[n2];
            float[] fArray = this.valueTable;
            fArray[n] = fArray[n2];
            KArray[n2] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        K k;
        int n;
        int n2;
        float[] fArray;
        K[] KArray;
        StringBuilder stringBuilder;
        block4: {
            if (this.size == 0) {
                return "{}";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('{');
            KArray = this.keyTable;
            fArray = this.valueTable;
            int n3 = KArray.length;
            while (true) {
                n = n2 = n3 - 1;
                if (n3 <= 0) break block4;
                k = KArray[n2];
                if (k != null) break;
                n3 = n2;
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
            n = n2;
        }
        while (true) {
            n2 = n - 1;
            if (n <= 0) break;
            k = KArray[n2];
            if (k != null) {
                stringBuilder.append(", ");
                stringBuilder.append(k);
                stringBuilder.append('=');
                stringBuilder.append(fArray[n2]);
            }
            n = n2;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Values values() {
        if (Collections.allocateIterators) {
            return new Values((ObjectFloatMap<?>)this);
        }
        if (this.values1 == null) {
            this.values1 = new Values((ObjectFloatMap<?>)this);
            this.values2 = new Values((ObjectFloatMap<?>)this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        private Entry<K> entry = new Entry();

        public Entries(ObjectFloatMap<K> objectFloatMap) {
            super(objectFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public Entry<K> next() {
            if (this.hasNext) {
                if (this.valid) {
                    K[] KArray = this.map.keyTable;
                    this.entry.key = KArray[this.nextIndex];
                    this.entry.value = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<K> {
        public K key;
        public float value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys<K>
    extends MapIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(ObjectFloatMap<K> objectFloatMap) {
            super(objectFloatMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object k = this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return k;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    private static class MapIterator<K> {
        int currentIndex;
        public boolean hasNext;
        final ObjectFloatMap<K> map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(ObjectFloatMap<K> objectFloatMap) {
            this.map = objectFloatMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                K[] KArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
            }
        }

        public void remove() {
            int n = this.currentIndex;
            if (n >= 0) {
                if (n >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = null;
                }
                this.currentIndex = -1;
                ObjectFloatMap<K> objectFloatMap = this.map;
                --objectFloatMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }
    }

    public static class Values
    extends MapIterator<Object> {
        public Values(ObjectFloatMap<?> objectFloatMap) {
            super(objectFloatMap);
        }

        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public float next() {
            if (this.hasNext) {
                if (this.valid) {
                    float f = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return f;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public FloatArray toArray() {
            FloatArray floatArray = new FloatArray(true, this.map.size);
            while (this.hasNext) {
                floatArray.add(this.next());
            }
            return floatArray;
        }
    }
}

