/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.Queue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Json {
    private static final boolean debug = false;
    private final ObjectMap<Class, Object[]> classToDefaultValues;
    private final ObjectMap<Class, Serializer> classToSerializer;
    private final ObjectMap<Class, String> classToTag;
    private Serializer defaultSerializer;
    private boolean enumNames = true;
    private final Object[] equals1;
    private final Object[] equals2;
    private boolean ignoreDeprecated;
    private boolean ignoreUnknownFields;
    private JsonWriter.OutputType outputType;
    private boolean quoteLongValues;
    private boolean readDeprecated;
    private boolean sortFields;
    private final ObjectMap<String, Class> tagToClass;
    private String typeName = "class";
    private final ObjectMap<Class, OrderedMap<String, FieldMetadata>> typeToFields = new ObjectMap();
    private boolean usePrototypes = true;
    private JsonWriter writer;

    public Json() {
        this.tagToClass = new ObjectMap();
        this.classToTag = new ObjectMap();
        this.classToSerializer = new ObjectMap();
        this.classToDefaultValues = new ObjectMap();
        this.equals1 = new Object[]{null};
        this.equals2 = new Object[]{null};
        this.outputType = JsonWriter.OutputType.minimal;
    }

    public Json(JsonWriter.OutputType outputType) {
        this.tagToClass = new ObjectMap();
        this.classToTag = new ObjectMap();
        this.classToSerializer = new ObjectMap();
        this.classToDefaultValues = new ObjectMap();
        this.equals1 = new Object[]{null};
        this.equals2 = new Object[]{null};
        this.outputType = outputType;
    }

    private String convertToString(Enum object) {
        object = this.enumNames ? ((Enum)object).name() : ((Enum)object).toString();
        return object;
    }

    private String convertToString(Object object) {
        if (object instanceof Enum) {
            return this.convertToString((Enum)object);
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    private Object[] getDefaultValues(Class clazz) {
        Object object4;
        Object object2;
        if (!this.usePrototypes) {
            return null;
        }
        if (this.classToDefaultValues.containsKey(clazz)) {
            return this.classToDefaultValues.get(clazz);
        }
        try {
            object2 = this.newInstance(clazz);
            object4 = this.getFields(clazz);
        }
        catch (Exception exception) {
            this.classToDefaultValues.put(clazz, null);
            return null;
        }
        Object object3 = new Object[((ObjectMap)object4).size];
        this.classToDefaultValues.put(clazz, (Object[])object3);
        int n = 0;
        for (Object object4 : ((ObjectMap)object4).values()) {
            if (this.ignoreDeprecated && ((FieldMetadata)object4).deprecated) continue;
            object4 = ((FieldMetadata)object4).field;
            try {
                object3[n] = ((Field)object4).get(object2);
                ++n;
            }
            catch (RuntimeException runtimeException) {
                object2 = new SerializationException(runtimeException);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object4);
                stringBuilder.append(" (");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(")");
                ((SerializationException)object2).addTrace(stringBuilder.toString());
                throw object2;
            }
            catch (SerializationException serializationException) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append(object4);
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(clazz.getName());
                ((StringBuilder)object3).append(")");
                serializationException.addTrace(((StringBuilder)object3).toString());
                throw serializationException;
            }
            catch (ReflectionException reflectionException) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Error accessing field: ");
                ((StringBuilder)object3).append(((Field)object4).getName());
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(clazz.getName());
                ((StringBuilder)object3).append(")");
                throw new SerializationException(((StringBuilder)object3).toString(), reflectionException);
            }
        }
        return object3;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OrderedMap<String, FieldMetadata> getFields(Class clazz) {
        int n;
        Object object = this.typeToFields.get(clazz);
        if (object != null) {
            return object;
        }
        Iterable iterable = new Array();
        for (object = clazz; object != Object.class; object = ((Class)object).getSuperclass()) {
            ((Array)iterable).add(object);
        }
        object = new ArrayList();
        for (n = ((Array)iterable).size - 1; n >= 0; --n) {
            Collections.addAll(object, ClassReflection.getDeclaredFields((Class)((Array)iterable).get(n)));
        }
        iterable = new OrderedMap(((ArrayList)object).size());
        n = 0;
        int n2 = ((ArrayList)object).size();
        while (true) {
            if (n < n2) {
                Field field = (Field)((ArrayList)object).get(n);
                if (!(field.isTransient() || field.isStatic() || field.isSynthetic())) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    ((OrderedMap)iterable).put(field.getName(), new FieldMetadata(field));
                }
            } else {
                if (this.sortFields) {
                    ((OrderedMap)iterable).keys.sort();
                }
                this.typeToFields.put(clazz, (OrderedMap<String, FieldMetadata>)iterable);
                return iterable;
                catch (AccessControlException accessControlException) {}
            }
            ++n;
        }
    }

    public void addClassTag(String string2, Class clazz) {
        this.tagToClass.put(string2, clazz);
        this.classToTag.put(clazz, string2);
    }

    public void copyFields(Object object, Object object2) {
        OrderedMap<String, FieldMetadata> orderedMap = this.getFields(object.getClass());
        for (ObjectMap.Entry entry : this.getFields(object.getClass())) {
            FieldMetadata fieldMetadata = (FieldMetadata)orderedMap.get((String)entry.key);
            Field field = ((FieldMetadata)entry.value).field;
            if (fieldMetadata != null) {
                try {
                    fieldMetadata.field.set(object2, field.get(object));
                    continue;
                }
                catch (ReflectionException reflectionException) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Error copying field: ");
                    ((StringBuilder)object2).append(field.getName());
                    throw new SerializationException(((StringBuilder)object2).toString(), reflectionException);
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("To object is missing field");
            ((StringBuilder)object).append((String)entry.key);
            throw new SerializationException(((StringBuilder)object).toString());
        }
    }

    public <T> T fromJson(Class<T> clazz, FileHandle fileHandle) {
        try {
            JsonReader jsonReader = new JsonReader();
            clazz = this.readValue(clazz, null, jsonReader.parse(fileHandle));
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error reading file: ");
            stringBuilder.append(fileHandle);
            throw new SerializationException(stringBuilder.toString(), exception);
        }
        return (T)clazz;
    }

    public <T> T fromJson(Class<T> clazz, InputStream inputStream) {
        return this.readValue(clazz, null, new JsonReader().parse(inputStream));
    }

    public <T> T fromJson(Class<T> clazz, Reader reader) {
        return this.readValue(clazz, null, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> serializable, Class clazz, FileHandle fileHandle) {
        try {
            JsonReader jsonReader = new JsonReader();
            serializable = this.readValue((Class<T>)serializable, clazz, jsonReader.parse(fileHandle));
        }
        catch (Exception exception) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("Error reading file: ");
            ((StringBuilder)serializable).append(fileHandle);
            throw new SerializationException(((StringBuilder)serializable).toString(), exception);
        }
        return (T)serializable;
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, InputStream inputStream) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(inputStream));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, Reader reader) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, String string2) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(string2));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, char[] cArray, int n, int n2) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(cArray, n, n2));
    }

    public <T> T fromJson(Class<T> clazz, String string2) {
        return this.readValue(clazz, null, new JsonReader().parse(string2));
    }

    public <T> T fromJson(Class<T> clazz, char[] cArray, int n, int n2) {
        return this.readValue(clazz, null, new JsonReader().parse(cArray, n, n2));
    }

    public Class getClass(String string2) {
        return this.tagToClass.get(string2);
    }

    public boolean getIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public <T> Serializer<T> getSerializer(Class<T> clazz) {
        return this.classToSerializer.get(clazz);
    }

    public String getTag(Class clazz) {
        return this.classToTag.get(clazz);
    }

    public JsonWriter getWriter() {
        return this.writer;
    }

    protected boolean ignoreUnknownField(Class clazz, String string2) {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object newInstance(Class clazz) {
        try {
            return ClassReflection.newInstance(clazz);
        }
        catch (Exception exception) {
            void var2_6;
            try {
                Constructor constructor = ClassReflection.getDeclaredConstructor(clazz, new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception exception2) {
            }
            catch (ReflectionException reflectionException) {
                if (ClassReflection.isAssignableFrom(Enum.class, clazz)) {
                    Class clazz2 = clazz;
                    if (clazz.getEnumConstants() != null) return clazz2.getEnumConstants()[0];
                    clazz2 = clazz.getSuperclass();
                    return clazz2.getEnumConstants()[0];
                }
                if (clazz.isArray()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Encountered JSON object when expected array of type: ");
                    stringBuilder.append(clazz.getName());
                    throw new SerializationException(stringBuilder.toString(), exception);
                }
                if (ClassReflection.isMemberClass(clazz) && !ClassReflection.isStaticClass(clazz)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Class cannot be created (non-static member class): ");
                    stringBuilder.append(clazz.getName());
                    throw new SerializationException(stringBuilder.toString(), exception);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Class cannot be created (missing no-arg constructor): ");
                stringBuilder.append(clazz.getName());
                throw new SerializationException(stringBuilder.toString(), exception);
            }
            catch (SecurityException securityException) {}
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error constructing instance of class: ");
            stringBuilder.append(clazz.getName());
            throw new SerializationException(stringBuilder.toString(), (Throwable)var2_6);
        }
    }

    public String prettyPrint(Object object) {
        return this.prettyPrint(object, 0);
    }

    public String prettyPrint(Object object, int n) {
        return this.prettyPrint(this.toJson(object), n);
    }

    public String prettyPrint(Object object, JsonValue.PrettyPrintSettings prettyPrintSettings) {
        return this.prettyPrint(this.toJson(object), prettyPrintSettings);
    }

    public String prettyPrint(String string2) {
        return this.prettyPrint(string2, 0);
    }

    public String prettyPrint(String string2, int n) {
        return new JsonReader().parse(string2).prettyPrint(this.outputType, n);
    }

    public String prettyPrint(String string2, JsonValue.PrettyPrintSettings prettyPrintSettings) {
        return new JsonReader().parse(string2).prettyPrint(prettyPrintSettings);
    }

    public void readField(Object object, Field field, String object2, Class clazz, JsonValue jsonValue) {
        if ((object2 = jsonValue.get((String)object2)) == null) {
            return;
        }
        try {
            field.set(object, this.readValue(field.getType(), clazz, (JsonValue)object2));
            return;
        }
        catch (RuntimeException runtimeException) {
            SerializationException serializationException = new SerializationException(runtimeException);
            serializationException.addTrace(((JsonValue)object2).trace());
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(field.getName());
            ((StringBuilder)object2).append(" (");
            ((StringBuilder)object2).append(field.getDeclaringClass().getName());
            ((StringBuilder)object2).append(")");
            serializationException.addTrace(((StringBuilder)object2).toString());
            throw serializationException;
        }
        catch (SerializationException serializationException) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(field.getName());
            ((StringBuilder)object2).append(" (");
            ((StringBuilder)object2).append(field.getDeclaringClass().getName());
            ((StringBuilder)object2).append(")");
            serializationException.addTrace(((StringBuilder)object2).toString());
            throw serializationException;
        }
        catch (ReflectionException reflectionException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Error accessing field: ");
            ((StringBuilder)object).append(field.getName());
            ((StringBuilder)object).append(" (");
            ((StringBuilder)object).append(field.getDeclaringClass().getName());
            ((StringBuilder)object).append(")");
            throw new SerializationException(((StringBuilder)object).toString(), reflectionException);
        }
    }

    public void readField(Object object, String string2, JsonValue jsonValue) {
        this.readField(object, string2, string2, null, jsonValue);
    }

    public void readField(Object object, String string2, Class clazz, JsonValue jsonValue) {
        this.readField(object, string2, string2, clazz, jsonValue);
    }

    public void readField(Object object, String string2, String string3, JsonValue jsonValue) {
        this.readField(object, string2, string3, null, jsonValue);
    }

    public void readField(Object object, String object2, String string2, Class clazz, JsonValue jsonValue) {
        Class<?> clazz2 = object.getClass();
        FieldMetadata fieldMetadata = (FieldMetadata)this.getFields(clazz2).get((String)object2);
        if (fieldMetadata != null) {
            clazz2 = fieldMetadata.field;
            object2 = clazz;
            if (clazz == null) {
                object2 = fieldMetadata.elementType;
            }
            this.readField(object, (Field)((Object)clazz2), string2, (Class)object2, jsonValue);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Field not found: ");
        ((StringBuilder)object).append((String)object2);
        ((StringBuilder)object).append(" (");
        ((StringBuilder)object).append(clazz2.getName());
        ((StringBuilder)object).append(")");
        throw new SerializationException(((StringBuilder)object).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFields(Object object, JsonValue object2) {
        Class<?> clazz = object.getClass();
        OrderedMap<String, FieldMetadata> orderedMap = this.getFields(clazz);
        object2 = ((JsonValue)object2).child;
        while (object2 != null) {
            FieldMetadata fieldMetadata = (FieldMetadata)orderedMap.get(((JsonValue)object2).name().replace(" ", "_"));
            if (fieldMetadata == null) {
                if (!(((JsonValue)object2).name.equals(this.typeName) || this.ignoreUnknownFields || this.ignoreUnknownField(clazz, ((JsonValue)object2).name))) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Field not found: ");
                    ((StringBuilder)object).append(((JsonValue)object2).name);
                    ((StringBuilder)object).append(" (");
                    ((StringBuilder)object).append(clazz.getName());
                    ((StringBuilder)object).append(")");
                    object = new SerializationException(((StringBuilder)object).toString());
                    ((SerializationException)object).addTrace(((JsonValue)object2).trace());
                    throw object;
                }
            } else if (!this.ignoreDeprecated || this.readDeprecated || !fieldMetadata.deprecated) {
                Field field = fieldMetadata.field;
                try {
                    field.set(object, this.readValue(field.getType(), fieldMetadata.elementType, (JsonValue)object2));
                }
                catch (RuntimeException runtimeException) {
                    SerializationException serializationException = new SerializationException(runtimeException);
                    serializationException.addTrace(((JsonValue)object2).trace());
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(field.getName());
                    ((StringBuilder)object2).append(" (");
                    ((StringBuilder)object2).append(clazz.getName());
                    ((StringBuilder)object2).append(")");
                    serializationException.addTrace(((StringBuilder)object2).toString());
                    throw serializationException;
                }
                catch (SerializationException serializationException) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(field.getName());
                    ((StringBuilder)object2).append(" (");
                    ((StringBuilder)object2).append(clazz.getName());
                    ((StringBuilder)object2).append(")");
                    serializationException.addTrace(((StringBuilder)object2).toString());
                    throw serializationException;
                }
                catch (ReflectionException reflectionException) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Error accessing field: ");
                    ((StringBuilder)object2).append(field.getName());
                    ((StringBuilder)object2).append(" (");
                    ((StringBuilder)object2).append(clazz.getName());
                    ((StringBuilder)object2).append(")");
                    throw new SerializationException(((StringBuilder)object2).toString(), reflectionException);
                }
            }
            object2 = ((JsonValue)object2).next;
        }
        return;
    }

    public <T> T readValue(Class<T> clazz, JsonValue jsonValue) {
        return this.readValue(clazz, null, jsonValue);
    }

    /*
     * Unable to fully structure code
     */
    public <T> T readValue(Class<T> var1_1, Class var2_4, JsonValue var3_6) {
        block70: {
            block69: {
                block76: {
                    block68: {
                        block73: {
                            block75: {
                                block74: {
                                    block72: {
                                        if (var3_6 == null) {
                                            return null;
                                        }
                                        var4_8 = var1_1;
                                        var5_9 = var3_6;
                                        if (!var3_6.isObject()) break block72;
                                        var5_9 = this.typeName;
                                        var5_9 = var5_9 == null ? null : var3_6.getString((String)var5_9, null);
                                        if (var5_9 != null) {
                                            var1_1 = var4_8 = this.getClass((String)var5_9);
                                            if (var4_8 == null) {
                                                try {
                                                    var1_1 = ClassReflection.forName((String)var5_9);
                                                }
                                                catch (ReflectionException var1_2) {
                                                    throw new SerializationException(var1_2);
                                                }
                                            }
                                        }
                                        if (var1_1 == null) {
                                            var2_4 = this.defaultSerializer;
                                            if (var2_4 != null) {
                                                return var2_4.read(this, (JsonValue)var3_6, (Class)var1_1);
                                            }
                                            return (T)var3_6;
                                        }
                                        if (this.typeName == null || !ClassReflection.isAssignableFrom(Collection.class, (Class)var1_1)) ** GOTO lbl38
                                        var5_9 = var3_6.get("items");
                                        if (var5_9 != null) {
                                            var4_8 = var1_1;
                                        } else {
                                            var2_4 = new StringBuilder();
                                            var2_4.append("Unable to convert object to collection: ");
                                            var2_4.append(var5_9);
                                            var2_4.append(" (");
                                            var2_4.append(var1_1.getName());
                                            var2_4.append(")");
                                            throw new SerializationException(var2_4.toString());
lbl38:
                                            // 1 sources

                                            var5_9 = this.classToSerializer.get((Class)var1_1);
                                            if (var5_9 != null) {
                                                return var5_9.read(this, (JsonValue)var3_6, (Class)var1_1);
                                            }
                                            if (var1_1 != String.class && var1_1 != Integer.class && var1_1 != Boolean.class && var1_1 != Float.class && var1_1 != Long.class && var1_1 != Double.class && var1_1 != Short.class && var1_1 != Byte.class && var1_1 != Character.class && !ClassReflection.isAssignableFrom(Enum.class, (Class)var1_1)) {
                                                if ((var1_1 = this.newInstance((Class)var1_1)) instanceof Serializable) {
                                                    ((Serializable)var1_1).read(this, (JsonValue)var3_6);
                                                    return (T)var1_1;
                                                }
                                                if (var1_1 instanceof ObjectMap) {
                                                    var5_9 = (ObjectMap)var1_1;
                                                    var1_1 = var3_6.child;
                                                    while (var1_1 != null) {
                                                        var5_9.put(var1_1.name, this.readValue((Class<T>)var2_4, null, (JsonValue)var1_1));
                                                        var1_1 = var1_1.next;
                                                    }
                                                    return (T)var5_9;
                                                }
                                                if (var1_1 instanceof ObjectSet) {
                                                    var5_9 = (ObjectSet)var1_1;
                                                    var1_1 = var3_6.getChild("values");
                                                    while (var1_1 != null) {
                                                        var5_9.add(this.readValue((Class<T>)var2_4, null, (JsonValue)var1_1));
                                                        var1_1 = var1_1.next;
                                                    }
                                                    return (T)var5_9;
                                                }
                                                if (var1_1 instanceof IntSet) {
                                                    var2_4 = (IntSet)var1_1;
                                                    var1_1 = var3_6.getChild("values");
                                                    while (var1_1 != null) {
                                                        var2_4.add(var1_1.asInt());
                                                        var1_1 = var1_1.next;
                                                    }
                                                    return (T)var2_4;
                                                }
                                                if (var1_1 instanceof ArrayMap) {
                                                    var5_9 = (ArrayMap)var1_1;
                                                    var1_1 = var3_6.child;
                                                    while (var1_1 != null) {
                                                        var5_9.put(var1_1.name, this.readValue((Class<T>)var2_4, null, (JsonValue)var1_1));
                                                        var1_1 = var1_1.next;
                                                    }
                                                    return (T)var5_9;
                                                }
                                                if (var1_1 instanceof Map) {
                                                    var5_9 = (Map)var1_1;
                                                    var1_1 = var3_6.child;
                                                    while (var1_1 != null) {
                                                        if (!var1_1.name.equals(this.typeName)) {
                                                            var5_9.put(var1_1.name, this.readValue((Class<T>)var2_4, null, (JsonValue)var1_1));
                                                        }
                                                        var1_1 = var1_1.next;
                                                    }
                                                    return (T)var5_9;
                                                }
                                                this.readFields(var1_1, (JsonValue)var3_6);
                                                return (T)var1_1;
                                            }
                                            return this.readValue("value", (Class<T>)var1_1, (JsonValue)var3_6);
                                        }
                                    }
                                    if (var4_8 != null) {
                                        var1_1 = this.classToSerializer.get((Class)var4_8);
                                        if (var1_1 != null) {
                                            return var1_1.read(this, (JsonValue)var5_9, (Class)var4_8);
                                        }
                                        if (ClassReflection.isAssignableFrom(Serializable.class, var4_8)) {
                                            var1_1 = this.newInstance((Class)var4_8);
                                            ((Serializable)var1_1).read(this, (JsonValue)var5_9);
                                            return (T)var1_1;
                                        }
                                    }
                                    var6_10 = var5_9.isArray();
                                    var7_11 = 0;
                                    var8_12 = 0;
                                    if (!var6_10) break block73;
                                    if (var4_8 == null) break block74;
                                    var1_1 = var4_8;
                                    if (var4_8 != Object.class) break block75;
                                }
                                var1_1 = Array.class;
                            }
                            if (ClassReflection.isAssignableFrom(Array.class, (Class)var1_1)) {
                                var1_1 = var1_1 == Array.class ? new Array<T>() : (Array)this.newInstance((Class)var1_1);
                                var3_6 = var5_9.child;
                                while (var3_6 != null) {
                                    var1_1.add(this.readValue((Class<T>)var2_4, null, (JsonValue)var3_6));
                                    var3_6 = var3_6.next;
                                }
                                return (T)var1_1;
                            }
                            if (ClassReflection.isAssignableFrom(Queue.class, (Class)var1_1)) {
                                var1_1 = var1_1 == Queue.class ? new Queue() : (Queue)this.newInstance((Class)var1_1);
                                var3_6 = var5_9.child;
                                while (var3_6 != null) {
                                    var1_1.addLast(this.readValue((Class<T>)var2_4, null, (JsonValue)var3_6));
                                    var3_6 = var3_6.next;
                                }
                                return (T)var1_1;
                            }
                            if (ClassReflection.isAssignableFrom(Collection.class, var1_1)) {
                                var1_1 = var1_1.isInterface() != false ? new ArrayList<E>() : (Collection)this.newInstance((Class)var1_1);
                                var3_6 = var5_9.child;
                                while (var3_6 != null) {
                                    var1_1.add(this.readValue((Class<T>)var2_4, null, (JsonValue)var3_6));
                                    var3_6 = var3_6.next;
                                }
                                return (T)var1_1;
                            }
                            if (var1_1.isArray()) {
                                var3_6 = var1_1.getComponentType();
                                var1_1 = var2_4;
                                if (var2_4 == null) {
                                    var1_1 = var3_6;
                                }
                                var3_6 = ArrayReflection.newInstance((Class)var3_6, var5_9.size);
                                var2_4 = var5_9.child;
                                var7_11 = var8_12;
                                while (var2_4 != null) {
                                    ArrayReflection.set(var3_6, var7_11, this.readValue((Class<T>)var1_1, null, (JsonValue)var2_4));
                                    var2_4 = var2_4.next;
                                    ++var7_11;
                                }
                                return (T)var3_6;
                            }
                            var2_4 = new StringBuilder();
                            var2_4.append("Unable to convert value to required type: ");
                            var2_4.append(var5_9);
                            var2_4.append(" (");
                            var2_4.append(var1_1.getName());
                            var2_4.append(")");
                            throw new SerializationException(var2_4.toString());
                        }
                        if (!var5_9.isNumber()) break block76;
                        if (var4_8 == null) ** GOTO lbl187
                        if (var4_8 == Float.TYPE || var4_8 == Float.class) ** GOTO lbl187
                        if (var4_8 == Integer.TYPE || var4_8 == Integer.class) ** GOTO lbl186
                        if (var4_8 == Long.TYPE || var4_8 == Long.class) ** GOTO lbl185
                        if (var4_8 == Double.TYPE || var4_8 == Double.class) ** GOTO lbl184
                        if (var4_8 != String.class) ** GOTO lbl178
                        return (T)var5_9.asString();
lbl178:
                        // 1 sources

                        if (var4_8 == Short.TYPE || var4_8 == Short.class) ** GOTO lbl183
                        if (var4_8 != Byte.TYPE && var4_8 != Byte.class) break block68;
                        return (T)Byte.valueOf(var5_9.asByte());
lbl183:
                        // 1 sources

                        return (T)Short.valueOf(var5_9.asShort());
lbl184:
                        // 1 sources

                        return (T)Double.valueOf(var5_9.asDouble());
lbl185:
                        // 1 sources

                        return (T)Long.valueOf(var5_9.asLong());
lbl186:
                        // 1 sources

                        return (T)Integer.valueOf(var5_9.asInt());
lbl187:
                        // 2 sources

                        var9_13 = var5_9.asFloat();
                        return (T)Float.valueOf(var9_13);
                    }
lbl190:
                    // 2 sources

                    while (true) {
                        var1_1 = new JsonValue(var5_9.asString());
                        break block69;
                        break;
                    }
                }
                var1_1 = var5_9;
            }
            var2_4 = var1_1;
            if (!var1_1.isBoolean()) ** GOTO lbl207
            if (var4_8 != null) {
                if (var4_8 != Boolean.TYPE && var4_8 != Boolean.class) break block70;
            }
            try {
                var6_10 = var1_1.asBoolean();
            }
            catch (NumberFormatException var2_5) {
                ** continue;
            }
            return (T)Boolean.valueOf(var6_10);
        }
lbl205:
        // 2 sources

        while (true) {
            block77: {
                block78: {
                    block71: {
                        var2_4 = new JsonValue(var1_1.asString());
lbl207:
                        // 2 sources

                        if (!var2_4.isString()) break block77;
                        var1_1 = var2_4.asString();
                        if (var4_8 == null || var4_8 == String.class) break block78;
                        if (var4_8 == Integer.TYPE || var4_8 == Integer.class) ** GOTO lbl228
                        if (var4_8 == Float.TYPE || var4_8 == Float.class) ** GOTO lbl227
                        if (var4_8 == Long.TYPE || var4_8 == Long.class) ** GOTO lbl226
                        if (var4_8 == Double.TYPE || var4_8 == Double.class) ** GOTO lbl225
                        if (var4_8 == Short.TYPE || var4_8 == Short.class) ** GOTO lbl224
                        if (var4_8 != Byte.TYPE && var4_8 != Byte.class) break block71;
                        return (T)Byte.valueOf((String)var1_1);
lbl224:
                        // 1 sources

                        return (T)Short.valueOf((String)var1_1);
lbl225:
                        // 1 sources

                        return (T)Double.valueOf((String)var1_1);
lbl226:
                        // 1 sources

                        return (T)Long.valueOf((String)var1_1);
lbl227:
                        // 1 sources

                        return (T)Float.valueOf((String)var1_1);
lbl228:
                        // 1 sources

                        var3_6 = Integer.valueOf((String)var1_1);
                        return (T)var3_6;
                    }
lbl231:
                    // 2 sources

                    while (true) {
                        if (var4_8 != Boolean.TYPE && var4_8 != Boolean.class) {
                            if (var4_8 != Character.TYPE && var4_8 != Character.class) {
                                if (ClassReflection.isAssignableFrom(Enum.class, (Class)var4_8)) {
                                    var3_6 = (Enum[])var4_8.getEnumConstants();
                                    var8_12 = ((Enum[])var3_6).length;
                                    while (var7_11 < var8_12) {
                                        var5_9 = var3_6[var7_11];
                                        if (var1_1.equals(this.convertToString((Enum)var5_9))) {
                                            return (T)var5_9;
                                        }
                                        ++var7_11;
                                    }
                                }
                                if (var4_8 == CharSequence.class) {
                                    return (T)var1_1;
                                }
                                var1_1 = new StringBuilder();
                                var1_1.append("Unable to convert value to required type: ");
                                var1_1.append(var2_4);
                                var1_1.append(" (");
                                var1_1.append(var4_8.getName());
                                var1_1.append(")");
                                throw new SerializationException(var1_1.toString());
                            }
                            return (T)Character.valueOf(var1_1.charAt(0));
                        }
                        return (T)Boolean.valueOf((String)var1_1);
                    }
                }
                return (T)var1_1;
            }
            return null;
        }
        catch (NumberFormatException var1_3) {
            ** continue;
        }
        catch (NumberFormatException var3_7) {
            ** continue;
        }
    }

    public <T> T readValue(Class<T> clazz, Class clazz2, T t, JsonValue jsonValue) {
        if (jsonValue == null) {
            return t;
        }
        return this.readValue(clazz, clazz2, jsonValue);
    }

    public <T> T readValue(String string2, Class<T> clazz, JsonValue jsonValue) {
        return this.readValue(clazz, null, jsonValue.get(string2));
    }

    public <T> T readValue(String string2, Class<T> clazz, Class clazz2, JsonValue jsonValue) {
        return this.readValue(clazz, clazz2, jsonValue.get(string2));
    }

    public <T> T readValue(String string2, Class<T> clazz, Class clazz2, T t, JsonValue jsonValue) {
        return this.readValue(clazz, clazz2, t, jsonValue.get(string2));
    }

    public <T> T readValue(String object, Class<T> clazz, T t, JsonValue jsonValue) {
        if ((object = jsonValue.get((String)object)) == null) {
            return t;
        }
        return this.readValue(clazz, null, (JsonValue)object);
    }

    public void setDefaultSerializer(Serializer serializer) {
        this.defaultSerializer = serializer;
    }

    public void setDeprecated(Class clazz, String string2, boolean bl) {
        Object object = (FieldMetadata)this.getFields(clazz).get(string2);
        if (object != null) {
            ((FieldMetadata)object).deprecated = bl;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Field not found: ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" (");
        ((StringBuilder)object).append(clazz.getName());
        ((StringBuilder)object).append(")");
        throw new SerializationException(((StringBuilder)object).toString());
    }

    public void setElementType(Class clazz, String string2, Class serializable) {
        FieldMetadata fieldMetadata = (FieldMetadata)this.getFields(clazz).get(string2);
        if (fieldMetadata != null) {
            fieldMetadata.elementType = serializable;
            return;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Field not found: ");
        ((StringBuilder)serializable).append(string2);
        ((StringBuilder)serializable).append(" (");
        ((StringBuilder)serializable).append(clazz.getName());
        ((StringBuilder)serializable).append(")");
        throw new SerializationException(((StringBuilder)serializable).toString());
    }

    public void setEnumNames(boolean bl) {
        this.enumNames = bl;
    }

    public void setIgnoreDeprecated(boolean bl) {
        this.ignoreDeprecated = bl;
    }

    public void setIgnoreUnknownFields(boolean bl) {
        this.ignoreUnknownFields = bl;
    }

    public void setOutputType(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public void setQuoteLongValues(boolean bl) {
        this.quoteLongValues = bl;
    }

    public void setReadDeprecated(boolean bl) {
        this.readDeprecated = bl;
    }

    public <T> void setSerializer(Class<T> clazz, Serializer<T> serializer) {
        this.classToSerializer.put(clazz, serializer);
    }

    public void setSortFields(boolean bl) {
        this.sortFields = bl;
    }

    public void setTypeName(String string2) {
        this.typeName = string2;
    }

    public void setUsePrototypes(boolean bl) {
        this.usePrototypes = bl;
    }

    public void setWriter(Writer writer) {
        Writer writer2 = writer;
        if (!(writer instanceof JsonWriter)) {
            writer2 = new JsonWriter(writer);
        }
        this.writer = (JsonWriter)writer2;
        this.writer.setOutputType(this.outputType);
        this.writer.setQuoteLongValues(this.quoteLongValues);
    }

    public String toJson(Object object) {
        Class<?> clazz = object == null ? null : object.getClass();
        return this.toJson(object, clazz, (Class)null);
    }

    public String toJson(Object object, Class clazz) {
        return this.toJson(object, clazz, (Class)null);
    }

    public String toJson(Object object, Class clazz, Class clazz2) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, clazz, clazz2, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, FileHandle fileHandle) {
        Class<?> clazz = object == null ? null : object.getClass();
        this.toJson(object, clazz, null, fileHandle);
    }

    public void toJson(Object object, Writer writer) {
        Class<?> clazz = object == null ? null : object.getClass();
        this.toJson(object, clazz, null, writer);
    }

    public void toJson(Object object, Class clazz, FileHandle fileHandle) {
        this.toJson(object, clazz, null, fileHandle);
    }

    public void toJson(Object object, Class clazz, Writer writer) {
        this.toJson(object, clazz, null, writer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void toJson(Object object, Class clazz, Class serializable, FileHandle fileHandle) {
        Throwable throwable2222222;
        Writer writer;
        block4: {
            Writer writer2;
            Writer writer3 = null;
            writer = null;
            writer = writer2 = fileHandle.writer(false, "UTF-8");
            writer3 = writer2;
            this.toJson(object, clazz, (Class)serializable, writer2);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (Exception exception) {}
                writer = writer3;
                {
                    writer = writer3;
                    writer = writer3;
                    serializable = new StringBuilder();
                    writer = writer3;
                    ((StringBuilder)serializable).append("Error writing file: ");
                    writer = writer3;
                    ((StringBuilder)serializable).append(fileHandle);
                    writer = writer3;
                    object = new SerializationException(((StringBuilder)serializable).toString(), exception);
                    writer = writer3;
                    throw object;
                }
            }
            StreamUtils.closeQuietly(writer2);
            return;
        }
        StreamUtils.closeQuietly(writer);
        throw throwable2222222;
    }

    public void toJson(Object object, Class clazz, Class clazz2, Writer writer) {
        this.setWriter(writer);
        try {
            this.writeValue(object, clazz, clazz2);
            return;
        }
        finally {
            StreamUtils.closeQuietly(this.writer);
            this.writer = null;
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeArrayStart(String string2) {
        try {
            this.writer.name(string2);
            this.writer.array();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeField(Object object, String string2) {
        this.writeField(object, string2, string2, null);
    }

    public void writeField(Object object, String string2, Class clazz) {
        this.writeField(object, string2, string2, clazz);
    }

    public void writeField(Object object, String string2, String string3) {
        this.writeField(object, string2, string3, null);
    }

    public void writeField(Object object, String object2, String string2, Class clazz) {
        Class<?> clazz2 = object.getClass();
        FieldMetadata fieldMetadata = (FieldMetadata)this.getFields(clazz2).get((String)object2);
        if (fieldMetadata != null) {
            Field field = fieldMetadata.field;
            object2 = clazz;
            if (clazz == null) {
                object2 = fieldMetadata.elementType;
            }
            try {
                this.writer.name(string2);
                this.writeValue(field.get(object), field.getType(), (Class)object2);
                return;
            }
            catch (Exception exception) {
                SerializationException serializationException = new SerializationException(exception);
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(field);
                ((StringBuilder)object2).append(" (");
                ((StringBuilder)object2).append(clazz2.getName());
                ((StringBuilder)object2).append(")");
                serializationException.addTrace(((StringBuilder)object2).toString());
                throw serializationException;
            }
            catch (SerializationException serializationException) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(field);
                ((StringBuilder)object2).append(" (");
                ((StringBuilder)object2).append(clazz2.getName());
                ((StringBuilder)object2).append(")");
                serializationException.addTrace(((StringBuilder)object2).toString());
                throw serializationException;
            }
            catch (ReflectionException reflectionException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Error accessing field: ");
                ((StringBuilder)object).append(field.getName());
                ((StringBuilder)object).append(" (");
                ((StringBuilder)object).append(clazz2.getName());
                ((StringBuilder)object).append(")");
                throw new SerializationException(((StringBuilder)object).toString(), reflectionException);
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Field not found: ");
        ((StringBuilder)object).append((String)object2);
        ((StringBuilder)object).append(" (");
        ((StringBuilder)object).append(clazz2.getName());
        ((StringBuilder)object).append(")");
        throw new SerializationException(((StringBuilder)object).toString());
    }

    public void writeFields(Object object) {
        Class<?> clazz = object.getClass();
        Object[] objectArray = this.getDefaultValues(clazz);
        Iterator iterator = new OrderedMap.OrderedMapValues<FieldMetadata>(this.getFields(clazz)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            Object object2;
            Field field;
            Object object3;
            block7: {
                block8: {
                    object3 = (FieldMetadata)iterator.next();
                    if (this.ignoreDeprecated && ((FieldMetadata)object3).deprecated) continue;
                    field = ((FieldMetadata)object3).field;
                    object2 = field.get(object);
                    n2 = n;
                    if (objectArray == null) break block7;
                    n2 = n + 1;
                    Object object4 = objectArray[n];
                    if (object2 == null && object4 == null) break block8;
                    if (object2 == null || object4 == null) break block7;
                    if (object2.equals(object4)) break block8;
                    if (!object2.getClass().isArray() || !object4.getClass().isArray()) break block7;
                    this.equals1[0] = object2;
                    this.equals2[0] = object4;
                    if (!Arrays.deepEquals(this.equals1, this.equals2)) break block7;
                }
                n = n2;
                continue;
            }
            try {
                this.writer.name(field.getName());
                this.writeValue(object2, field.getType(), ((FieldMetadata)object3).elementType);
                n = n2;
            }
            catch (Exception exception) {
                object3 = new SerializationException(exception);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(field);
                stringBuilder.append(" (");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(")");
                ((SerializationException)object3).addTrace(stringBuilder.toString());
                throw object3;
            }
            catch (SerializationException serializationException) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append(field);
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(clazz.getName());
                ((StringBuilder)object3).append(")");
                serializationException.addTrace(((StringBuilder)object3).toString());
                throw serializationException;
            }
            catch (ReflectionException reflectionException) {
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Error accessing field: ");
                ((StringBuilder)object3).append(field.getName());
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(clazz.getName());
                ((StringBuilder)object3).append(")");
                throw new SerializationException(((StringBuilder)object3).toString(), reflectionException);
            }
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeObjectStart(Class clazz, Class clazz2) {
        try {
            this.writer.object();
            if (clazz2 == null || clazz2 != clazz) {
                this.writeType(clazz);
            }
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeObjectStart(String string2) {
        try {
            this.writer.name(string2);
            this.writeObjectStart();
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeObjectStart(String string2, Class clazz, Class clazz2) {
        try {
            this.writer.name(string2);
            this.writeObjectStart(clazz, clazz2);
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeType(Class clazz) {
        String string2;
        if (this.typeName == null) {
            return;
        }
        String string3 = string2 = this.getTag(clazz);
        if (string2 == null) {
            string3 = clazz.getName();
        }
        try {
            this.writer.set(this.typeName, string3);
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeValue(Object object) {
        if (object == null) {
            this.writeValue(object, null, null);
        } else {
            this.writeValue(object, object.getClass(), null);
        }
    }

    public void writeValue(Object object, Class clazz) {
        this.writeValue(object, clazz, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeValue(Object var1_1, Class var2_4, Class var3_5) {
        block42: {
            block41: {
                if (var1_1 != null) break block41;
                try {
                    this.writer.value(null);
                    return;
                }
                catch (IOException var1_2) {}
                break block42;
            }
            if (var2_4 != null && var2_4.isPrimitive() || var2_4 == String.class || var2_4 == Integer.class || var2_4 == Boolean.class || var2_4 == Float.class || var2_4 == Long.class || var2_4 == Double.class || var2_4 == Short.class || var2_4 == Byte.class || var2_4 == Character.class) ** GOTO lbl199
            var4_6 = var1_1.getClass();
            var5_7 = var4_6.isPrimitive();
            if (var5_7 || var4_6 == String.class || var4_6 == Integer.class || var4_6 == Boolean.class || var4_6 == Float.class || var4_6 == Long.class || var4_6 == Double.class || var4_6 == Short.class || var4_6 == Byte.class || var4_6 == Character.class) ** GOTO lbl195
            {
                if (var1_1 instanceof Serializable) {
                    this.writeObjectStart(var4_6, var2_4);
                    ((Serializable)var1_1).write(this);
                    this.writeObjectEnd();
                    return;
                }
                var6_8 = this.classToSerializer.get(var4_6);
                if (var6_8 != null) {
                    var6_8.write(this, var1_1, var2_4);
                    return;
                }
                var5_7 = var1_1 instanceof Array;
                var7_9 = 0;
                var8_10 = 0;
                var9_11 = 0;
                if (!var5_7) ** GOTO lbl47
                if (var2_4 == null || var4_6 == var2_4 || var4_6 == Array.class) ** GOTO lbl39
            }
            {
                var3_5 = new StringBuilder();
                var3_5.append("Serialization of an Array other than the known type is not supported.\nKnown type: ");
                var3_5.append(var2_4);
                var3_5.append("\nActual type: ");
                var3_5.append(var4_6);
                var1_1 = new SerializationException(var3_5.toString());
                throw var1_1;
lbl39:
                // 1 sources

                this.writeArrayStart();
                var1_1 = (Array)var1_1;
                var7_9 = var1_1.size;
                for (var10_12 = 0; var10_12 < var7_9; ++var10_12) {
                    this.writeValue(var1_1.get(var10_12), (Class)var3_5, null);
                }
            }
            {
                this.writeArrayEnd();
                return;
lbl47:
                // 1 sources

                if (!(var1_1 instanceof Queue)) ** GOTO lbl68
                if (var2_4 == null || var4_6 == var2_4 || var4_6 == Queue.class) ** GOTO lbl60
            }
            {
                var3_5 = new StringBuilder();
                var3_5.append("Serialization of a Queue other than the known type is not supported.\nKnown type: ");
                var3_5.append(var2_4);
                var3_5.append("\nActual type: ");
                var3_5.append(var4_6);
                var1_1 = new SerializationException(var3_5.toString());
                throw var1_1;
lbl60:
                // 1 sources

                this.writeArrayStart();
                var1_1 = (Queue)var1_1;
                var8_10 = var1_1.size;
                for (var10_12 = var7_9; var10_12 < var8_10; ++var10_12) {
                    this.writeValue(var1_1.get(var10_12), (Class)var3_5, null);
                }
            }
            {
                this.writeArrayEnd();
                return;
lbl68:
                // 1 sources

                if (!(var1_1 instanceof Collection)) ** GOTO lbl88
                if (this.typeName == null || var4_6 == ArrayList.class || var2_4 != null && var2_4 == var4_6) ** GOTO lbl80
            }
            {
                this.writeObjectStart(var4_6, var2_4);
                this.writeArrayStart("items");
                var1_1 = ((Collection)var1_1).iterator();
                while (true) {
                    if (!var1_1.hasNext()) {
                        this.writeArrayEnd();
                        this.writeObjectEnd();
                        return;
                    }
                    this.writeValue(var1_1.next(), (Class)var3_5, null);
                }
lbl80:
                // 1 sources

                this.writeArrayStart();
                var1_1 = ((Collection)var1_1).iterator();
                while (true) {
                    if (!var1_1.hasNext()) {
                        this.writeArrayEnd();
                        return;
                    }
                    this.writeValue(var1_1.next(), (Class)var3_5, null);
                }
lbl88:
                // 1 sources

                if (!var4_6.isArray()) ** GOTO lbl99
                var2_4 = var3_5;
                if (var3_5 == null) {
                    var2_4 = var4_6.getComponentType();
                }
                var7_9 = ArrayReflection.getLength(var1_1);
                this.writeArrayStart();
                for (var10_12 = var8_10; var10_12 < var7_9; ++var10_12) {
                    this.writeValue(ArrayReflection.get(var1_1, var10_12), var2_4, null);
                }
            }
            {
                this.writeArrayEnd();
                return;
lbl99:
                // 1 sources

                if (var1_1 instanceof ObjectMap) {
                    var6_8 = var2_4;
                    if (var2_4 == null) {
                        var6_8 = ObjectMap.class;
                    }
                    this.writeObjectStart(var4_6, (Class)var6_8);
                    var2_4 = ((ObjectMap)var1_1).entries().iterator();
                    while (true) {
                        if (!var2_4.hasNext()) {
                            this.writeObjectEnd();
                            return;
                        }
                        var1_1 = (ObjectMap.Entry)var2_4.next();
                        this.writer.name(this.convertToString(var1_1.key));
                        this.writeValue(var1_1.value, (Class)var3_5, null);
                    }
                }
                var5_7 = var1_1 instanceof ObjectSet;
                if (var5_7) {
                    var6_8 = var2_4;
                    if (var2_4 == null) {
                        var6_8 = ObjectSet.class;
                    }
                    this.writeObjectStart(var4_6, (Class)var6_8);
                    this.writer.name("values");
                    this.writeArrayStart();
                    var1_1 = ((ObjectSet)var1_1).iterator();
                    while (true) {
                        if (!var1_1.hasNext()) {
                            this.writeArrayEnd();
                            this.writeObjectEnd();
                            return;
                        }
                        this.writeValue(var1_1.next(), (Class)var3_5, null);
                    }
                }
                if (var1_1 instanceof IntSet) {
                    var3_5 = var2_4;
                    if (var2_4 == null) {
                        var3_5 = IntSet.class;
                    }
                    this.writeObjectStart(var4_6, (Class)var3_5);
                    this.writer.name("values");
                    this.writeArrayStart();
                    var1_1 = ((IntSet)var1_1).iterator();
                    while (true) {
                        if (!var1_1.hasNext) {
                            this.writeArrayEnd();
                            this.writeObjectEnd();
                            return;
                        }
                        this.writeValue(var1_1.next(), Integer.class, null);
                    }
                }
                if (!(var1_1 instanceof ArrayMap)) ** GOTO lbl161
                var6_8 = var2_4;
                if (var2_4 == null) {
                    var6_8 = ArrayMap.class;
                }
                this.writeObjectStart(var4_6, (Class)var6_8);
                var1_1 = (ArrayMap)var1_1;
                var7_9 = var1_1.size;
                for (var10_12 = var9_11; var10_12 < var7_9; ++var10_12) {
                    this.writer.name(this.convertToString(var1_1.keys[var10_12]));
                    this.writeValue(var1_1.values[var10_12], (Class)var3_5, null);
                }
            }
            {
                this.writeObjectEnd();
                return;
lbl161:
                // 1 sources

                if (var1_1 instanceof Map) {
                    var6_8 = var2_4;
                    if (var2_4 == null) {
                        var6_8 = HashMap.class;
                    }
                    this.writeObjectStart(var4_6, (Class)var6_8);
                    var2_4 = ((Map)var1_1).entrySet().iterator();
                    while (true) {
                        if (!var2_4.hasNext()) {
                            this.writeObjectEnd();
                            return;
                        }
                        var1_1 = (Map.Entry)var2_4.next();
                        this.writer.name(this.convertToString(var1_1.getKey()));
                        this.writeValue(var1_1.getValue(), (Class)var3_5, null);
                    }
                }
                if (!ClassReflection.isAssignableFrom(Enum.class, var4_6)) ** GOTO lbl191
                if (this.typeName == null || var2_4 != null && var2_4 == var4_6) ** GOTO lbl188
                var2_4 = var4_6;
            }
            {
                if (var4_6.getEnumConstants() == null) {
                    var2_4 = var4_6.getSuperclass();
                }
                this.writeObjectStart(var2_4, null);
                this.writer.name("value");
                this.writer.value(this.convertToString((Enum)var1_1));
                this.writeObjectEnd();
                return;
lbl188:
                // 1 sources

                this.writer.value(this.convertToString((Enum)var1_1));
                return;
lbl191:
                // 1 sources

                this.writeObjectStart(var4_6, var2_4);
                this.writeFields(var1_1);
                this.writeObjectEnd();
                return;
lbl195:
                // 1 sources

                this.writeObjectStart(var4_6, null);
                this.writeValue("value", var1_1);
                this.writeObjectEnd();
                return;
lbl199:
                // 1 sources

                this.writer.value(var1_1);
                return;
            }
        }
        var1_3 = new SerializationException(var1_2);
        throw var1_3;
    }

    public void writeValue(String string2, Object object) {
        try {
            this.writer.name(string2);
            if (object == null) {
                this.writeValue(object, null, null);
            } else {
                this.writeValue(object, object.getClass(), null);
            }
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeValue(String string2, Object object, Class clazz) {
        try {
            this.writer.name(string2);
            this.writeValue(object, clazz, null);
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public void writeValue(String string2, Object object, Class clazz, Class clazz2) {
        try {
            this.writer.name(string2);
            this.writeValue(object, clazz, clazz2);
            return;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    private static class FieldMetadata {
        boolean deprecated;
        Class elementType;
        final Field field;

        public FieldMetadata(Field field) {
            this.field = field;
            int n = !ClassReflection.isAssignableFrom(ObjectMap.class, field.getType()) && !ClassReflection.isAssignableFrom(Map.class, field.getType()) ? 0 : 1;
            this.elementType = field.getElementType(n);
            this.deprecated = field.isAnnotationPresent(Deprecated.class);
        }
    }

    public static abstract class ReadOnlySerializer<T>
    implements Serializer<T> {
        @Override
        public abstract T read(Json var1, JsonValue var2, Class var3);

        @Override
        public void write(Json json, T t, Class clazz) {
        }
    }

    public static interface Serializable {
        public void read(Json var1, JsonValue var2);

        public void write(Json var1);
    }

    public static interface Serializer<T> {
        public T read(Json var1, JsonValue var2, Class var3);

        public void write(Json var1, T var2, Class var3);
    }
}

