/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class ByteArray {
    public byte[] items;
    public boolean ordered;
    public int size;

    public ByteArray() {
        this(true, 16);
    }

    public ByteArray(int n) {
        this(true, n);
    }

    public ByteArray(ByteArray byteArray) {
        this.ordered = byteArray.ordered;
        int n = this.size = byteArray.size;
        this.items = new byte[n];
        System.arraycopy(byteArray.items, 0, this.items, 0, n);
    }

    public ByteArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new byte[n];
    }

    public ByteArray(boolean bl, byte[] byArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(byArray, n, this.items, 0, n2);
    }

    public ByteArray(byte[] byArray) {
        this(true, byArray, 0, byArray.length);
    }

    public static ByteArray with(byte ... byArray) {
        return new ByteArray(byArray);
    }

    public void add(byte by) {
        byte[] byArray = this.items;
        int n = this.size;
        byte[] byArray2 = byArray;
        if (n == byArray.length) {
            byArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        byArray2[n] = by;
    }

    public void add(byte by, byte by2) {
        byte[] byArray = this.items;
        int n = this.size;
        byte[] byArray2 = byArray;
        if (n + 1 >= byArray.length) {
            byArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        byArray2[n] = by;
        byArray2[n + 1] = by2;
        this.size = n + 2;
    }

    public void add(byte by, byte by2, byte by3) {
        byte[] byArray = this.items;
        int n = this.size;
        byte[] byArray2 = byArray;
        if (n + 2 >= byArray.length) {
            byArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        byArray2[n] = by;
        byArray2[n + 1] = by2;
        byArray2[n + 2] = by3;
        this.size = n + 3;
    }

    public void add(byte by, byte by2, byte by3, byte by4) {
        byte[] byArray = this.items;
        int n = this.size;
        byte[] byArray2 = byArray;
        if (n + 3 >= byArray.length) {
            byArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        byArray2[n] = by;
        byArray2[n + 1] = by2;
        byArray2[n + 2] = by3;
        byArray2[n + 3] = by4;
        this.size = n + 4;
    }

    public void addAll(ByteArray byteArray) {
        this.addAll(byteArray.items, 0, byteArray.size);
    }

    public void addAll(ByteArray byteArray, int n, int n2) {
        if (n + n2 <= byteArray.size) {
            this.addAll(byteArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(byteArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(byte ... byArray) {
        this.addAll(byArray, 0, byArray.length);
    }

    public void addAll(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.items;
        int n3 = this.size + n2;
        byte[] byArray3 = byArray2;
        if (n3 > byArray2.length) {
            byArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(byArray, n, byArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(byte by) {
        byte[] byArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (byArray[i] != by) continue;
            return true;
        }
        return false;
    }

    public byte[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ByteArray)) {
            return false;
        }
        Object object2 = (ByteArray)object;
        if (!((ByteArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((ByteArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((ByteArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public byte first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public byte get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        byte[] byArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + byArray[i];
        }
        return n2;
    }

    public void incr(int n, byte by) {
        if (n < this.size) {
            byte[] byArray = this.items;
            byArray[n] = (byte)(byArray[n] + by);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int indexOf(byte by) {
        byte[] byArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, byte by) {
        int n2 = this.size;
        if (n <= n2) {
            byte[] byArray;
            byte[] byArray2 = byArray = this.items;
            if (n2 == byArray.length) {
                byArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(byArray2, n, byArray2, n + 1, this.size - n);
            } else {
                byArray2[this.size] = byArray2[n];
            }
            ++this.size;
            byArray2[n] = by;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public int lastIndexOf(byte by) {
        byte[] byArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public void mul(int n, byte by) {
        if (n < this.size) {
            byte[] byArray = this.items;
            byArray[n] = (byte)(byArray[n] * by);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public byte peek() {
        return this.items[this.size - 1];
    }

    public byte pop() {
        int n;
        byte[] byArray = this.items;
        this.size = n = this.size - 1;
        return byArray[n];
    }

    public byte random() {
        int n = this.size;
        if (n == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(ByteArray byteArray) {
        int n = this.size;
        byte[] byArray = this.items;
        int n2 = byteArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            byte by = byteArray.get(i);
            int n5 = 0;
            while (true) {
                n4 = n3;
                if (n5 >= n3) break;
                if (by == byArray[n5]) {
                    this.removeIndex(n5);
                    n4 = n3 - 1;
                    break;
                }
                ++n5;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public int removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            byte[] byArray = this.items;
            byte by = byArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(byArray, n + 1, byArray, n, this.size - n);
            } else {
                byArray[n] = byArray[this.size];
            }
            return by;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    byte[] byArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(byArray, n2, byArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    byte[] byArray = this.items;
                    System.arraycopy(byArray, n2, byArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean removeValue(byte by) {
        byte[] byArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    protected byte[] resize(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.items, 0, byArray, 0, Math.min(this.size, byArray.length));
        this.items = byArray;
        return byArray;
    }

    public void reverse() {
        byte[] byArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            byte by = byArray[i];
            byArray[i] = byArray[n3];
            byArray[n3] = by;
        }
    }

    public void set(int n, byte by) {
        if (n < this.size) {
            this.items[n] = by;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public byte[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public byte[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        byte[] byArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            byte by = byArray[i];
            byArray[i] = byArray[n];
            byArray[n] = by;
        }
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                byte[] byArray = this.items;
                n3 = byArray[n];
                byArray[n] = byArray[n2];
                byArray[n2] = (byte)n3;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public byte[] toArray() {
        int n = this.size;
        byte[] byArray = new byte[n];
        System.arraycopy(this.items, 0, byArray, 0, n);
        return byArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        byte[] byArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        byte[] byArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(byArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

