/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;

public class SpriteDrawable
extends BaseDrawable
implements TransformDrawable {
    private static final Color temp = new Color();
    private Sprite sprite;

    public SpriteDrawable() {
    }

    public SpriteDrawable(Sprite sprite) {
        this.setSprite(sprite);
    }

    public SpriteDrawable(SpriteDrawable spriteDrawable) {
        super(spriteDrawable);
        this.setSprite(spriteDrawable.sprite);
    }

    @Override
    public void draw(Batch batch, float f, float f2, float f3, float f4) {
        Color color2 = this.sprite.getColor();
        temp.set(color2);
        this.sprite.setColor(color2.mul(batch.getColor()));
        this.sprite.setRotation(0.0f);
        this.sprite.setScale(1.0f, 1.0f);
        this.sprite.setBounds(f, f2, f3, f4);
        this.sprite.draw(batch);
        this.sprite.setColor(temp);
    }

    @Override
    public void draw(Batch batch, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Color color2 = this.sprite.getColor();
        temp.set(color2);
        this.sprite.setColor(color2.mul(batch.getColor()));
        this.sprite.setOrigin(f3, f4);
        this.sprite.setRotation(f9);
        this.sprite.setScale(f7, f8);
        this.sprite.setBounds(f, f2, f5, f6);
        this.sprite.draw(batch);
        this.sprite.setColor(temp);
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void setSprite(Sprite sprite) {
        this.sprite = sprite;
        this.setMinWidth(sprite.getWidth());
        this.setMinHeight(sprite.getHeight());
    }

    public SpriteDrawable tint(Color object) {
        Sprite sprite = this.sprite;
        sprite = sprite instanceof TextureAtlas.AtlasSprite ? new TextureAtlas.AtlasSprite((TextureAtlas.AtlasSprite)sprite) : new Sprite(sprite);
        sprite.setColor((Color)object);
        sprite.setSize(this.getMinWidth(), this.getMinHeight());
        object = new SpriteDrawable(sprite);
        ((BaseDrawable)object).setLeftWidth(this.getLeftWidth());
        ((BaseDrawable)object).setRightWidth(this.getRightWidth());
        ((BaseDrawable)object).setTopHeight(this.getTopHeight());
        ((BaseDrawable)object).setBottomHeight(this.getBottomHeight());
        return object;
    }
}

