/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;

public abstract class Value {
    public static Value maxHeight;
    public static Value maxWidth;
    public static Value minHeight;
    public static Value minWidth;
    public static Value prefHeight;
    public static Value prefWidth;
    public static final Fixed zero;

    static {
        zero = new Fixed(0.0f);
        minWidth = new Value(){

            @Override
            public float get(Actor actor) {
                if (actor instanceof Layout) {
                    return ((Layout)((Object)actor)).getMinWidth();
                }
                float f = actor == null ? 0.0f : actor.getWidth();
                return f;
            }
        };
        minHeight = new Value(){

            @Override
            public float get(Actor actor) {
                if (actor instanceof Layout) {
                    return ((Layout)((Object)actor)).getMinHeight();
                }
                float f = actor == null ? 0.0f : actor.getHeight();
                return f;
            }
        };
        prefWidth = new Value(){

            @Override
            public float get(Actor actor) {
                if (actor instanceof Layout) {
                    return ((Layout)((Object)actor)).getPrefWidth();
                }
                float f = actor == null ? 0.0f : actor.getWidth();
                return f;
            }
        };
        prefHeight = new Value(){

            @Override
            public float get(Actor actor) {
                if (actor instanceof Layout) {
                    return ((Layout)((Object)actor)).getPrefHeight();
                }
                float f = actor == null ? 0.0f : actor.getHeight();
                return f;
            }
        };
        maxWidth = new Value(){

            @Override
            public float get(Actor actor) {
                if (actor instanceof Layout) {
                    return ((Layout)((Object)actor)).getMaxWidth();
                }
                float f = actor == null ? 0.0f : actor.getWidth();
                return f;
            }
        };
        maxHeight = new Value(){

            @Override
            public float get(Actor actor) {
                if (actor instanceof Layout) {
                    return ((Layout)((Object)actor)).getMaxHeight();
                }
                float f = actor == null ? 0.0f : actor.getHeight();
                return f;
            }
        };
    }

    public static Value percentHeight(final float f) {
        return new Value(){

            @Override
            public float get(Actor actor) {
                return actor.getHeight() * f;
            }
        };
    }

    public static Value percentHeight(final float f, final Actor actor) {
        if (actor != null) {
            return new Value(){

                @Override
                public float get(Actor actor2) {
                    return actor.getHeight() * f;
                }
            };
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    public static Value percentWidth(final float f) {
        return new Value(){

            @Override
            public float get(Actor actor) {
                return actor.getWidth() * f;
            }
        };
    }

    public static Value percentWidth(final float f, final Actor actor) {
        if (actor != null) {
            return new Value(){

                @Override
                public float get(Actor actor2) {
                    return actor.getWidth() * f;
                }
            };
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    public float get() {
        return this.get(null);
    }

    public abstract float get(Actor var1);

    public static class Fixed
    extends Value {
        static final Fixed[] cache = new Fixed[111];
        private final float value;

        public Fixed(float f) {
            this.value = f;
        }

        public static Fixed valueOf(float f) {
            int n;
            if (f == 0.0f) {
                return zero;
            }
            if (f >= -10.0f && f <= 100.0f && f == (float)(n = (int)f)) {
                Fixed fixed;
                Fixed[] fixedArray = cache;
                Fixed fixed2 = fixed = fixedArray[n += 10];
                if (fixed == null) {
                    fixedArray[n] = fixed2 = new Fixed(f);
                }
                return fixed2;
            }
            return new Fixed(f);
        }

        @Override
        public float get(Actor actor) {
            return this.value;
        }

        public String toString() {
            return Float.toString(this.value);
        }
    }
}

