/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;

public class Tree<N extends Node, V>
extends WidgetGroup {
    private static final Vector2 tmp = new Vector2();
    private ClickListener clickListener;
    private N foundNode;
    float iconSpacingLeft = 2.0f;
    float iconSpacingRight = 2.0f;
    float indentSpacing;
    private N overNode;
    float paddingLeft;
    float paddingRight;
    private float prefHeight;
    private float prefWidth;
    N rangeStart;
    final Array<N> rootNodes = new Array();
    final Selection<N> selection = new Selection<N>(){

        @Override
        protected void changed() {
            int n = this.size();
            if (n != 0) {
                if (n == 1) {
                    Tree.this.rangeStart = (Node)this.first();
                }
            } else {
                Tree.this.rangeStart = null;
            }
        }
    };
    private boolean sizeInvalid = true;
    TreeStyle style;
    float ySpacing = 4.0f;

    public Tree(Skin skin) {
        this(skin.get(TreeStyle.class));
    }

    public Tree(Skin skin, String string2) {
        this(skin.get(string2, TreeStyle.class));
    }

    public Tree(TreeStyle treeStyle) {
        this.selection.setActor(this);
        this.selection.setMultiple(true);
        this.setStyle(treeStyle);
        this.initialize();
    }

    static void collapseAll(Array<? extends Node> array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = array.get(i);
            node.setExpanded(false);
            Tree.collapseAll(node.children);
        }
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = this.plusMinusWidth();
        this.prefHeight = 0.0f;
        this.computeSize(this.rootNodes, 0.0f, this.prefWidth);
        this.prefWidth += this.paddingLeft + this.paddingRight;
    }

    private void computeSize(Array<N> array, float f, float f2) {
        float f3 = this.ySpacing;
        float f4 = this.iconSpacingLeft;
        float f5 = this.iconSpacingRight;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)array.get(i);
            float f6 = f + f2;
            Object object = node.actor;
            if (object instanceof Layout) {
                object = (Layout)object;
                f6 += object.getPrefWidth();
                node.height = object.getPrefHeight();
            } else {
                f6 += ((Actor)object).getWidth();
                node.height = ((Actor)object).getHeight();
            }
            float f7 = f6;
            if (node.icon != null) {
                f7 = f6 + (node.icon.getMinWidth() + (f4 + f5));
                node.height = Math.max(node.height, node.icon.getMinHeight());
            }
            this.prefWidth = Math.max(this.prefWidth, f7);
            this.prefHeight += node.height + f3;
            if (!node.expanded) continue;
            this.computeSize(node.children, this.indentSpacing + f, f2);
        }
    }

    private void draw(Batch batch, Array<N> array, float f, float f2) {
        float f3;
        float f4;
        float f5;
        Rectangle rectangle = this.getCullingArea();
        if (rectangle != null) {
            f5 = rectangle.y;
            f4 = rectangle.height;
            f3 = f5;
            f4 += f5;
        } else {
            f3 = 0.0f;
            f4 = 0.0f;
        }
        TreeStyle treeStyle = this.style;
        float f6 = this.getX();
        float f7 = this.getY();
        float f8 = f6 + f;
        f5 = f8 + f2 + this.iconSpacingLeft;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)array.get(i);
            Object object = node.actor;
            float f9 = ((Actor)object).getY();
            float f10 = node.height;
            if (!(rectangle == null || f9 + f10 >= f3 && f9 <= f4)) {
                if (f9 < f3) {
                    return;
                }
            } else {
                Node node2;
                if (this.selection.contains(node) && treeStyle.selection != null) {
                    this.drawSelection(node, treeStyle.selection, batch, f6, f7 + f9 - this.ySpacing / 2.0f, this.getWidth(), f10 + this.ySpacing);
                } else {
                    node2 = node;
                    if (node2 == this.overNode && treeStyle.over != null) {
                        this.drawOver(node2, treeStyle.over, batch, f6, f7 + f9 - this.ySpacing / 2.0f, this.getWidth(), f10 + this.ySpacing);
                    }
                }
                node2 = node;
                if (node2.icon != null) {
                    float f11 = Math.round((f10 - node2.icon.getMinHeight()) / 2.0f);
                    batch.setColor(((Actor)object).getColor());
                    this.drawIcon(node2, node2.icon, batch, f5, f7 + f9 + f11);
                    batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (node2.children.size > 0) {
                    object = this.getExpandIcon(node2, f5);
                    this.drawExpandIcon(node2, (Drawable)object, batch, f8, f7 + f9 + (float)Math.round((f10 - object.getMinHeight()) / 2.0f));
                }
            }
            if (!node.expanded || node.children.size <= 0) continue;
            this.draw(batch, node.children, f + this.indentSpacing, f2);
        }
    }

    static void expandAll(Array<? extends Node> array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).expandAll();
        }
    }

    static boolean findExpandedValues(Array<? extends Node> array, Array array2) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = array.get(i);
            if (!node.expanded || Tree.findExpandedValues(node.children, array2)) continue;
            array2.add(node.value);
        }
        return false;
    }

    static Node findNode(Array<? extends Node> array, Object object) {
        Node node;
        int n;
        int n2 = array.size;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            node = array.get(n);
            if (!object.equals(node.value)) continue;
            return node;
        }
        n2 = array.size;
        for (n = n3; n < n2; ++n) {
            node = Tree.findNode(array.get((int)n).children, object);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private float getNodeAt(Array<N> array, float f, float f2) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)array.get(i);
            float f3 = node.height;
            if (f >= (f2 -= node.getHeight() - f3) - f3 - this.ySpacing && f < f2) {
                this.foundNode = node;
                return -1.0f;
            }
            f2 = f3 = f2 - (f3 + this.ySpacing);
            if (!node.expanded) continue;
            f2 = f3 = this.getNodeAt(node.children, f, f3);
            if (f3 != -1.0f) continue;
            return -1.0f;
        }
        return f2;
    }

    private void initialize() {
        ClickListener clickListener;
        this.clickListener = clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent inputEvent, float f, float f2) {
                Object object = Tree.this.getNodeAt(f2);
                if (object == null) {
                    return;
                }
                if (object != Tree.this.getNodeAt(this.getTouchDownY())) {
                    return;
                }
                if (Tree.this.selection.getMultiple() && Tree.this.selection.notEmpty() && UIUtils.shift()) {
                    if (Tree.this.rangeStart == null) {
                        Tree.this.rangeStart = object;
                    }
                    inputEvent = Tree.this.rangeStart;
                    if (!UIUtils.ctrl()) {
                        Tree.this.selection.clear();
                    }
                    if ((f2 = ((Actor)((Node)((Object)inputEvent)).actor).getY()) > (f = ((Actor)((Node)object).actor).getY())) {
                        object = Tree.this;
                        ((Tree)object).selectNodes(((Tree)object).rootNodes, f, f2);
                    } else {
                        object = Tree.this;
                        ((Tree)object).selectNodes(((Tree)object).rootNodes, f2, f);
                        Tree.this.selection.items().orderedItems().reverse();
                    }
                    Tree.this.selection.fireChangeEvent();
                    Tree.this.rangeStart = inputEvent;
                    return;
                }
                if (!(((Node)object).children.size <= 0 || Tree.this.selection.getMultiple() && UIUtils.ctrl())) {
                    float f3;
                    f2 = f3 = ((Actor)((Node)object).actor).getX();
                    if (((Node)object).icon != null) {
                        f2 = f3 - (Tree.this.iconSpacingRight + ((Node)object).icon.getMinWidth());
                    }
                    if (f < f2) {
                        ((Node)object).setExpanded(((Node)object).expanded ^ true);
                        return;
                    }
                }
                if (!((Node)object).isSelectable()) {
                    return;
                }
                Tree.this.selection.choose(object);
                if (!Tree.this.selection.isEmpty()) {
                    Tree.this.rangeStart = object;
                }
            }

            @Override
            public void enter(InputEvent object, float f, float f2, int n, Actor actor) {
                super.enter((InputEvent)object, f, f2, n, actor);
                object = Tree.this;
                ((Tree)object).setOverNode(((Tree)object).getNodeAt(f2));
            }

            @Override
            public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                super.exit(inputEvent, f, f2, n, actor);
                if (actor == null || !actor.isDescendantOf(Tree.this)) {
                    Tree.this.setOverNode(null);
                }
            }

            @Override
            public boolean mouseMoved(InputEvent object, float f, float f2) {
                object = Tree.this;
                ((Tree)object).setOverNode(((Tree)object).getNodeAt(f2));
                return false;
            }
        };
        this.addListener(clickListener);
    }

    private float layout(Array<N> array, float f, float f2, float f3) {
        float f4 = this.ySpacing;
        float f5 = this.iconSpacingLeft;
        float f6 = this.iconSpacingRight;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            float f7;
            Node node = (Node)array.get(i);
            float f8 = f7 = f + f3;
            if (node.icon != null) {
                f8 = f7 + (node.icon.getMinWidth() + (f5 + f6));
            }
            if (node.actor instanceof Layout) {
                ((Layout)node.actor).pack();
            }
            ((Actor)node.actor).setPosition(f8, f2 -= node.getHeight());
            f2 = f8 = f2 - f4;
            if (!node.expanded) continue;
            f2 = this.layout(node.children, this.indentSpacing + f, f8, f3);
        }
        return f2;
    }

    private float plusMinusWidth() {
        float f;
        float f2 = f = Math.max(this.style.plus.getMinWidth(), this.style.minus.getMinWidth());
        if (this.style.plusOver != null) {
            f2 = Math.max(f, this.style.plusOver.getMinWidth());
        }
        f = f2;
        if (this.style.minusOver != null) {
            f = Math.max(f2, this.style.minusOver.getMinWidth());
        }
        return f;
    }

    public void add(N n) {
        this.insert(this.rootNodes.size, n);
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.setOverNode(null);
        this.rootNodes.clear();
        this.selection.clear();
    }

    public void collapseAll() {
        Tree.collapseAll(this.rootNodes);
    }

    @Override
    public void draw(Batch batch, float f) {
        this.drawBackground(batch, f);
        Color color2 = this.getColor();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        this.draw(batch, this.rootNodes, this.paddingLeft, this.plusMinusWidth());
        super.draw(batch, f);
    }

    protected void drawBackground(Batch batch, float f) {
        if (this.style.background != null) {
            Color color2 = this.getColor();
            batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected void drawExpandIcon(N n, Drawable drawable2, Batch batch, float f, float f2) {
        drawable2.draw(batch, f, f2, drawable2.getMinWidth(), drawable2.getMinHeight());
    }

    protected void drawIcon(N n, Drawable drawable2, Batch batch, float f, float f2) {
        drawable2.draw(batch, f, f2, drawable2.getMinWidth(), drawable2.getMinHeight());
    }

    protected void drawOver(N n, Drawable drawable2, Batch batch, float f, float f2, float f3, float f4) {
        drawable2.draw(batch, f, f2, f3, f4);
    }

    protected void drawSelection(N n, Drawable drawable2, Batch batch, float f, float f2, float f3, float f4) {
        drawable2.draw(batch, f, f2, f3, f4);
    }

    public void expandAll() {
        Tree.expandAll(this.rootNodes);
    }

    public void findExpandedValues(Array<V> array) {
        Tree.findExpandedValues(this.rootNodes, array);
    }

    public N findNode(V v) {
        if (v != null) {
            return (N)Tree.findNode(this.rootNodes, v);
        }
        throw new IllegalArgumentException("value cannot be null.");
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    protected Drawable getExpandIcon(N object, float f) {
        Drawable drawable2;
        float f2;
        boolean bl = object == this.overNode && Gdx.app.getType() == Application.ApplicationType.Desktop && (!this.selection.getMultiple() || !UIUtils.ctrl() && !UIUtils.shift()) && (f2 = this.screenToLocalCoordinates((Vector2)Tree.tmp.set((float)((float)Gdx.input.getX()), (float)0.0f)).x) >= 0.0f && f2 < f;
        if (bl && (drawable2 = ((Node)object).expanded ? this.style.minusOver : this.style.plusOver) != null) {
            return drawable2;
        }
        object = ((Node)object).expanded ? this.style.minus : this.style.plus;
        return object;
    }

    public float getIndentSpacing() {
        return this.indentSpacing;
    }

    public N getNodeAt(float f) {
        this.foundNode = null;
        this.getNodeAt(this.rootNodes, f, this.getHeight());
        return this.foundNode;
    }

    public Array<N> getNodes() {
        return this.rootNodes;
    }

    public N getOverNode() {
        return this.overNode;
    }

    public V getOverValue() {
        N n = this.overNode;
        if (n == null) {
            return null;
        }
        return ((Node)n).getValue();
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    public Array<N> getRootNodes() {
        return this.rootNodes;
    }

    public N getSelectedNode() {
        return (N)((Node)this.selection.first());
    }

    public V getSelectedValue() {
        Node node = (Node)this.selection.first();
        node = node == null ? null : node.getValue();
        return (V)node;
    }

    public Selection<N> getSelection() {
        return this.selection;
    }

    public TreeStyle getStyle() {
        return this.style;
    }

    public float getYSpacing() {
        return this.ySpacing;
    }

    public void insert(int n, N n2) {
        int n3 = this.rootNodes.indexOf(n2, true);
        int n4 = n;
        if (n3 != -1) {
            n4 = n;
            if (n3 < n) {
                n4 = n - 1;
            }
        }
        this.remove(n2);
        ((Node)n2).parent = null;
        this.rootNodes.insert(n4, n2);
        ((Node)n2).addToTree(this);
        this.invalidateHierarchy();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        this.layout(this.rootNodes, this.paddingLeft, this.getHeight() - this.ySpacing / 2.0f, this.plusMinusWidth());
    }

    public void remove(N n) {
        if (((Node)n).parent != null) {
            ((Node)((Node)n).parent).remove(n);
            return;
        }
        this.rootNodes.removeValue(n, true);
        ((Node)n).removeFromTree(this);
        this.invalidateHierarchy();
    }

    public void restoreExpandedValues(Array<V> array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            N n2 = this.findNode(array.get(i));
            if (n2 == null) continue;
            ((Node)n2).setExpanded(true);
            ((Node)n2).expandTo();
        }
    }

    void selectNodes(Array<N> array, float f, float f2) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)array.get(i);
            if (((Actor)node.actor).getY() < f) break;
            if (!node.isSelectable()) continue;
            if (((Actor)node.actor).getY() <= f2) {
                this.selection.add(node);
            }
            if (!node.expanded) continue;
            this.selectNodes(node.children, f, f2);
        }
    }

    public void setIconSpacing(float f, float f2) {
        this.iconSpacingLeft = f;
        this.iconSpacingRight = f2;
    }

    public void setIndentSpacing(float f) {
        this.indentSpacing = f;
    }

    public void setOverNode(N n) {
        this.overNode = n;
    }

    public void setPadding(float f) {
        this.paddingLeft = f;
        this.paddingRight = f;
    }

    public void setPadding(float f, float f2) {
        this.paddingLeft = f;
        this.paddingRight = f2;
    }

    public void setStyle(TreeStyle treeStyle) {
        this.style = treeStyle;
        if (this.indentSpacing == 0.0f) {
            this.indentSpacing = this.plusMinusWidth();
        }
    }

    public void setYSpacing(float f) {
        this.ySpacing = f;
    }

    public void updateRootNodes() {
        int n;
        for (n = this.rootNodes.size - 1; n >= 0; --n) {
            ((Node)this.rootNodes.get(n)).removeFromTree(this);
        }
        int n2 = this.rootNodes.size;
        for (n = 0; n < n2; ++n) {
            ((Node)this.rootNodes.get(n)).addToTree(this);
        }
    }

    public static abstract class Node<N extends Node, V, A extends Actor> {
        A actor;
        final Array<N> children = new Array(0);
        boolean expanded;
        float height;
        Drawable icon;
        N parent;
        boolean selectable = true;
        V value;

        public Node() {
        }

        public Node(A a2) {
            if (a2 != null) {
                this.actor = a2;
                return;
            }
            throw new IllegalArgumentException("actor cannot be null.");
        }

        public void add(N n) {
            this.insert(this.children.size, n);
        }

        public void addAll(Array<N> array) {
            int n = array.size;
            for (int i = 0; i < n; ++i) {
                this.insert(this.children.size, (Node)array.get(i));
            }
        }

        protected void addToTree(Tree<N, V> tree) {
            tree.addActor((Actor)this.actor);
            if (!this.expanded) {
                return;
            }
            T[] TArray = this.children.items;
            for (int i = this.children.size - 1; i >= 0; --i) {
                ((Node)TArray[i]).addToTree(tree);
            }
        }

        public void collapseAll() {
            this.setExpanded(false);
            Tree.collapseAll(this.children);
        }

        public void expandAll() {
            this.setExpanded(true);
            if (this.children.size > 0) {
                Tree.expandAll(this.children);
            }
        }

        public void expandTo() {
            N n = this.parent;
            while (n != null) {
                ((Node)n).setExpanded(true);
                n = ((Node)n).parent;
            }
        }

        public void findExpandedValues(Array<V> array) {
            if (this.expanded && !Tree.findExpandedValues(this.children, array)) {
                array.add(this.value);
            }
        }

        public N findNode(V v) {
            if (v != null) {
                if (v.equals(this.value)) {
                    return (N)this;
                }
                return (N)Tree.findNode(this.children, v);
            }
            throw new IllegalArgumentException("value cannot be null.");
        }

        public A getActor() {
            return this.actor;
        }

        public Array<N> getChildren() {
            return this.children;
        }

        public float getHeight() {
            return this.height;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public int getLevel() {
            int n;
            N n2;
            int n3 = 0;
            Node<N, V, A> node = this;
            do {
                n = n3 + 1;
                n2 = node.getParent();
                n3 = n;
                node = n2;
            } while (n2 != null);
            return n;
        }

        public N getParent() {
            return this.parent;
        }

        public Tree<N, V> getTree() {
            Group group = ((Actor)this.actor).getParent();
            if (group instanceof Tree) {
                return (Tree)group;
            }
            return null;
        }

        public V getValue() {
            return this.value;
        }

        public boolean hasChildren() {
            boolean bl = this.children.size > 0;
            return bl;
        }

        public void insert(int n, N n2) {
            ((Node)n2).parent = this;
            this.children.insert(n, n2);
            this.updateChildren();
        }

        public boolean isAscendantOf(N object) {
            if (object != null) {
                N n;
                do {
                    if (object == this) {
                        return true;
                    }
                    n = ((Node)object).parent;
                    object = n;
                } while (n != null);
                return false;
            }
            object = new IllegalArgumentException("node cannot be null.");
            throw object;
        }

        public boolean isDescendantOf(N object) {
            if (object != null) {
                N n;
                Node<N, V, A> node = this;
                do {
                    if (node == object) {
                        return true;
                    }
                    n = node.parent;
                    node = n;
                } while (n != null);
                return false;
            }
            object = new IllegalArgumentException("node cannot be null.");
            throw object;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public void remove() {
            Tree<Node<N, V, A>, V> tree = this.getTree();
            if (tree != null) {
                tree.remove(this);
            } else {
                tree = this.parent;
                if (tree != null) {
                    ((Node)((Object)tree)).remove(this);
                }
            }
        }

        public void remove(N n) {
            this.children.removeValue(n, true);
            if (!this.expanded) {
                return;
            }
            Tree<N, V> tree = this.getTree();
            if (tree != null) {
                ((Node)n).removeFromTree(tree);
            }
        }

        public void removeAll() {
            Tree<N, V> tree = this.getTree();
            if (tree != null) {
                T[] TArray = this.children.items;
                for (int i = this.children.size - 1; i >= 0; --i) {
                    ((Node)TArray[i]).removeFromTree(tree);
                }
            }
            this.children.clear();
        }

        protected void removeFromTree(Tree<N, V> tree) {
            tree.removeActor((Actor)this.actor);
            if (!this.expanded) {
                return;
            }
            T[] TArray = this.children.items;
            for (int i = this.children.size - 1; i >= 0; --i) {
                ((Node)TArray[i]).removeFromTree(tree);
            }
        }

        public void restoreExpandedValues(Array<V> array) {
            int n = array.size;
            for (int i = 0; i < n; ++i) {
                N n2 = this.findNode(array.get(i));
                if (n2 == null) continue;
                ((Node)n2).setExpanded(true);
                ((Node)n2).expandTo();
            }
        }

        public void setActor(A a2) {
            Tree<N, V> tree;
            if (this.actor != null && (tree = this.getTree()) != null) {
                ((Actor)this.actor).remove();
                tree.addActor((Actor)a2);
            }
            this.actor = a2;
        }

        public void setExpanded(boolean bl) {
            if (bl == this.expanded) {
                return;
            }
            this.expanded = bl;
            if (this.children.size == 0) {
                return;
            }
            Tree<N, V> tree = this.getTree();
            if (tree == null) {
                return;
            }
            if (bl) {
                int n = this.children.size;
                for (int i = 0; i < n; ++i) {
                    ((Node)this.children.get(i)).addToTree(tree);
                }
            } else {
                for (int i = this.children.size - 1; i >= 0; --i) {
                    ((Node)this.children.get(i)).removeFromTree(tree);
                }
            }
            tree.invalidateHierarchy();
        }

        public void setIcon(Drawable drawable2) {
            this.icon = drawable2;
        }

        public void setSelectable(boolean bl) {
            this.selectable = bl;
        }

        public void setValue(V v) {
            this.value = v;
        }

        public void updateChildren() {
            int n;
            if (!this.expanded) {
                return;
            }
            Tree<N, V> tree = this.getTree();
            if (tree == null) {
                return;
            }
            for (n = this.children.size - 1; n >= 0; --n) {
                ((Node)this.children.get(n)).removeFromTree(tree);
            }
            int n2 = this.children.size;
            for (n = 0; n < n2; ++n) {
                ((Node)this.children.get(n)).addToTree(tree);
            }
        }
    }

    public static class TreeStyle {
        public Drawable background;
        public Drawable minus;
        public Drawable minusOver;
        public Drawable over;
        public Drawable plus;
        public Drawable plusOver;
        public Drawable selection;

        public TreeStyle() {
        }

        public TreeStyle(TreeStyle treeStyle) {
            this.plus = treeStyle.plus;
            this.minus = treeStyle.minus;
            this.plusOver = treeStyle.plusOver;
            this.minusOver = treeStyle.minusOver;
            this.over = treeStyle.over;
            this.selection = treeStyle.selection;
            this.background = treeStyle.background;
        }

        public TreeStyle(Drawable drawable2, Drawable drawable3, Drawable drawable4) {
            this.plus = drawable2;
            this.minus = drawable3;
            this.selection = drawable4;
        }
    }
}

