/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class TextButton
extends Button {
    private Label label;
    private TextButtonStyle style;

    public TextButton(String string2, Skin skin) {
        this(string2, skin.get(TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(String string2, Skin skin, String string3) {
        this(string2, skin.get(string3, TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(String string2, TextButtonStyle textButtonStyle) {
        this.setStyle(textButtonStyle);
        this.style = textButtonStyle;
        this.label = new Label((CharSequence)string2, new Label.LabelStyle(textButtonStyle.font, textButtonStyle.fontColor));
        this.label.setAlignment(1);
        this.add(this.label).expand().fill();
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void draw(Batch batch, float f) {
        Color color2 = this.isDisabled() && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (color2 != null) {
            this.label.getStyle().fontColor = color2;
        }
        super.draw(batch, f);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell<Label> getLabelCell() {
        return this.getCell(this.label);
    }

    @Override
    public TextButtonStyle getStyle() {
        return this.style;
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public void setLabel(Label label) {
        this.getLabelCell().setActor(label);
        this.label = label;
    }

    @Override
    public void setStyle(Button.ButtonStyle buttonStyle) {
        if (buttonStyle != null) {
            if (buttonStyle instanceof TextButtonStyle) {
                super.setStyle(buttonStyle);
                buttonStyle = (TextButtonStyle)buttonStyle;
                this.style = buttonStyle;
                Object object = this.label;
                if (object != null) {
                    object = ((Label)object).getStyle();
                    ((Label.LabelStyle)object).font = ((TextButtonStyle)buttonStyle).font;
                    ((Label.LabelStyle)object).fontColor = ((TextButtonStyle)buttonStyle).fontColor;
                    this.label.setStyle((Label.LabelStyle)object);
                }
                return;
            }
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        throw new NullPointerException("style cannot be null");
    }

    public void setText(String string2) {
        this.label.setText(string2);
    }

    @Override
    public String toString() {
        String string2 = this.getName();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getClass().getName();
        int n = string3.lastIndexOf(46);
        string2 = string3;
        if (n != -1) {
            string2 = string3.substring(n + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        string3 = string2.indexOf(36) != -1 ? "TextButton " : "";
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append((Object)this.label.getText());
        return stringBuilder.toString();
    }

    public static class TextButtonStyle
    extends Button.ButtonStyle {
        public Color checkedFontColor;
        public Color checkedOverFontColor;
        public Color disabledFontColor;
        public Color downFontColor;
        public BitmapFont font;
        public Color fontColor;
        public Color overFontColor;

        public TextButtonStyle() {
        }

        public TextButtonStyle(TextButtonStyle object) {
            super((Button.ButtonStyle)object);
            this.font = ((TextButtonStyle)object).font;
            Color color2 = ((TextButtonStyle)object).fontColor;
            if (color2 != null) {
                this.fontColor = new Color(color2);
            }
            if ((color2 = ((TextButtonStyle)object).downFontColor) != null) {
                this.downFontColor = new Color(color2);
            }
            if ((color2 = ((TextButtonStyle)object).overFontColor) != null) {
                this.overFontColor = new Color(color2);
            }
            if ((color2 = ((TextButtonStyle)object).checkedFontColor) != null) {
                this.checkedFontColor = new Color(color2);
            }
            if ((color2 = ((TextButtonStyle)object).checkedOverFontColor) != null) {
                this.checkedOverFontColor = new Color(color2);
            }
            if ((object = ((TextButtonStyle)object).disabledFontColor) != null) {
                this.disabledFontColor = new Color((Color)object);
            }
        }

        public TextButtonStyle(Drawable drawable2, Drawable drawable3, Drawable drawable4, BitmapFont bitmapFont) {
            super(drawable2, drawable3, drawable4);
            this.font = bitmapFont;
        }
    }
}

