/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class Stack
extends WidgetGroup {
    private float maxHeight;
    private float maxWidth;
    private float minHeight;
    private float minWidth;
    private float prefHeight;
    private float prefWidth;
    private boolean sizeInvalid = true;

    public Stack() {
        this.setTransform(false);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.setTouchable(Touchable.childrenOnly);
    }

    public Stack(Actor ... actorArray) {
        this();
        int n = actorArray.length;
        for (int i = 0; i < n; ++i) {
            this.addActor(actorArray[i]);
        }
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = 0.0f;
        this.prefHeight = 0.0f;
        this.minWidth = 0.0f;
        this.minHeight = 0.0f;
        this.maxWidth = 0.0f;
        this.maxHeight = 0.0f;
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        int n = snapshotArray.size;
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            Object object = (Actor)snapshotArray.get(i);
            if (object instanceof Layout) {
                object = (Layout)object;
                this.prefWidth = Math.max(this.prefWidth, object.getPrefWidth());
                this.prefHeight = Math.max(this.prefHeight, object.getPrefHeight());
                this.minWidth = Math.max(this.minWidth, object.getMinWidth());
                this.minHeight = Math.max(this.minHeight, object.getMinHeight());
                f2 = object.getMaxWidth();
                f = object.getMaxHeight();
            } else {
                this.prefWidth = Math.max(this.prefWidth, ((Actor)object).getWidth());
                this.prefHeight = Math.max(this.prefHeight, ((Actor)object).getHeight());
                this.minWidth = Math.max(this.minWidth, ((Actor)object).getWidth());
                this.minHeight = Math.max(this.minHeight, ((Actor)object).getHeight());
                f = 0.0f;
                f2 = 0.0f;
            }
            if (f2 > 0.0f) {
                float f3 = this.maxWidth;
                if (f3 != 0.0f) {
                    f2 = Math.min(f3, f2);
                }
                this.maxWidth = f2;
            }
            if (!(f > 0.0f)) continue;
            f2 = this.maxHeight;
            if (f2 != 0.0f) {
                f = Math.min(f2, f);
            }
            this.maxHeight = f;
        }
    }

    public void add(Actor actor) {
        this.addActor(actor);
    }

    @Override
    public float getMaxHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.maxHeight;
    }

    @Override
    public float getMaxWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.maxWidth;
    }

    @Override
    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minHeight;
    }

    @Override
    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float f = this.getWidth();
        float f2 = this.getHeight();
        SnapshotArray<Actor> snapshotArray = this.getChildren();
        int n = snapshotArray.size;
        for (int i = 0; i < n; ++i) {
            Actor actor = (Actor)snapshotArray.get(i);
            actor.setBounds(0.0f, 0.0f, f, f2);
            if (!(actor instanceof Layout)) continue;
            ((Layout)((Object)actor)).validate();
        }
    }
}

