/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class Slider
extends ProgressBar {
    int draggingPointer;
    boolean mouseOver;
    private float[] snapValues;
    private float threshold;
    private Interpolation visualInterpolationInverse;

    public Slider(float f, float f2, float f3, boolean bl, Skin skin) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("default-");
        String string2 = bl ? "vertical" : "horizontal";
        stringBuilder.append(string2);
        this(f, f2, f3, bl, skin.get(stringBuilder.toString(), SliderStyle.class));
    }

    public Slider(float f, float f2, float f3, boolean bl, Skin skin, String string2) {
        this(f, f2, f3, bl, skin.get(string2, SliderStyle.class));
    }

    public Slider(float f, float f2, float f3, boolean bl, SliderStyle sliderStyle) {
        super(f, f2, f3, bl, sliderStyle);
        this.draggingPointer = -1;
        this.visualInterpolationInverse = Interpolation.linear;
        this.addListener(new InputListener(){

            @Override
            public void enter(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                if (n == -1) {
                    Slider.this.mouseOver = true;
                }
            }

            @Override
            public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                if (n == -1) {
                    Slider.this.mouseOver = false;
                }
            }

            @Override
            public boolean touchDown(InputEvent object, float f, float f2, int n, int n2) {
                if (Slider.this.disabled) {
                    return false;
                }
                if (Slider.this.draggingPointer != -1) {
                    return false;
                }
                object = Slider.this;
                ((Slider)object).draggingPointer = n;
                ((Slider)object).calculatePositionAndValue(f, f2);
                return true;
            }

            @Override
            public void touchDragged(InputEvent inputEvent, float f, float f2, int n) {
                Slider.this.calculatePositionAndValue(f, f2);
            }

            @Override
            public void touchUp(InputEvent event, float f, float f2, int n, int n2) {
                if (n != Slider.this.draggingPointer) {
                    return;
                }
                Slider.this.draggingPointer = -1;
                if (event.isTouchFocusCancel() || !Slider.this.calculatePositionAndValue(f, f2)) {
                    event = Pools.obtain(ChangeListener.ChangeEvent.class);
                    Slider.this.fire(event);
                    Pools.free(event);
                }
            }
        });
    }

    boolean calculatePositionAndValue(float f, float f2) {
        Object object = this.getStyle();
        Object object2 = this.getKnobDrawable();
        object = this.disabled && ((SliderStyle)object).disabledBackground != null ? ((SliderStyle)object).disabledBackground : ((SliderStyle)object).background;
        float f3 = this.position;
        float f4 = this.getMinValue();
        float f5 = this.getMaxValue();
        if (this.vertical) {
            float f6 = this.getHeight();
            float f7 = object.getTopHeight();
            float f8 = object.getBottomHeight();
            f = object2 == null ? 0.0f : object2.getMinHeight();
            this.position = f2 - object.getBottomHeight() - 0.5f * f;
            object2 = this.visualInterpolationInverse;
            f2 = this.position;
            f6 = f6 - f7 - f8 - f;
            f = f4 + (f5 - f4) * ((Interpolation)object2).apply(f2 / f6);
            this.position = Math.max(Math.min(0.0f, object.getBottomHeight()), this.position);
            this.position = Math.min(f6, this.position);
        } else {
            float f9 = this.getWidth();
            float f10 = object.getLeftWidth();
            float f11 = object.getRightWidth();
            f2 = object2 == null ? 0.0f : object2.getMinWidth();
            this.position = f - object.getLeftWidth() - 0.5f * f2;
            object2 = this.visualInterpolationInverse;
            f = this.position;
            f2 = f9 - f10 - f11 - f2;
            f = f4 + (f5 - f4) * ((Interpolation)object2).apply(f / f2);
            this.position = Math.max(Math.min(0.0f, object.getLeftWidth()), this.position);
            this.position = Math.min(f2, this.position);
        }
        f2 = !Gdx.input.isKeyPressed(59) && !Gdx.input.isKeyPressed(60) ? this.snap(f) : f;
        boolean bl = this.setValue(f2);
        if (f2 == f) {
            this.position = f3;
        }
        return bl;
    }

    @Override
    protected Drawable getKnobDrawable() {
        Object object = this.getStyle();
        object = this.disabled && ((SliderStyle)object).disabledKnob != null ? ((SliderStyle)object).disabledKnob : (this.isDragging() && ((SliderStyle)object).knobDown != null ? ((SliderStyle)object).knobDown : (this.mouseOver && ((SliderStyle)object).knobOver != null ? ((SliderStyle)object).knobOver : ((SliderStyle)object).knob));
        return object;
    }

    @Override
    public SliderStyle getStyle() {
        return (SliderStyle)super.getStyle();
    }

    public boolean isDragging() {
        boolean bl = this.draggingPointer != -1;
        return bl;
    }

    public void setSnapToValues(float[] fArray, float f) {
        this.snapValues = fArray;
        this.threshold = f;
    }

    public void setStyle(SliderStyle sliderStyle) {
        if (sliderStyle != null) {
            if (sliderStyle instanceof SliderStyle) {
                super.setStyle(sliderStyle);
                return;
            }
            throw new IllegalArgumentException("style must be a SliderStyle.");
        }
        throw new NullPointerException("style cannot be null");
    }

    public void setVisualInterpolationInverse(Interpolation interpolation) {
        this.visualInterpolationInverse = interpolation;
    }

    protected float snap(float f) {
        float f2;
        block3: {
            float[] fArray;
            block4: {
                fArray = this.snapValues;
                f2 = f;
                if (fArray == null) break block3;
                if (fArray.length != 0) break block4;
                f2 = f;
                break block3;
            }
            float f3 = -1.0f;
            f2 = 0.0f;
            for (int i = 0; i < (fArray = this.snapValues).length; ++i) {
                float f4;
                float f5;
                block5: {
                    float f6;
                    float f7;
                    block6: {
                        f7 = fArray[i];
                        f6 = Math.abs(f - f7);
                        f5 = f3;
                        f4 = f2;
                        if (!(f6 <= this.threshold)) break block5;
                        if (f3 == -1.0f) break block6;
                        f5 = f3;
                        f4 = f2;
                        if (!(f6 < f3)) break block5;
                    }
                    f4 = f7;
                    f5 = f6;
                }
                f3 = f5;
                f2 = f4;
            }
            if (f3 != -1.0f) break block3;
            f2 = f;
        }
        return f2;
    }

    public static class SliderStyle
    extends ProgressBar.ProgressBarStyle {
        public Drawable knobDown;
        public Drawable knobOver;

        public SliderStyle() {
        }

        public SliderStyle(SliderStyle sliderStyle) {
            super(sliderStyle);
            this.knobOver = sliderStyle.knobOver;
            this.knobDown = sliderStyle.knobDown;
        }

        public SliderStyle(Drawable drawable2, Drawable drawable3) {
            super(drawable2, drawable3);
        }
    }
}

