/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Touchpad;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.util.Iterator;

public class Skin
implements Disposable {
    private static final Class[] defaultTagClasses = new Class[]{BitmapFont.class, Color.class, TintedDrawable.class, NinePatchDrawable.class, SpriteDrawable.class, TextureRegionDrawable.class, TiledDrawable.class, Button.ButtonStyle.class, CheckBox.CheckBoxStyle.class, ImageButton.ImageButtonStyle.class, ImageTextButton.ImageTextButtonStyle.class, Label.LabelStyle.class, List.ListStyle.class, ProgressBar.ProgressBarStyle.class, ScrollPane.ScrollPaneStyle.class, SelectBox.SelectBoxStyle.class, Slider.SliderStyle.class, SplitPane.SplitPaneStyle.class, TextButton.TextButtonStyle.class, TextField.TextFieldStyle.class, TextTooltip.TextTooltipStyle.class, Touchpad.TouchpadStyle.class, Tree.TreeStyle.class, Window.WindowStyle.class};
    TextureAtlas atlas;
    private final ObjectMap<String, Class> jsonClassTags;
    ObjectMap<Class, ObjectMap<String, Object>> resources = new ObjectMap();

    public Skin() {
        this.jsonClassTags = new ObjectMap(defaultTagClasses.length);
        for (Class clazz : defaultTagClasses) {
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
    }

    public Skin(FileHandle fileHandle) {
        this.jsonClassTags = new ObjectMap(defaultTagClasses.length);
        for (Class clazz : defaultTagClasses) {
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
        Object object = new StringBuilder();
        ((StringBuilder)object).append(fileHandle.nameWithoutExtension());
        ((StringBuilder)object).append(".atlas");
        object = fileHandle.sibling(((StringBuilder)object).toString());
        if (((FileHandle)object).exists()) {
            this.atlas = new TextureAtlas((FileHandle)object);
            this.addRegions(this.atlas);
        }
        this.load(fileHandle);
    }

    public Skin(FileHandle fileHandle, TextureAtlas textureAtlas) {
        this.jsonClassTags = new ObjectMap(defaultTagClasses.length);
        for (Class clazz : defaultTagClasses) {
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
        this.atlas = textureAtlas;
        this.addRegions(textureAtlas);
        this.load(fileHandle);
    }

    public Skin(TextureAtlas textureAtlas) {
        this.jsonClassTags = new ObjectMap(defaultTagClasses.length);
        for (Class clazz : defaultTagClasses) {
            this.jsonClassTags.put(clazz.getSimpleName(), clazz);
        }
        this.atlas = textureAtlas;
        this.addRegions(textureAtlas);
    }

    private static Method findMethod(Class methodArray, String string2) {
        for (Method method : ClassReflection.getMethods((Class)methodArray)) {
            if (!method.getName().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public void add(String string2, Object object) {
        this.add(string2, object, object.getClass());
    }

    public void add(String string2, Object object, Class clazz) {
        if (string2 != null) {
            if (object != null) {
                ObjectMap<String, Object> objectMap;
                ObjectMap<String, Object> objectMap2 = objectMap = this.resources.get(clazz);
                if (objectMap == null) {
                    int n = clazz != TextureRegion.class && clazz != Drawable.class && clazz != Sprite.class ? 64 : 256;
                    objectMap2 = new ObjectMap(n);
                    this.resources.put(clazz, objectMap2);
                }
                objectMap2.put(string2, object);
                return;
            }
            throw new IllegalArgumentException("resource cannot be null.");
        }
        throw new IllegalArgumentException("name cannot be null.");
    }

    public void addRegions(TextureAtlas object) {
        Array<TextureAtlas.AtlasRegion> array = ((TextureAtlas)object).getRegions();
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            TextureAtlas.AtlasRegion atlasRegion = array.get(i);
            String string2 = atlasRegion.name;
            object = string2;
            if (atlasRegion.index != -1) {
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("_");
                ((StringBuilder)object).append(atlasRegion.index);
                object = ((StringBuilder)object).toString();
            }
            this.add((String)object, atlasRegion, TextureRegion.class);
        }
    }

    @Override
    public void dispose() {
        TextureAtlas textureAtlas = this.atlas;
        if (textureAtlas != null) {
            textureAtlas.dispose();
        }
        Iterator iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            for (Object e : ((ObjectMap)iterator.next()).values()) {
                if (!(e instanceof Disposable)) continue;
                ((Disposable)e).dispose();
            }
        }
    }

    public String find(Object object) {
        if (object != null) {
            ObjectMap<String, Object> objectMap = this.resources.get(object.getClass());
            if (objectMap == null) {
                return null;
            }
            return objectMap.findKey(object, true);
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public <T> T get(Class<T> clazz) {
        return this.get("default", clazz);
    }

    public <T> T get(String string2, Class<T> clazz) {
        if (string2 != null) {
            if (clazz != null) {
                if (clazz == Drawable.class) {
                    return (T)this.getDrawable(string2);
                }
                if (clazz == TextureRegion.class) {
                    return (T)this.getRegion(string2);
                }
                if (clazz == NinePatch.class) {
                    return (T)this.getPatch(string2);
                }
                if (clazz == Sprite.class) {
                    return (T)this.getSprite(string2);
                }
                ObjectMap<String, Object> objectMap = this.resources.get(clazz);
                if (objectMap != null) {
                    if ((objectMap = objectMap.get(string2)) != null) {
                        return (T)objectMap;
                    }
                    objectMap = new StringBuilder();
                    ((StringBuilder)((Object)objectMap)).append("No ");
                    ((StringBuilder)((Object)objectMap)).append(clazz.getName());
                    ((StringBuilder)((Object)objectMap)).append(" registered with name: ");
                    ((StringBuilder)((Object)objectMap)).append(string2);
                    throw new GdxRuntimeException(((StringBuilder)((Object)objectMap)).toString());
                }
                objectMap = new StringBuilder();
                ((StringBuilder)((Object)objectMap)).append("No ");
                ((StringBuilder)((Object)objectMap)).append(clazz.getName());
                ((StringBuilder)((Object)objectMap)).append(" registered with name: ");
                ((StringBuilder)((Object)objectMap)).append(string2);
                throw new GdxRuntimeException(((StringBuilder)((Object)objectMap)).toString());
            }
            throw new IllegalArgumentException("type cannot be null.");
        }
        throw new IllegalArgumentException("name cannot be null.");
    }

    public <T> ObjectMap<String, T> getAll(Class<T> clazz) {
        return this.resources.get(clazz);
    }

    public TextureAtlas getAtlas() {
        return this.atlas;
    }

    public Color getColor(String string2) {
        return this.get(string2, Color.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable getDrawable(String string2) {
        Object object;
        Drawable drawable2 = this.optional(string2, Drawable.class);
        if (drawable2 != null) {
            return drawable2;
        }
        Object object2 = drawable2;
        try {
            TextureRegion textureRegion;
            block16: {
                block18: {
                    TextureAtlas.AtlasRegion atlasRegion;
                    block17: {
                        textureRegion = this.getRegion(string2);
                        object = drawable2;
                        object2 = drawable2;
                        if (!(textureRegion instanceof TextureAtlas.AtlasRegion)) break block16;
                        object2 = drawable2;
                        atlasRegion = (TextureAtlas.AtlasRegion)textureRegion;
                        object2 = drawable2;
                        if (atlasRegion.splits == null) break block17;
                        object2 = drawable2;
                        object2 = drawable2;
                        object = new NinePatchDrawable(this.getPatch(string2));
                        break block16;
                    }
                    object2 = drawable2;
                    if (atlasRegion.rotate) break block18;
                    object2 = drawable2;
                    if (atlasRegion.packedWidth != atlasRegion.originalWidth) break block18;
                    object = drawable2;
                    object2 = drawable2;
                    if (atlasRegion.packedHeight == atlasRegion.originalHeight) break block16;
                }
                object2 = drawable2;
                object = new SpriteDrawable(this.getSprite(string2));
            }
            object2 = object;
            if (object == null) {
                object2 = object;
                object2 = object;
                drawable2 = new TextureRegionDrawable(textureRegion);
                object2 = drawable2;
            }
        }
        catch (GdxRuntimeException gdxRuntimeException) {}
        if (object2 == null) {
            object = this.optional(string2, NinePatch.class);
            if (object != null) {
                object = new NinePatchDrawable((NinePatch)object);
            } else {
                object = this.optional(string2, Sprite.class);
                if (object == null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("No Drawable, NinePatch, TextureRegion, Texture, or Sprite registered with name: ");
                    ((StringBuilder)object).append(string2);
                    throw new GdxRuntimeException(((StringBuilder)object).toString());
                }
                object = new SpriteDrawable((Sprite)object);
            }
        } else {
            object = object2;
        }
        if (object instanceof BaseDrawable) {
            ((BaseDrawable)object).setName(string2);
        }
        this.add(string2, object, Drawable.class);
        return object;
    }

    public BitmapFont getFont(String string2) {
        return this.get(string2, BitmapFont.class);
    }

    public ObjectMap<String, Class> getJsonClassTags() {
        return this.jsonClassTags;
    }

    protected Json getJsonLoader(FileHandle object) {
        Json json = new Json(){
            private static final String parentFieldName = "parent";

            @Override
            protected boolean ignoreUnknownField(Class clazz, String string2) {
                return string2.equals(parentFieldName);
            }

            @Override
            public void readFields(Object object, JsonValue jsonValue) {
                if (jsonValue.has(parentFieldName)) {
                    String string2 = this.readValue(parentFieldName, String.class, jsonValue);
                    Class<?> clazz = object.getClass();
                    while (true) {
                        try {
                            this.copyFields(Skin.this.get(string2, clazz), object);
                        }
                        catch (GdxRuntimeException gdxRuntimeException) {
                            clazz = clazz.getSuperclass();
                            if (clazz != Object.class) continue;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Unable to find parent resource with name: ");
                            ((StringBuilder)object).append(string2);
                            object = new SerializationException(((StringBuilder)object).toString());
                            ((SerializationException)object).addTrace(jsonValue.child.trace());
                            throw object;
                        }
                        break;
                    }
                }
                super.readFields(object, jsonValue);
            }

            @Override
            public <T> T readValue(Class<T> clazz, Class clazz2, JsonValue jsonValue) {
                if (jsonValue != null && jsonValue.isString() && !ClassReflection.isAssignableFrom(CharSequence.class, clazz)) {
                    return Skin.this.get(jsonValue.asString(), clazz);
                }
                return super.readValue(clazz, clazz2, jsonValue);
            }
        };
        json.setTypeName(null);
        json.setUsePrototypes(false);
        json.setSerializer(Skin.class, new Json.ReadOnlySerializer<Skin>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void readNamedObjects(Json object, Class clazz, JsonValue jsonValue) {
                Class clazz2 = clazz == TintedDrawable.class ? Drawable.class : clazz;
                jsonValue = jsonValue.child;
                while (true) {
                    block6: {
                        if (jsonValue == null) {
                            return;
                        }
                        Object t = ((Json)object).readValue(clazz, jsonValue);
                        if (t != null) {
                            try {
                                Skin.this.add(jsonValue.name, t, clazz2);
                                if (clazz2 == Drawable.class) break block6;
                            }
                            catch (Exception exception) {
                                object = new StringBuilder();
                                ((StringBuilder)object).append("Error reading ");
                                ((StringBuilder)object).append(ClassReflection.getSimpleName(clazz));
                                ((StringBuilder)object).append(": ");
                                ((StringBuilder)object).append(jsonValue.name);
                                throw new SerializationException(((StringBuilder)object).toString(), exception);
                            }
                            {
                                if (!ClassReflection.isAssignableFrom(Drawable.class, clazz2)) break block6;
                                Skin.this.add(jsonValue.name, t, Drawable.class);
                            }
                        }
                    }
                    jsonValue = jsonValue.next;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Skin read(Json json, JsonValue jsonValue, Class clazz) {
                jsonValue = jsonValue.child;
                while (jsonValue != null) {
                    try {
                        Class clazz2;
                        clazz = clazz2 = json.getClass(jsonValue.name());
                        if (clazz2 == null) {
                            clazz = ClassReflection.forName(jsonValue.name());
                        }
                        this.readNamedObjects(json, clazz, jsonValue);
                        jsonValue = jsonValue.next;
                    }
                    catch (ReflectionException reflectionException) {
                        throw new SerializationException(reflectionException);
                    }
                }
                return this;
            }
        });
        json.setSerializer(BitmapFont.class, new Json.ReadOnlySerializer<BitmapFont>((FileHandle)object, this){
            final /* synthetic */ Skin val$skin;
            final /* synthetic */ FileHandle val$skinFile;
            {
                this.val$skinFile = fileHandle;
                this.val$skin = skin2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public BitmapFont read(Json object, JsonValue object2, Class serializable) {
                Object object3 = ((Json)object).readValue("file", String.class, (JsonValue)object2);
                int n = ((Json)object).readValue("scaledSize", Integer.TYPE, Integer.valueOf(-1), (JsonValue)object2);
                serializable = Boolean.valueOf(false);
                Boolean bl = (Boolean)((Json)object).readValue("flip", Boolean.class, serializable, (JsonValue)object2);
                serializable = (Boolean)((Json)object).readValue("markupEnabled", Boolean.class, serializable, (JsonValue)object2);
                object2 = object = this.val$skinFile.parent().child((String)object3);
                if (!((FileHandle)object).exists()) {
                    object2 = Gdx.files.internal((String)object3);
                }
                if (!((FileHandle)object2).exists()) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Font file not found: ");
                    ((StringBuilder)object).append(object2);
                    throw new SerializationException(((StringBuilder)object).toString());
                }
                object = ((FileHandle)object2).nameWithoutExtension();
                try {
                    object3 = this.val$skin.getRegions((String)object);
                    if (object3 != null) {
                        BitmapFont.BitmapFontData bitmapFontData = new BitmapFont.BitmapFontData((FileHandle)object2, bl);
                        object = new BitmapFont(bitmapFontData, (Array<TextureRegion>)object3, true);
                    } else {
                        object3 = this.val$skin.optional((String)object, TextureRegion.class);
                        if (object3 != null) {
                            object = new BitmapFont((FileHandle)object2, (TextureRegion)object3, (boolean)bl);
                        } else {
                            FileHandle fileHandle = ((FileHandle)object2).parent();
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append((String)object);
                            ((StringBuilder)object3).append(".png");
                            object = fileHandle.child(((StringBuilder)object3).toString());
                            object = ((FileHandle)object).exists() ? new BitmapFont((FileHandle)object2, (FileHandle)object, (boolean)bl) : new BitmapFont((FileHandle)object2, bl);
                        }
                    }
                    ((BitmapFont)object).getData().markupEnabled = (Boolean)serializable;
                    if (n != -1) {
                        ((BitmapFont)object).getData().setScale((float)n / ((BitmapFont)object).getCapHeight());
                    }
                    return object;
                }
                catch (RuntimeException runtimeException) {
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("Error loading bitmap font: ");
                    ((StringBuilder)serializable).append(object2);
                    throw new SerializationException(((StringBuilder)serializable).toString(), runtimeException);
                }
            }
        });
        json.setSerializer(Color.class, new Json.ReadOnlySerializer<Color>(){

            @Override
            public Color read(Json json, JsonValue jsonValue, Class object) {
                if (jsonValue.isString()) {
                    return Skin.this.get(jsonValue.asString(), Color.class);
                }
                object = json.readValue("hex", String.class, (String)null, jsonValue);
                if (object != null) {
                    return Color.valueOf((String)object);
                }
                return new Color(json.readValue("r", Float.TYPE, Float.valueOf(0.0f), jsonValue).floatValue(), json.readValue("g", Float.TYPE, Float.valueOf(0.0f), jsonValue).floatValue(), json.readValue("b", Float.TYPE, Float.valueOf(0.0f), jsonValue).floatValue(), json.readValue("a", Float.TYPE, Float.valueOf(1.0f), jsonValue).floatValue());
            }
        });
        json.setSerializer(TintedDrawable.class, new Json.ReadOnlySerializer(){

            @Override
            public Object read(Json object, JsonValue jsonValue, Class object2) {
                object2 = ((Json)object).readValue("name", String.class, jsonValue);
                if ((object = ((Json)object).readValue("color", Color.class, jsonValue)) != null) {
                    Drawable drawable2 = Skin.this.newDrawable((String)object2, (Color)object);
                    if (drawable2 instanceof BaseDrawable) {
                        BaseDrawable baseDrawable = (BaseDrawable)drawable2;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(jsonValue.name);
                        stringBuilder.append(" (");
                        stringBuilder.append((String)object2);
                        stringBuilder.append(", ");
                        stringBuilder.append(object);
                        stringBuilder.append(")");
                        baseDrawable.setName(stringBuilder.toString());
                    }
                    return drawable2;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("TintedDrawable missing color: ");
                ((StringBuilder)object).append(jsonValue);
                throw new SerializationException(((StringBuilder)object).toString());
            }
        });
        for (ObjectMap.Entry entry : this.jsonClassTags) {
            json.addClassTag((String)entry.key, (Class)entry.value);
        }
        return json;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NinePatch getPatch(String string2) {
        NinePatch ninePatch = this.optional(string2, NinePatch.class);
        if (ninePatch != null) {
            return ninePatch;
        }
        try {
            TextureRegion textureRegion = this.getRegion(string2);
            NinePatch ninePatch2 = ninePatch;
            if (textureRegion instanceof TextureAtlas.AtlasRegion) {
                int[] nArray = ((TextureAtlas.AtlasRegion)textureRegion).splits;
                ninePatch2 = ninePatch;
                if (nArray != null) {
                    ninePatch = new NinePatch(textureRegion, nArray[0], nArray[1], nArray[2], nArray[3]);
                    nArray = ((TextureAtlas.AtlasRegion)textureRegion).pads;
                    ninePatch2 = ninePatch;
                    if (nArray != null) {
                        ninePatch.setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
                        ninePatch2 = ninePatch;
                    }
                }
            }
            ninePatch = ninePatch2;
            if (ninePatch2 == null) {
                ninePatch = new NinePatch(textureRegion);
            }
            this.add(string2, ninePatch, NinePatch.class);
            return ninePatch;
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("No NinePatch, TextureRegion, or Texture registered with name: ");
            stringBuilder.append(string2);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
    }

    public TextureRegion getRegion(String string2) {
        Object object = this.optional(string2, TextureRegion.class);
        if (object != null) {
            return object;
        }
        object = this.optional(string2, Texture.class);
        if (object != null) {
            object = new TextureRegion((Texture)object);
            this.add(string2, object, TextureRegion.class);
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No TextureRegion or Texture registered with name: ");
        ((StringBuilder)object).append(string2);
        throw new GdxRuntimeException(((StringBuilder)object).toString());
    }

    public Array<TextureRegion> getRegions(String string2) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("_");
        ((StringBuilder)object).append(0);
        TextureRegion textureRegion = this.optional(((StringBuilder)object).toString(), TextureRegion.class);
        if (textureRegion != null) {
            Array<TextureRegion> array = new Array<TextureRegion>();
            int n = 1;
            while (true) {
                object = array;
                if (textureRegion != null) {
                    array.add(textureRegion);
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("_");
                    ((StringBuilder)object).append(n);
                    textureRegion = this.optional(((StringBuilder)object).toString(), TextureRegion.class);
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sprite getSprite(String string2) {
        Sprite sprite = this.optional(string2, Sprite.class);
        if (sprite != null) {
            return sprite;
        }
        try {
            Sprite sprite2;
            TextureRegion textureRegion;
            block7: {
                TextureAtlas.AtlasRegion atlasRegion;
                block8: {
                    textureRegion = this.getRegion(string2);
                    sprite2 = sprite;
                    if (!(textureRegion instanceof TextureAtlas.AtlasRegion)) break block7;
                    atlasRegion = (TextureAtlas.AtlasRegion)textureRegion;
                    if (atlasRegion.rotate || atlasRegion.packedWidth != atlasRegion.originalWidth) break block8;
                    sprite2 = sprite;
                    if (atlasRegion.packedHeight == atlasRegion.originalHeight) break block7;
                }
                sprite2 = new TextureAtlas.AtlasSprite(atlasRegion);
            }
            sprite = sprite2;
            if (sprite2 == null) {
                sprite = new Sprite(textureRegion);
            }
            this.add(string2, sprite, Sprite.class);
            return sprite;
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("No NinePatch, TextureRegion, or Texture registered with name: ");
            stringBuilder.append(string2);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
    }

    public TiledDrawable getTiledDrawable(String string2) {
        TiledDrawable tiledDrawable = this.optional(string2, TiledDrawable.class);
        if (tiledDrawable != null) {
            return tiledDrawable;
        }
        tiledDrawable = new TiledDrawable(this.getRegion(string2));
        tiledDrawable.setName(string2);
        this.add(string2, tiledDrawable, TiledDrawable.class);
        return tiledDrawable;
    }

    public boolean has(String string2, Class object) {
        if ((object = this.resources.get((Class)object)) == null) {
            return false;
        }
        return ((ObjectMap)object).containsKey(string2);
    }

    public void load(FileHandle fileHandle) {
        try {
            this.getJsonLoader(fileHandle).fromJson(Skin.class, fileHandle);
            return;
        }
        catch (SerializationException serializationException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error reading file: ");
            stringBuilder.append(fileHandle);
            throw new SerializationException(stringBuilder.toString(), serializationException);
        }
    }

    public Drawable newDrawable(Drawable drawable2) {
        if (drawable2 instanceof TiledDrawable) {
            return new TiledDrawable((TiledDrawable)drawable2);
        }
        if (drawable2 instanceof TextureRegionDrawable) {
            return new TextureRegionDrawable((TextureRegionDrawable)drawable2);
        }
        if (drawable2 instanceof NinePatchDrawable) {
            return new NinePatchDrawable((NinePatchDrawable)drawable2);
        }
        if (drawable2 instanceof SpriteDrawable) {
            return new SpriteDrawable((SpriteDrawable)drawable2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to copy, unknown drawable type: ");
        stringBuilder.append(drawable2.getClass());
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public Drawable newDrawable(Drawable drawable2, float f, float f2, float f3, float f4) {
        return this.newDrawable(drawable2, new Color(f, f2, f3, f4));
    }

    public Drawable newDrawable(Drawable object, Color object2) {
        block9: {
            Drawable drawable2;
            block7: {
                block8: {
                    block6: {
                        if (!(object instanceof TextureRegionDrawable)) break block6;
                        drawable2 = ((TextureRegionDrawable)object).tint((Color)object2);
                        break block7;
                    }
                    if (!(object instanceof NinePatchDrawable)) break block8;
                    drawable2 = ((NinePatchDrawable)object).tint((Color)object2);
                    break block7;
                }
                if (!(object instanceof SpriteDrawable)) break block9;
                drawable2 = ((SpriteDrawable)object).tint((Color)object2);
            }
            if (drawable2 instanceof BaseDrawable) {
                BaseDrawable baseDrawable = (BaseDrawable)drawable2;
                if (object instanceof BaseDrawable) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(((BaseDrawable)object).getName());
                    stringBuilder.append(" (");
                    stringBuilder.append(object2);
                    stringBuilder.append(")");
                    baseDrawable.setName(stringBuilder.toString());
                } else {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(" (");
                    ((StringBuilder)object).append(object2);
                    ((StringBuilder)object).append(")");
                    baseDrawable.setName(((StringBuilder)object).toString());
                }
            }
            return drawable2;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Unable to copy, unknown drawable type: ");
        ((StringBuilder)object2).append(object.getClass());
        throw new GdxRuntimeException(((StringBuilder)object2).toString());
    }

    public Drawable newDrawable(String string2) {
        return this.newDrawable(this.getDrawable(string2));
    }

    public Drawable newDrawable(String string2, float f, float f2, float f3, float f4) {
        return this.newDrawable(this.getDrawable(string2), new Color(f, f2, f3, f4));
    }

    public Drawable newDrawable(String string2, Color color2) {
        return this.newDrawable(this.getDrawable(string2), color2);
    }

    public <T> T optional(String string2, Class<T> object) {
        if (string2 != null) {
            if (object != null) {
                if ((object = this.resources.get((Class)object)) == null) {
                    return null;
                }
                return (T)((ObjectMap)object).get(string2);
            }
            throw new IllegalArgumentException("type cannot be null.");
        }
        throw new IllegalArgumentException("name cannot be null.");
    }

    public void remove(String string2, Class clazz) {
        if (string2 != null) {
            this.resources.get(clazz).remove(string2);
            return;
        }
        throw new IllegalArgumentException("name cannot be null.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEnabled(Actor actor, boolean bl) {
        StringBuilder stringBuilder;
        Object object;
        Object object2 = Skin.findMethod(actor.getClass(), "getStyle");
        if (object2 == null) {
            return;
        }
        try {
            object = ((Method)object2).invoke(actor, new Object[0]);
            String string2 = this.find(object);
            if (string2 == null) {
                return;
            }
            stringBuilder = new StringBuilder();
            object2 = "";
            stringBuilder.append(string2.replace("-disabled", ""));
        }
        catch (Exception exception) {
            return;
        }
        if (!bl) {
            object2 = "-disabled";
        }
        stringBuilder.append((String)object2);
        object = this.get(stringBuilder.toString(), object.getClass());
        object2 = Skin.findMethod(actor.getClass(), "setStyle");
        if (object2 == null) {
            return;
        }
        ((Method)object2).invoke(actor, object);
    }

    public static class TintedDrawable {
        public Color color;
        public String name;
    }
}

