/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.utils.Pool;

public abstract class TemporalAction
extends Action {
    private boolean began;
    private boolean complete;
    private float duration;
    private Interpolation interpolation;
    private boolean reverse;
    private float time;

    public TemporalAction() {
    }

    public TemporalAction(float f) {
        this.duration = f;
    }

    public TemporalAction(float f, Interpolation interpolation) {
        this.duration = f;
        this.interpolation = interpolation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean act(float f) {
        boolean bl = this.complete;
        boolean bl2 = true;
        if (bl) {
            return true;
        }
        Pool pool = this.getPool();
        this.setPool(null);
        try {
            if (!this.began) {
                this.begin();
                this.began = true;
            }
            this.time += f;
            if (!(this.time >= this.duration)) {
                bl2 = false;
            }
            this.complete = bl2;
            float f2 = this.complete ? 1.0f : this.time / this.duration;
            f = f2;
            if (this.interpolation != null) {
                f = this.interpolation.apply(f2);
            }
            f2 = f;
            if (this.reverse) {
                f2 = 1.0f - f;
            }
            this.update(f2);
            if (this.complete) {
                this.end();
            }
            bl2 = this.complete;
            return bl2;
        }
        finally {
            this.setPool(pool);
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    public void finish() {
        this.time = this.duration;
    }

    public float getDuration() {
        return this.duration;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public float getTime() {
        return this.time;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void reset() {
        super.reset();
        this.reverse = false;
        this.interpolation = null;
    }

    @Override
    public void restart() {
        this.time = 0.0f;
        this.began = false;
        this.complete = false;
    }

    public void setDuration(float f) {
        this.duration = f;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public void setTime(float f) {
        this.time = f;
    }

    protected abstract void update(float var1);
}

