/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;

public class RotateToAction
extends TemporalAction {
    private float end;
    private float start;
    private boolean useShortestDirection = false;

    public RotateToAction() {
    }

    public RotateToAction(boolean bl) {
        this.useShortestDirection = bl;
    }

    @Override
    protected void begin() {
        this.start = this.target.getRotation();
    }

    public float getRotation() {
        return this.end;
    }

    public boolean isUseShortestDirection() {
        return this.useShortestDirection;
    }

    public void setRotation(float f) {
        this.end = f;
    }

    public void setUseShortestDirection(boolean bl) {
        this.useShortestDirection = bl;
    }

    @Override
    protected void update(float f) {
        if (f == 0.0f) {
            f = this.start;
        } else if (f == 1.0f) {
            f = this.end;
        } else if (this.useShortestDirection) {
            f = MathUtils.lerpAngleDeg(this.start, this.end, f);
        } else {
            float f2 = this.start;
            f = f2 + (this.end - f2) * f;
        }
        this.target.setRotation(f);
    }
}

