/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;

public class FloatAction
extends TemporalAction {
    private float end;
    private float start;
    private float value;

    public FloatAction() {
        this.start = 0.0f;
        this.end = 1.0f;
    }

    public FloatAction(float f, float f2) {
        this.start = f;
        this.end = f2;
    }

    public FloatAction(float f, float f2, float f3) {
        super(f3);
        this.start = f;
        this.end = f2;
    }

    public FloatAction(float f, float f2, float f3, Interpolation interpolation) {
        super(f3, interpolation);
        this.start = f;
        this.end = f2;
    }

    @Override
    protected void begin() {
        this.value = this.start;
    }

    public float getEnd() {
        return this.end;
    }

    public float getStart() {
        return this.start;
    }

    public float getValue() {
        return this.value;
    }

    public void setEnd(float f) {
        this.end = f;
    }

    public void setStart(float f) {
        this.start = f;
    }

    public void setValue(float f) {
        this.value = f;
    }

    @Override
    protected void update(float f) {
        if (f == 0.0f) {
            this.value = this.start;
        } else if (f == 1.0f) {
            this.value = this.end;
        } else {
            float f2 = this.start;
            this.value = f2 + (this.end - f2) * f;
        }
    }
}

