/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Vector3
implements Serializable,
Vector<Vector3> {
    public static final Vector3 X = new Vector3(1.0f, 0.0f, 0.0f);
    public static final Vector3 Y = new Vector3(0.0f, 1.0f, 0.0f);
    public static final Vector3 Z = new Vector3(0.0f, 0.0f, 1.0f);
    public static final Vector3 Zero = new Vector3(0.0f, 0.0f, 0.0f);
    private static final long serialVersionUID = 3840054589595372522L;
    private static final Matrix4 tmpMat = new Matrix4();
    public float x;
    public float y;
    public float z;

    public Vector3() {
    }

    public Vector3(float f, float f2, float f3) {
        this.set(f, f2, f3);
    }

    public Vector3(Vector2 vector2, float f) {
        this.set(vector2.x, vector2.y, f);
    }

    public Vector3(Vector3 vector3) {
        this.set(vector3);
    }

    public Vector3(float[] fArray) {
        this.set(fArray[0], fArray[1], fArray[2]);
    }

    public static float dot(float f, float f2, float f3, float f4, float f5, float f6) {
        return f * f4 + f2 * f5 + f3 * f6;
    }

    public static float dst(float f, float f2, float f3, float f4, float f5, float f6) {
        f = f4 - f;
        f2 = f5 - f2;
        f3 = f6 - f3;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float dst2(float f, float f2, float f3, float f4, float f5, float f6) {
        f = f4 - f;
        f2 = f5 - f2;
        f3 = f6 - f3;
        return f * f + f2 * f2 + f3 * f3;
    }

    public static float len(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float len2(float f, float f2, float f3) {
        return f * f + f2 * f2 + f3 * f3;
    }

    @Override
    public Vector3 add(float f) {
        return this.set(this.x + f, this.y + f, this.z + f);
    }

    public Vector3 add(float f, float f2, float f3) {
        return this.set(this.x + f, this.y + f2, this.z + f3);
    }

    @Override
    public Vector3 add(Vector3 vector3) {
        return this.add(vector3.x, vector3.y, vector3.z);
    }

    @Override
    public Vector3 clamp(float f, float f2) {
        float f3 = this.len2();
        if (f3 == 0.0f) {
            return this;
        }
        if (f3 > (f2 *= f2)) {
            return this.scl((float)Math.sqrt(f2 / f3));
        }
        if (f3 < (f *= f)) {
            return this.scl((float)Math.sqrt(f / f3));
        }
        return this;
    }

    @Override
    public Vector3 cpy() {
        return new Vector3(this);
    }

    public Vector3 crs(float f, float f2, float f3) {
        float f4 = this.y;
        float f5 = this.z;
        float f6 = this.x;
        return this.set(f4 * f3 - f5 * f2, f5 * f - f3 * f6, f6 * f2 - f4 * f);
    }

    public Vector3 crs(Vector3 vector3) {
        float f = this.y;
        float f2 = vector3.z;
        float f3 = this.z;
        float f4 = vector3.y;
        float f5 = vector3.x;
        float f6 = this.x;
        return this.set(f * f2 - f3 * f4, f3 * f5 - f2 * f6, f6 * f4 - f * f5);
    }

    public float dot(float f, float f2, float f3) {
        return this.x * f + this.y * f2 + this.z * f3;
    }

    @Override
    public float dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public float dst(float f, float f2, float f3) {
        return (float)Math.sqrt((f -= this.x) * f + (f2 -= this.y) * f2 + (f3 -= this.z) * f3);
    }

    @Override
    public float dst(Vector3 vector3) {
        float f = vector3.x - this.x;
        float f2 = vector3.y - this.y;
        float f3 = vector3.z - this.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public float dst2(float f, float f2, float f3) {
        return (f -= this.x) * f + (f2 -= this.y) * f2 + (f3 -= this.z) * f3;
    }

    @Override
    public float dst2(Vector3 vector3) {
        float f = vector3.x - this.x;
        float f2 = vector3.y - this.y;
        float f3 = vector3.z - this.z;
        return f * f + f2 * f2 + f3 * f3;
    }

    public boolean epsilonEquals(float f, float f2, float f3) {
        return this.epsilonEquals(f, f2, f3, 1.0E-6f);
    }

    public boolean epsilonEquals(float f, float f2, float f3, float f4) {
        if (Math.abs(f - this.x) > f4) {
            return false;
        }
        if (Math.abs(f2 - this.y) > f4) {
            return false;
        }
        return !(Math.abs(f3 - this.z) > f4);
    }

    public boolean epsilonEquals(Vector3 vector3) {
        return this.epsilonEquals(vector3, 1.0E-6f);
    }

    @Override
    public boolean epsilonEquals(Vector3 vector3, float f) {
        if (vector3 == null) {
            return false;
        }
        if (Math.abs(vector3.x - this.x) > f) {
            return false;
        }
        if (Math.abs(vector3.y - this.y) > f) {
            return false;
        }
        return !(Math.abs(vector3.z - this.z) > f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector3)object;
        if (NumberUtils.floatToIntBits(this.x) != NumberUtils.floatToIntBits(((Vector3)object).x)) {
            return false;
        }
        if (NumberUtils.floatToIntBits(this.y) != NumberUtils.floatToIntBits(((Vector3)object).y)) {
            return false;
        }
        return NumberUtils.floatToIntBits(this.z) == NumberUtils.floatToIntBits(((Vector3)object).z);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector3 fromString(String string2) {
        int n = string2.indexOf(44, 1);
        int n2 = n + 1;
        int n3 = string2.indexOf(44, n2);
        if (n != -1 && n3 != -1 && string2.charAt(0) == '(' && string2.charAt(string2.length() - 1) == ')') {
            try {
                return this.set(Float.parseFloat(string2.substring(1, n)), Float.parseFloat(string2.substring(n2, n3)), Float.parseFloat(string2.substring(n3 + 1, string2.length() - 1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Malformed Vector3: ");
        stringBuilder.append(string2);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    @Override
    public boolean hasOppositeDirection(Vector3 vector3) {
        boolean bl = this.dot(vector3) < 0.0f;
        return bl;
    }

    @Override
    public boolean hasSameDirection(Vector3 vector3) {
        boolean bl = this.dot(vector3) > 0.0f;
        return bl;
    }

    public int hashCode() {
        return ((NumberUtils.floatToIntBits(this.x) + 31) * 31 + NumberUtils.floatToIntBits(this.y)) * 31 + NumberUtils.floatToIntBits(this.z);
    }

    public boolean idt(Vector3 vector3) {
        boolean bl = this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
        return bl;
    }

    @Override
    public Vector3 interpolate(Vector3 vector3, float f, Interpolation interpolation) {
        return this.lerp(vector3, interpolation.apply(0.0f, 1.0f, f));
    }

    @Override
    public boolean isCollinear(Vector3 vector3) {
        boolean bl = this.isOnLine(vector3) && this.hasSameDirection(vector3);
        return bl;
    }

    @Override
    public boolean isCollinear(Vector3 vector3, float f) {
        boolean bl = this.isOnLine(vector3, f) && this.hasSameDirection(vector3);
        return bl;
    }

    @Override
    public boolean isCollinearOpposite(Vector3 vector3) {
        boolean bl = this.isOnLine(vector3) && this.hasOppositeDirection(vector3);
        return bl;
    }

    @Override
    public boolean isCollinearOpposite(Vector3 vector3, float f) {
        boolean bl = this.isOnLine(vector3, f) && this.hasOppositeDirection(vector3);
        return bl;
    }

    @Override
    public boolean isOnLine(Vector3 vector3) {
        float f = this.y;
        float f2 = vector3.z;
        float f3 = this.z;
        float f4 = vector3.y;
        float f5 = vector3.x;
        float f6 = this.x;
        boolean bl = Vector3.len2(f * f2 - f3 * f4, f3 * f5 - f2 * f6, f6 * f4 - f * f5) <= 1.0E-6f;
        return bl;
    }

    @Override
    public boolean isOnLine(Vector3 vector3, float f) {
        float f2 = this.y;
        float f3 = vector3.z;
        float f4 = this.z;
        float f5 = vector3.y;
        float f6 = vector3.x;
        float f7 = this.x;
        boolean bl = Vector3.len2(f2 * f3 - f4 * f5, f4 * f6 - f3 * f7, f7 * f5 - f2 * f6) <= f;
        return bl;
    }

    @Override
    public boolean isPerpendicular(Vector3 vector3) {
        return MathUtils.isZero(this.dot(vector3));
    }

    @Override
    public boolean isPerpendicular(Vector3 vector3, float f) {
        return MathUtils.isZero(this.dot(vector3), f);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit(1.0E-9f);
    }

    @Override
    public boolean isUnit(float f) {
        boolean bl = Math.abs(this.len2() - 1.0f) < f;
        return bl;
    }

    @Override
    public boolean isZero() {
        boolean bl = this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
        return bl;
    }

    @Override
    public boolean isZero(float f) {
        boolean bl = this.len2() < f;
        return bl;
    }

    @Override
    public float len() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    @Override
    public float len2() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        return f * f + f2 * f2 + f3 * f3;
    }

    @Override
    public Vector3 lerp(Vector3 vector3, float f) {
        float f2 = this.x;
        this.x = f2 + (vector3.x - f2) * f;
        f2 = this.y;
        this.y = f2 + (vector3.y - f2) * f;
        f2 = this.z;
        this.z = f2 + f * (vector3.z - f2);
        return this;
    }

    @Override
    public Vector3 limit(float f) {
        return this.limit2(f * f);
    }

    @Override
    public Vector3 limit2(float f) {
        float f2 = this.len2();
        if (f2 > f) {
            this.scl((float)Math.sqrt(f / f2));
        }
        return this;
    }

    public Vector3 mul(Matrix3 object) {
        object = ((Matrix3)object).val;
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[3];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[6] * f3), (float)(object[1] * f + object[4] * f2 + object[7] * f3), f * object[2] + f2 * object[5] + f3 * object[8]);
    }

    public Vector3 mul(Matrix4 object) {
        object = ((Matrix4)object).val;
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[4];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[8] * f3 + object[12]), (float)(object[1] * f + object[5] * f2 + object[9] * f3 + object[13]), f * object[2] + f2 * object[6] + f3 * object[10] + object[14]);
    }

    public Vector3 mul(Quaternion quaternion) {
        return quaternion.transform(this);
    }

    public Vector3 mul4x3(float[] fArray) {
        float f = this.x;
        float f2 = fArray[0];
        float f3 = this.y;
        float f4 = fArray[3];
        float f5 = this.z;
        return this.set(f2 * f + f4 * f3 + fArray[6] * f5 + fArray[9], fArray[1] * f + fArray[4] * f3 + fArray[7] * f5 + fArray[10], f * fArray[2] + f3 * fArray[5] + f5 * fArray[8] + fArray[11]);
    }

    @Override
    public Vector3 mulAdd(Vector3 vector3, float f) {
        this.x += vector3.x * f;
        this.y += vector3.y * f;
        this.z += vector3.z * f;
        return this;
    }

    @Override
    public Vector3 mulAdd(Vector3 vector3, Vector3 vector32) {
        this.x += vector3.x * vector32.x;
        this.y += vector3.y * vector32.y;
        this.z += vector3.z * vector32.z;
        return this;
    }

    @Override
    public Vector3 nor() {
        float f = this.len2();
        if (f != 0.0f && f != 1.0f) {
            return this.scl(1.0f / (float)Math.sqrt(f));
        }
        return this;
    }

    public Vector3 prj(Matrix4 object) {
        object = ((Matrix4)object).val;
        float f = this.x;
        Object object2 = object[3];
        float f2 = this.y;
        Object object3 = object[7];
        float f3 = this.z;
        object2 = 1.0f / (object2 * f + object3 * f2 + object[11] * f3 + object[15]);
        return this.set((float)((object[0] * f + object[4] * f2 + object[8] * f3 + object[12]) * object2), (float)((object[1] * f + object[5] * f2 + object[9] * f3 + object[13]) * object2), (f * object[2] + f2 * object[6] + f3 * object[10] + object[14]) * object2);
    }

    public Vector3 rot(Matrix4 object) {
        object = ((Matrix4)object).val;
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[4];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[8] * f3), (float)(object[1] * f + object[5] * f2 + object[9] * f3), f * object[2] + f2 * object[6] + f3 * object[10]);
    }

    public Vector3 rotate(float f, float f2, float f3, float f4) {
        return this.mul(tmpMat.setToRotation(f2, f3, f4, f));
    }

    public Vector3 rotate(Vector3 vector3, float f) {
        tmpMat.setToRotation(vector3, f);
        return this.mul(tmpMat);
    }

    public Vector3 rotateRad(float f, float f2, float f3, float f4) {
        return this.mul(tmpMat.setToRotationRad(f2, f3, f4, f));
    }

    public Vector3 rotateRad(Vector3 vector3, float f) {
        tmpMat.setToRotationRad(vector3, f);
        return this.mul(tmpMat);
    }

    @Override
    public Vector3 scl(float f) {
        return this.set(this.x * f, this.y * f, this.z * f);
    }

    public Vector3 scl(float f, float f2, float f3) {
        return this.set(this.x * f, this.y * f2, this.z * f3);
    }

    @Override
    public Vector3 scl(Vector3 vector3) {
        return this.set(this.x * vector3.x, this.y * vector3.y, this.z * vector3.z);
    }

    public Vector3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3 set(Vector2 vector2, float f) {
        return this.set(vector2.x, vector2.y, f);
    }

    @Override
    public Vector3 set(Vector3 vector3) {
        return this.set(vector3.x, vector3.y, vector3.z);
    }

    @Override
    public Vector3 set(float[] fArray) {
        return this.set(fArray[0], fArray[1], fArray[2]);
    }

    public Vector3 setFromSpherical(float f, float f2) {
        float f3 = MathUtils.cos(f2);
        f2 = MathUtils.sin(f2);
        return this.set(MathUtils.cos(f) * f2, MathUtils.sin(f) * f2, f3);
    }

    @Override
    public Vector3 setLength(float f) {
        return this.setLength2(f * f);
    }

    @Override
    public Vector3 setLength2(float f) {
        float f2 = this.len2();
        Vector3 vector3 = f2 != 0.0f && f2 != f ? this.scl((float)Math.sqrt(f / f2)) : this;
        return vector3;
    }

    @Override
    public Vector3 setToRandomDirection() {
        return this.setFromSpherical(MathUtils.random() * ((float)Math.PI * 2), (float)Math.acos(MathUtils.random() * 2.0f - 1.0f));
    }

    @Override
    public Vector3 setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        return this;
    }

    public Vector3 slerp(Vector3 vector3, float f) {
        float f2 = this.dot(vector3);
        double d = f2;
        if (!(d > 0.9995) && !(d < -0.9995)) {
            d = (float)Math.acos(d) * f;
            float f3 = (float)Math.sin(d);
            float f4 = vector3.x - this.x * f2;
            float f5 = vector3.y - this.y * f2;
            f2 = vector3.z - this.z * f2;
            float f6 = f4 * f4 + f5 * f5 + f2 * f2;
            f = 1.0f;
            if (!(f6 < 1.0E-4f)) {
                f = 1.0f / (float)Math.sqrt(f6);
            }
            f = f3 * f;
            return this.scl((float)Math.cos(d)).add(f4 * f, f5 * f, f2 * f).nor();
        }
        return this.lerp(vector3, f);
    }

    @Override
    public Vector3 sub(float f) {
        return this.set(this.x - f, this.y - f, this.z - f);
    }

    public Vector3 sub(float f, float f2, float f3) {
        return this.set(this.x - f, this.y - f2, this.z - f3);
    }

    @Override
    public Vector3 sub(Vector3 vector3) {
        return this.sub(vector3.x, vector3.y, vector3.z);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.x);
        stringBuilder.append(",");
        stringBuilder.append(this.y);
        stringBuilder.append(",");
        stringBuilder.append(this.z);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Vector3 traMul(Matrix3 object) {
        object = ((Matrix3)object).val;
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[1];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[2] * f3), (float)(object[3] * f + object[4] * f2 + object[5] * f3), f * object[6] + f2 * object[7] + f3 * object[8]);
    }

    public Vector3 traMul(Matrix4 object) {
        object = ((Matrix4)object).val;
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[1];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[2] * f3 + object[3]), (float)(object[4] * f + object[5] * f2 + object[6] * f3 + object[7]), f * object[8] + f2 * object[9] + f3 * object[10] + object[11]);
    }

    public Vector3 unrotate(Matrix4 object) {
        object = ((Matrix4)object).val;
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[1];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[2] * f3), (float)(object[4] * f + object[5] * f2 + object[6] * f3), f * object[8] + f2 * object[9] + f3 * object[10]);
    }

    public Vector3 untransform(Matrix4 object) {
        object = ((Matrix4)object).val;
        this.x -= object[12];
        this.y -= object[12];
        this.z -= object[12];
        float f = this.x;
        Object object2 = object[0];
        float f2 = this.y;
        Object object3 = object[1];
        float f3 = this.z;
        return this.set((float)(object2 * f + object3 * f2 + object[2] * f3), (float)(object[4] * f + object[5] * f2 + object[6] * f3), f * object[8] + f2 * object[9] + f3 * object[10]);
    }
}

