/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import java.util.Random;

public class RandomXS128
extends Random {
    private static final double NORM_DOUBLE = (double)1.110223E-16f;
    private static final double NORM_FLOAT = 5.960464477539063E-8;
    private long seed0;
    private long seed1;

    public RandomXS128() {
        this.setSeed(new Random().nextLong());
    }

    public RandomXS128(long l) {
        this.setSeed(l);
    }

    public RandomXS128(long l, long l2) {
        this.setState(l, l2);
    }

    private static final long murmurHash3(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        return l ^ l >>> 33;
    }

    public long getState(int n) {
        long l = n == 0 ? this.seed0 : this.seed1;
        return l;
    }

    @Override
    protected final int next(int n) {
        return (int)(this.nextLong() & (1L << n) - 1L);
    }

    @Override
    public boolean nextBoolean() {
        boolean bl = (this.nextLong() & 1L) != 0L;
        return bl;
    }

    @Override
    public void nextBytes(byte[] byArray) {
        int n = byArray.length;
        block0: while (n != 0) {
            int n2 = n < 8 ? n : 8;
            long l = this.nextLong();
            int n3 = n;
            while (true) {
                n = n3--;
                if (n2 == 0) continue block0;
                byArray[n3] = (byte)l;
                l >>= 8;
                --n2;
            }
        }
    }

    @Override
    public double nextDouble() {
        double d = this.nextLong() >>> 11;
        Double.isNaN(d);
        return d * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        double d = this.nextLong() >>> 40;
        Double.isNaN(d);
        return (float)(d * 5.960464477539063E-8);
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong() {
        long l;
        long l2 = this.seed0;
        this.seed0 = l = this.seed1;
        l2 ^= l2 << 23;
        this.seed1 = l2 = l2 >>> 17 ^ (l2 ^ l) ^ l >>> 26;
        return l2 + l;
    }

    @Override
    public long nextLong(long l) {
        if (l > 0L) {
            long l2;
            long l3;
            while ((l3 = this.nextLong() >>> 1) - (l2 = l3 % l) + (l - 1L) < 0L) {
            }
            return l2;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("n must be positive");
        throw illegalArgumentException;
    }

    @Override
    public void setSeed(long l) {
        long l2 = l;
        if (l == 0L) {
            l2 = Long.MIN_VALUE;
        }
        l = RandomXS128.murmurHash3(l2);
        this.setState(l, RandomXS128.murmurHash3(l));
    }

    public void setState(long l, long l2) {
        this.seed0 = l;
        this.seed1 = l2;
    }
}

