/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteCache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapImageLayer;
import com.badlogic.gdx.maps.tiled.TiledMapRenderer;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Disposable;

public class OrthoCachedTiledMapRenderer
implements TiledMapRenderer,
Disposable {
    protected static final int NUM_VERTICES = 20;
    private static final float tolerance = 1.0E-5f;
    protected boolean blending;
    protected final Rectangle cacheBounds;
    protected boolean cached;
    protected boolean canCacheMoreE;
    protected boolean canCacheMoreN;
    protected boolean canCacheMoreS;
    protected boolean canCacheMoreW;
    protected int count;
    protected final TiledMap map;
    protected float maxTileHeight;
    protected float maxTileWidth;
    protected float overCache = 0.5f;
    protected final SpriteCache spriteCache;
    protected float unitScale;
    protected final float[] vertices = new float[20];
    protected final Rectangle viewBounds = new Rectangle();

    public OrthoCachedTiledMapRenderer(TiledMap tiledMap) {
        this(tiledMap, 1.0f, 2000);
    }

    public OrthoCachedTiledMapRenderer(TiledMap tiledMap, float f) {
        this(tiledMap, f, 2000);
    }

    public OrthoCachedTiledMapRenderer(TiledMap tiledMap, float f, int n) {
        this.cacheBounds = new Rectangle();
        this.map = tiledMap;
        this.unitScale = f;
        this.spriteCache = new SpriteCache(n, true);
    }

    @Override
    public void dispose() {
        this.spriteCache.dispose();
    }

    public SpriteCache getSpriteCache() {
        return this.spriteCache;
    }

    public void invalidateCache() {
        this.cached = false;
    }

    public boolean isCached() {
        return this.cached;
    }

    @Override
    public void render() {
        Object object2;
        boolean bl = this.cached;
        int n = 0;
        if (!bl) {
            this.cached = true;
            this.count = 0;
            this.spriteCache.clear();
            float f = this.viewBounds.width * this.overCache;
            float f2 = this.viewBounds.height * this.overCache;
            this.cacheBounds.x = this.viewBounds.x - f;
            this.cacheBounds.y = this.viewBounds.y - f2;
            this.cacheBounds.width = this.viewBounds.width + f * 2.0f;
            this.cacheBounds.height = this.viewBounds.height + f2 * 2.0f;
            for (Object object2 : this.map.getLayers()) {
                this.spriteCache.beginCache();
                if (object2 instanceof TiledMapTileLayer) {
                    this.renderTileLayer((TiledMapTileLayer)object2);
                } else if (object2 instanceof TiledMapImageLayer) {
                    this.renderImageLayer((TiledMapImageLayer)object2);
                }
                this.spriteCache.endCache();
            }
        }
        if (this.blending) {
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
        }
        this.spriteCache.begin();
        object2 = this.map.getLayers();
        int n2 = ((MapLayers)object2).getCount();
        while (n < n2) {
            MapLayer mapLayer = ((MapLayers)object2).get(n);
            if (mapLayer.isVisible()) {
                this.spriteCache.draw(n);
                this.renderObjects(mapLayer);
            }
            ++n;
        }
        this.spriteCache.end();
        if (this.blending) {
            Gdx.gl.glDisable(3042);
        }
    }

    @Override
    public void render(int[] nArray) {
        boolean bl = this.cached;
        int n = 0;
        if (!bl) {
            this.cached = true;
            this.count = 0;
            this.spriteCache.clear();
            float f = this.viewBounds.width * this.overCache;
            float f2 = this.viewBounds.height * this.overCache;
            this.cacheBounds.x = this.viewBounds.x - f;
            this.cacheBounds.y = this.viewBounds.y - f2;
            this.cacheBounds.width = this.viewBounds.width + f * 2.0f;
            this.cacheBounds.height = this.viewBounds.height + f2 * 2.0f;
            for (MapLayer mapLayer : this.map.getLayers()) {
                this.spriteCache.beginCache();
                if (mapLayer instanceof TiledMapTileLayer) {
                    this.renderTileLayer((TiledMapTileLayer)mapLayer);
                } else if (mapLayer instanceof TiledMapImageLayer) {
                    this.renderImageLayer((TiledMapImageLayer)mapLayer);
                }
                this.spriteCache.endCache();
            }
        }
        if (this.blending) {
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
        }
        this.spriteCache.begin();
        MapLayers mapLayers = this.map.getLayers();
        int n2 = nArray.length;
        while (n < n2) {
            MapLayer mapLayer;
            int n3 = nArray[n];
            mapLayer = mapLayers.get(n3);
            if (mapLayer.isVisible()) {
                this.spriteCache.draw(n3);
                this.renderObjects(mapLayer);
            }
            ++n;
        }
        this.spriteCache.end();
        if (this.blending) {
            Gdx.gl.glDisable(3042);
        }
    }

    @Override
    public void renderImageLayer(TiledMapImageLayer tiledMapImageLayer) {
        float f = Color.toFloatBits(1.0f, 1.0f, 1.0f, tiledMapImageLayer.getOpacity());
        float[] fArray = this.vertices;
        TextureRegion textureRegion = tiledMapImageLayer.getTextureRegion();
        if (textureRegion == null) {
            return;
        }
        float f2 = tiledMapImageLayer.getX();
        float f3 = tiledMapImageLayer.getY();
        float f4 = this.unitScale;
        float f5 = f3 * f4;
        float f6 = (float)textureRegion.getRegionWidth() * this.unitScale + (f2 *= f4);
        float f7 = (float)textureRegion.getRegionHeight() * this.unitScale + f5;
        float f8 = textureRegion.getU();
        float f9 = textureRegion.getV2();
        f4 = textureRegion.getU2();
        f3 = textureRegion.getV();
        fArray[0] = f2;
        fArray[1] = f5;
        fArray[2] = f;
        fArray[3] = f8;
        fArray[4] = f9;
        fArray[5] = f2;
        fArray[6] = f7;
        fArray[7] = f;
        fArray[8] = f8;
        fArray[9] = f3;
        fArray[10] = f6;
        fArray[11] = f7;
        fArray[12] = f;
        fArray[13] = f4;
        fArray[14] = f3;
        fArray[15] = f6;
        fArray[16] = f5;
        fArray[17] = f;
        fArray[18] = f4;
        fArray[19] = f9;
        this.spriteCache.add(textureRegion.getTexture(), fArray, 0, 20);
    }

    @Override
    public void renderObject(MapObject mapObject) {
    }

    @Override
    public void renderObjects(MapLayer object) {
        object = ((MapLayer)object).getObjects().iterator();
        while (object.hasNext()) {
            this.renderObject((MapObject)object.next());
        }
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        float f = Color.toFloatBits(1.0f, 1.0f, 1.0f, tiledMapTileLayer.getOpacity());
        int n = tiledMapTileLayer.getWidth();
        int n2 = tiledMapTileLayer.getHeight();
        float f2 = tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f3 = tiledMapTileLayer.getTileHeight() * this.unitScale;
        float f4 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale;
        float f5 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale;
        int n3 = Math.max(0, (int)((this.cacheBounds.x - f4) / f2));
        int n4 = Math.min(n, (int)((this.cacheBounds.x + this.cacheBounds.width + f2 - f4) / f2));
        int n5 = Math.max(0, (int)((this.cacheBounds.y - f5) / f3));
        int n6 = Math.min(n2, (int)((this.cacheBounds.y + this.cacheBounds.height + f3 - f5) / f3));
        boolean bl = n6 < n2;
        this.canCacheMoreN = bl;
        bl = n4 < n;
        this.canCacheMoreE = bl;
        bl = n3 > 0;
        this.canCacheMoreW = bl;
        bl = n5 > 0;
        this.canCacheMoreS = bl;
        float[] fArray = this.vertices;
        while (n6 >= n5) {
            for (n = n3; n < n4; ++n) {
                TiledMapTile tiledMapTile;
                Object object = tiledMapTileLayer.getCell(n, n6);
                if (object == null || (tiledMapTile = ((TiledMapTileLayer.Cell)object).getTile()) == null) continue;
                ++this.count;
                bl = ((TiledMapTileLayer.Cell)object).getFlipHorizontally();
                boolean bl2 = ((TiledMapTileLayer.Cell)object).getFlipVertically();
                n2 = ((TiledMapTileLayer.Cell)object).getRotation();
                object = tiledMapTile.getTextureRegion();
                Texture texture = ((TextureRegion)object).getTexture();
                float f6 = (float)n * f2 + tiledMapTile.getOffsetX() * this.unitScale + f4;
                float f7 = (float)n6 * f3 + tiledMapTile.getOffsetY() * this.unitScale + f5;
                float f8 = (float)((TextureRegion)object).getRegionWidth() * this.unitScale + f6;
                float f9 = (float)((TextureRegion)object).getRegionHeight() * this.unitScale + f7;
                float f10 = 0.5f / (float)texture.getWidth();
                float f11 = 0.5f / (float)texture.getHeight();
                float f12 = ((TextureRegion)object).getU() + f10;
                float f13 = ((TextureRegion)object).getV2() - f11;
                f10 = ((TextureRegion)object).getU2() - f10;
                f11 = ((TextureRegion)object).getV() + f11;
                fArray[0] = f6;
                fArray[1] = f7;
                fArray[2] = f;
                fArray[3] = f12;
                fArray[4] = f13;
                fArray[5] = f6;
                fArray[6] = f9;
                fArray[7] = f;
                fArray[8] = f12;
                fArray[9] = f11;
                fArray[10] = f8;
                fArray[11] = f9;
                fArray[12] = f;
                fArray[13] = f10;
                fArray[14] = f11;
                fArray[15] = f8;
                fArray[16] = f7;
                fArray[17] = f;
                fArray[18] = f10;
                fArray[19] = f13;
                if (bl) {
                    f12 = fArray[3];
                    fArray[3] = fArray[13];
                    fArray[13] = f12;
                    f12 = fArray[8];
                    fArray[8] = fArray[18];
                    fArray[18] = f12;
                }
                if (bl2) {
                    f12 = fArray[4];
                    fArray[4] = fArray[14];
                    fArray[14] = f12;
                    f12 = fArray[9];
                    fArray[9] = fArray[19];
                    fArray[19] = f12;
                }
                if (n2 != 0) {
                    if (n2 != 1) {
                        if (n2 != 2) {
                            if (n2 == 3) {
                                f12 = fArray[4];
                                fArray[4] = fArray[19];
                                fArray[19] = fArray[14];
                                fArray[14] = fArray[9];
                                fArray[9] = f12;
                                f12 = fArray[3];
                                fArray[3] = fArray[18];
                                fArray[18] = fArray[13];
                                fArray[13] = fArray[8];
                                fArray[8] = f12;
                            }
                        } else {
                            f12 = fArray[3];
                            fArray[3] = fArray[13];
                            fArray[13] = f12;
                            f12 = fArray[8];
                            fArray[8] = fArray[18];
                            fArray[18] = f12;
                            f12 = fArray[4];
                            fArray[4] = fArray[14];
                            fArray[14] = f12;
                            f12 = fArray[9];
                            fArray[9] = fArray[19];
                            fArray[19] = f12;
                        }
                    } else {
                        f12 = fArray[4];
                        fArray[4] = fArray[9];
                        fArray[9] = fArray[14];
                        fArray[14] = fArray[19];
                        fArray[19] = f12;
                        f12 = fArray[3];
                        fArray[3] = fArray[8];
                        fArray[8] = fArray[13];
                        fArray[13] = fArray[18];
                        fArray[18] = f12;
                    }
                }
                this.spriteCache.add(texture, fArray, 0, 20);
            }
            --n6;
        }
    }

    public void setBlending(boolean bl) {
        this.blending = bl;
    }

    public void setMaxTileSize(float f, float f2) {
        this.maxTileWidth = f;
        this.maxTileHeight = f2;
    }

    public void setOverCache(float f) {
        this.overCache = f;
    }

    @Override
    public void setView(OrthographicCamera orthographicCamera) {
        this.spriteCache.setProjectionMatrix(orthographicCamera.combined);
        float f = orthographicCamera.viewportWidth * orthographicCamera.zoom + this.maxTileWidth * 2.0f * this.unitScale;
        float f2 = orthographicCamera.viewportHeight * orthographicCamera.zoom + this.maxTileHeight * 2.0f * this.unitScale;
        this.viewBounds.set(orthographicCamera.position.x - f / 2.0f, orthographicCamera.position.y - f2 / 2.0f, f, f2);
        if (this.canCacheMoreW && this.viewBounds.x < this.cacheBounds.x - 1.0E-5f || this.canCacheMoreS && this.viewBounds.y < this.cacheBounds.y - 1.0E-5f || this.canCacheMoreE && this.viewBounds.x + this.viewBounds.width > this.cacheBounds.x + this.cacheBounds.width + 1.0E-5f || this.canCacheMoreN && this.viewBounds.y + this.viewBounds.height > this.cacheBounds.y + this.cacheBounds.height + 1.0E-5f) {
            this.cached = false;
        }
    }

    @Override
    public void setView(Matrix4 matrix4, float f, float f2, float f3, float f4) {
        this.spriteCache.setProjectionMatrix(matrix4);
        float f5 = this.maxTileWidth;
        float f6 = this.unitScale;
        float f7 = this.maxTileHeight;
        this.viewBounds.set(f - f5 * f6, f2 - f7 * f6, f3 + f5 * 2.0f * f6, f4 + f7 * 2.0f * f6);
        if (this.canCacheMoreW && this.viewBounds.x < this.cacheBounds.x - 1.0E-5f || this.canCacheMoreS && this.viewBounds.y < this.cacheBounds.y - 1.0E-5f || this.canCacheMoreE && this.viewBounds.x + this.viewBounds.width > this.cacheBounds.x + this.cacheBounds.width + 1.0E-5f || this.canCacheMoreN && this.viewBounds.y + this.viewBounds.height > this.cacheBounds.y + this.cacheBounds.height + 1.0E-5f) {
            this.cached = false;
        }
    }
}

