/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.util.Iterator;

public class TmxMapLoader
extends BaseTmxMapLoader<Parameters> {
    public TmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    private Array<FileHandle> getDependencyFileHandles(FileHandle fileHandle) {
        Object object;
        Array<FileHandle> array = new Array<FileHandle>();
        for (XmlReader.Element element : this.root.getChildrenByName("tileset")) {
            object = element.getAttribute("source", null);
            if (object != null) {
                XmlReader.Element element2 = this.xml.parse((FileHandle)(object = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object)));
                if (element2.getChildByName("image") != null) {
                    array.add(TmxMapLoader.getRelativeFileHandle(object, element2.getChildByName("image").getAttribute("source")));
                    continue;
                }
                Iterator<XmlReader.Element> iterator = element2.getChildrenByName("tile").iterator();
                while (iterator.hasNext()) {
                    array.add(TmxMapLoader.getRelativeFileHandle(object, iterator.next().getChildByName("image").getAttribute("source")));
                }
                continue;
            }
            if (element.getChildByName("image") != null) {
                array.add(TmxMapLoader.getRelativeFileHandle(fileHandle, element.getChildByName("image").getAttribute("source")));
                continue;
            }
            object = element.getChildrenByName("tile").iterator();
            while (object.hasNext()) {
                array.add(TmxMapLoader.getRelativeFileHandle(fileHandle, object.next().getChildByName("image").getAttribute("source")));
            }
        }
        Iterator<XmlReader.Element> iterator = this.root.getChildrenByName("imagelayer").iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getChildByName("image").getAttribute("source", null);
            if (object == null) continue;
            array.add(TmxMapLoader.getRelativeFileHandle(fileHandle, object));
        }
        return array;
    }

    @Override
    protected void addStaticTiles(FileHandle object, ImageResolver imageResolver, TiledMapTileSet tiledMapTileSet, XmlReader.Element object2, Array<XmlReader.Element> object3, String object4, int n, int n2, int n3, int n4, int n5, String string2, int n6, int n7, String object5, int n8, int n9, FileHandle fileHandle) {
        object2 = tiledMapTileSet.getProperties();
        if (fileHandle != null) {
            object = imageResolver.getImage(fileHandle.path());
            ((MapProperties)object2).put("imagesource", object5);
            ((MapProperties)object2).put("imagewidth", n8);
            ((MapProperties)object2).put("imageheight", n9);
            ((MapProperties)object2).put("tilewidth", n2);
            ((MapProperties)object2).put("tileheight", n3);
            ((MapProperties)object2).put("margin", n5);
            ((MapProperties)object2).put("spacing", n4);
            int n10 = ((TextureRegion)object).getRegionWidth();
            int n11 = ((TextureRegion)object).getRegionHeight();
            for (n8 = n5; n8 <= n11 - n3; n8 += n3 + n4) {
                n9 = n5;
                while (n9 <= n10 - n2) {
                    this.addStaticTiledMapTile(tiledMapTileSet, new TextureRegion((TextureRegion)object, n9, n8, n2, n3), n, n6, n7);
                    n9 += n2 + n4;
                    ++n;
                }
            }
        } else {
            object3 = ((Array)object3).iterator();
            object2 = fileHandle;
            while (object3.hasNext()) {
                object4 = (XmlReader.Element)object3.next();
                object5 = ((XmlReader.Element)object4).getChildByName("image");
                if (object5 != null) {
                    object2 = ((XmlReader.Element)object5).getAttribute("source");
                    object2 = string2 != null ? TmxMapLoader.getRelativeFileHandle(TmxMapLoader.getRelativeFileHandle((FileHandle)object, string2), (String)object2) : TmxMapLoader.getRelativeFileHandle((FileHandle)object, (String)object2);
                }
                this.addStaticTiledMapTile(tiledMapTileSet, imageResolver.getImage(((FileHandle)object2).path()), n + ((XmlReader.Element)object4).getIntAttribute("id"), n6, n7);
            }
        }
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle object, TextureLoader.TextureParameter textureParameter) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        object = this.getDependencyFileHandles((FileHandle)object).iterator();
        while (object.hasNext()) {
            array.add(new AssetDescriptor<Texture>((FileHandle)object.next(), Texture.class, textureParameter));
        }
        return array;
    }

    public TiledMap load(String string2) {
        return this.load(string2, new Parameters());
    }

    public TiledMap load(String object, Parameters object2) {
        FileHandle fileHandle = this.resolve((String)object);
        this.root = this.xml.parse(fileHandle);
        object = new ObjectMap();
        for (FileHandle fileHandle2 : this.getDependencyFileHandles(fileHandle)) {
            Texture texture = new Texture(fileHandle2, ((Parameters)object2).generateMipMaps);
            texture.setFilter(((Parameters)object2).textureMinFilter, ((Parameters)object2).textureMagFilter);
            ((ObjectMap)object).put(fileHandle2.path(), texture);
        }
        object2 = this.loadTiledMap(fileHandle, object2, new ImageResolver.DirectImageResolver((ObjectMap<String, Texture>)object));
        ((TiledMap)object2).setOwnedResources(((ObjectMap)object).values().toArray());
        return object2;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string2, FileHandle fileHandle, Parameters parameters) {
        this.map = this.loadTiledMap(fileHandle, parameters, new ImageResolver.AssetManagerImageResolver(assetManager));
    }

    @Override
    public TiledMap loadSync(AssetManager assetManager, String string2, FileHandle fileHandle, Parameters parameters) {
        return this.map;
    }

    public static class Parameters
    extends BaseTmxMapLoader.Parameters {
    }
}

