/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class TideMapLoader
extends SynchronousAssetLoader<TiledMap, Parameters> {
    private XmlReader.Element root;
    private XmlReader xml = new XmlReader();

    public TideMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TideMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    private static FileHandle getRelativeFileHandle(FileHandle fileHandle, String object) {
        object = new StringTokenizer((String)object, "\\/");
        fileHandle = fileHandle.parent();
        while (((StringTokenizer)object).hasMoreElements()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (string2.equals("..")) {
                fileHandle = fileHandle.parent();
                continue;
            }
            fileHandle = fileHandle.child(string2);
        }
        return fileHandle;
    }

    private void loadLayer(TiledMap tiledMap, XmlReader.Element element) {
        block10: {
            if (!element.getName().equals("Layer")) break block10;
            Object object = element.getAttribute("Id");
            Object object2 = element.getAttribute("Visible");
            Object object3 = element.getChildByName("Dimensions");
            Object object4 = ((XmlReader.Element)object3).getAttribute("LayerSize");
            object3 = ((XmlReader.Element)object3).getAttribute("TileSize");
            object4 = ((String)object4).split(" x ");
            int n = Integer.parseInt(object4[0]);
            int n2 = Integer.parseInt(object4[1]);
            object3 = ((String)object3).split(" x ");
            TiledMapTileLayer tiledMapTileLayer = new TiledMapTileLayer(n, n2, Integer.parseInt(object3[0]), Integer.parseInt(object3[1]));
            tiledMapTileLayer.setName((String)object);
            tiledMapTileLayer.setVisible(((String)object2).equalsIgnoreCase("True"));
            object2 = element.getChildByName("TileArray").getChildrenByName("Row");
            TiledMapTileSets tiledMapTileSets = tiledMap.getTileSets();
            int n3 = ((Array)object2).size;
            object = null;
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                object3 = (XmlReader.Element)((Array)object2).get(i);
                int n4 = n3 - 1 - i;
                int n5 = ((XmlReader.Element)object3).getChildCount();
                n = 0;
                for (int j = 0; j < n5; ++j) {
                    object4 = ((XmlReader.Element)object3).getChild(j);
                    Object object5 = ((XmlReader.Element)object4).getName();
                    if (((String)object5).equals("TileSheet")) {
                        object = tiledMapTileSets.getTileSet(((XmlReader.Element)object4).getAttribute("Ref"));
                        n2 = ((TiledMapTileSet)object).getProperties().get("firstgid", Integer.class);
                        continue;
                    }
                    if (((String)object5).equals("Null")) {
                        n += ((XmlReader.Element)object4).getIntAttribute("Count");
                        continue;
                    }
                    if (((String)object5).equals("Static")) {
                        object5 = new TiledMapTileLayer.Cell();
                        ((TiledMapTileLayer.Cell)object5).setTile(((TiledMapTileSet)object).getTile(((XmlReader.Element)object4).getIntAttribute("Index") + n2));
                        tiledMapTileLayer.setCell(n, n4, (TiledMapTileLayer.Cell)object5);
                        ++n;
                        continue;
                    }
                    if (!((String)object5).equals("Animated")) continue;
                    int n6 = ((XmlReader.Element)object4).getInt("Interval");
                    object4 = ((XmlReader.Element)object4).getChildByName("Frames");
                    Array<StaticTiledMapTile> array = new Array<StaticTiledMapTile>();
                    int n7 = ((XmlReader.Element)object4).getChildCount();
                    for (int k = 0; k < n7; ++k) {
                        int n8;
                        XmlReader.Element element2 = ((XmlReader.Element)object4).getChild(k);
                        String string2 = element2.getName();
                        if (string2.equals("TileSheet")) {
                            object5 = tiledMapTileSets.getTileSet(element2.getAttribute("Ref"));
                            n8 = ((TiledMapTileSet)object5).getProperties().get("firstgid", Integer.class);
                        } else {
                            object5 = object;
                            n8 = n2;
                            if (string2.equals("Static")) {
                                array.add((StaticTiledMapTile)((TiledMapTileSet)object).getTile(n2 + element2.getIntAttribute("Index")));
                                n8 = n2;
                                object5 = object;
                            }
                        }
                        object = object5;
                        n2 = n8;
                    }
                    object4 = new TiledMapTileLayer.Cell();
                    ((TiledMapTileLayer.Cell)object4).setTile(new AnimatedTiledMapTile((float)n6 / 1000.0f, array));
                    tiledMapTileLayer.setCell(n, n4, (TiledMapTileLayer.Cell)object4);
                    ++n;
                }
            }
            if ((element = element.getChildByName("Properties")) != null) {
                this.loadProperties(tiledMapTileLayer.getProperties(), element);
            }
            tiledMap.getLayers().add(tiledMapTileLayer);
        }
    }

    private TiledMap loadMap(XmlReader.Element object, FileHandle fileHandle, ImageResolver imageResolver) {
        TiledMap tiledMap = new TiledMap();
        Object object2 = ((XmlReader.Element)object).getChildByName("Properties");
        if (object2 != null) {
            this.loadProperties(tiledMap.getProperties(), (XmlReader.Element)object2);
        }
        object2 = ((XmlReader.Element)object).getChildByName("TileSheets").getChildrenByName("TileSheet").iterator();
        while (object2.hasNext()) {
            this.loadTileSheet(tiledMap, (XmlReader.Element)object2.next(), fileHandle, imageResolver);
        }
        object = ((XmlReader.Element)object).getChildByName("Layers").getChildrenByName("Layer").iterator();
        while (object.hasNext()) {
            this.loadLayer(tiledMap, (XmlReader.Element)object.next());
        }
        return tiledMap;
    }

    private void loadProperties(MapProperties mapProperties, XmlReader.Element object) {
        if (((XmlReader.Element)((Object)object)).getName().equals("Properties")) {
            for (XmlReader.Element element : ((XmlReader.Element)((Object)object)).getChildrenByName("Property")) {
                String string2 = element.getAttribute("Key", null);
                String string3 = element.getAttribute("Type", null);
                String object2 = element.getText();
                if (string3.equals("Int32")) {
                    mapProperties.put(string2, Integer.parseInt(object2));
                    continue;
                }
                if (string3.equals("String")) {
                    mapProperties.put(string2, object2);
                    continue;
                }
                if (string3.equals("Boolean")) {
                    mapProperties.put(string2, object2.equalsIgnoreCase("true"));
                    continue;
                }
                mapProperties.put(string2, object2);
            }
        }
    }

    private void loadTileSheet(TiledMap object, XmlReader.Element element, FileHandle object2, ImageResolver object3) {
        block4: {
            if (!element.getName().equals("TileSheet")) break block4;
            String string2 = element.getAttribute("Id");
            element.getChildByName("Description").getText();
            Object object4 = element.getChildByName("ImageSource").getText();
            String[] stringArray = element.getChildByName("Alignment");
            String string3 = stringArray.getAttribute("SheetSize");
            String[] stringArray2 = stringArray.getAttribute("TileSize");
            String[] stringArray3 = stringArray.getAttribute("Margin");
            stringArray.getAttribute("Spacing");
            stringArray = string3.split(" x ");
            Integer.parseInt(stringArray[0]);
            int n = 1;
            Integer.parseInt(stringArray[1]);
            stringArray2 = stringArray2.split(" x ");
            int n2 = Integer.parseInt(stringArray2[0]);
            int n3 = Integer.parseInt(stringArray2[1]);
            stringArray2 = stringArray3.split(" x ");
            int n4 = Integer.parseInt(stringArray2[0]);
            int n5 = Integer.parseInt(stringArray2[1]);
            stringArray3 = stringArray3.split(" x ");
            int n6 = Integer.parseInt(stringArray3[0]);
            int n7 = Integer.parseInt(stringArray3[1]);
            object3 = object3.getImage(TideMapLoader.getRelativeFileHandle((FileHandle)object2, (String)object4).path());
            object4 = ((TiledMap)object).getTileSets();
            object = ((TiledMapTileSets)object4).iterator();
            while (object.hasNext()) {
                n += ((TiledMapTileSet)object.next()).size();
            }
            object2 = new TiledMapTileSet();
            ((TiledMapTileSet)object2).setName(string2);
            ((TiledMapTileSet)object2).getProperties().put("firstgid", n);
            int n8 = ((TextureRegion)object3).getRegionWidth() - n2;
            int n9 = ((TextureRegion)object3).getRegionHeight() - n3;
            int n10 = n;
            n = n4;
            n4 = n9;
            object = object3;
            while (n5 <= n4) {
                for (n9 = n; n9 <= n8; n9 += n2 + n6) {
                    object3 = new StaticTiledMapTile(new TextureRegion((TextureRegion)object, n9, n5, n2, n3));
                    object3.setId(n10);
                    int n11 = n10 + 1;
                    ((TiledMapTileSet)object2).putTile(n10, (TiledMapTile)object3);
                    n10 = n11;
                }
                n5 += n3 + n7;
            }
            object = element.getChildByName("Properties");
            if (object != null) {
                this.loadProperties(((TiledMapTileSet)object2).getProperties(), (XmlReader.Element)object);
            }
            ((TiledMapTileSets)object4).addTileSet((TiledMapTileSet)object2);
        }
    }

    private Array<FileHandle> loadTileSheets(XmlReader.Element object, FileHandle fileHandle) throws IOException {
        Array<FileHandle> array = new Array<FileHandle>();
        object = ((XmlReader.Element)object).getChildByName("TileSheets").getChildrenByName("TileSheet").iterator();
        while (object.hasNext()) {
            array.add(TideMapLoader.getRelativeFileHandle(fileHandle, ((XmlReader.Element)object.next()).getChildByName("ImageSource").getText()));
        }
        return array;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String object, FileHandle assetDescriptor, Parameters object2) {
        object2 = new Array();
        try {
            this.root = this.xml.parse((FileHandle)((Object)assetDescriptor));
            for (FileHandle fileHandle : this.loadTileSheets(this.root, (FileHandle)((Object)assetDescriptor))) {
                assetDescriptor = new AssetDescriptor<Texture>(fileHandle.path(), Texture.class);
                ((Array)object2).add(assetDescriptor);
            }
            return object2;
        }
        catch (IOException iOException) {
            assetDescriptor = new StringBuilder();
            ((StringBuilder)((Object)assetDescriptor)).append("Couldn't load tilemap '");
            ((StringBuilder)((Object)assetDescriptor)).append((String)object);
            ((StringBuilder)((Object)assetDescriptor)).append("'");
            object = new GdxRuntimeException(((StringBuilder)((Object)assetDescriptor)).toString(), iOException);
            throw object;
        }
    }

    @Override
    public TiledMap load(AssetManager object, String string2, FileHandle fileHandle, Parameters object2) {
        try {
            object2 = this.root;
            ImageResolver.AssetManagerImageResolver assetManagerImageResolver = new ImageResolver.AssetManagerImageResolver((AssetManager)object);
            object = this.loadMap((XmlReader.Element)object2, fileHandle, assetManagerImageResolver);
            return object;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Couldn't load tilemap '");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("'");
            throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    public TiledMap load(String object) {
        try {
            Object object3 = this.resolve((String)object);
            this.root = this.xml.parse((FileHandle)object3);
            ObjectMap<String, Texture> objectMap = new ObjectMap<String, Texture>();
            for (FileHandle object22 : this.loadTileSheets(this.root, (FileHandle)object3)) {
                String string2 = object22.path();
                Texture texture = new Texture(object22);
                objectMap.put(string2, texture);
            }
            ImageResolver.DirectImageResolver directImageResolver = new ImageResolver.DirectImageResolver(objectMap);
            object3 = this.loadMap(this.root, (FileHandle)object3, directImageResolver);
            ((TiledMap)object3).setOwnedResources(objectMap.values().toArray());
            return object3;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't load tilemap '");
            stringBuilder.append((String)object);
            stringBuilder.append("'");
            object = new GdxRuntimeException(stringBuilder.toString(), iOException);
            throw object;
        }
    }

    public static class Parameters
    extends AssetLoaderParameters<TiledMap> {
    }
}

