/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.utils.GdxRuntimeException;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = new GLErrorListener(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onError(int n) {
            Object object;
            Object object2;
            Object object3 = null;
            try {
                object2 = Thread.currentThread().getStackTrace();
                int n2 = 0;
                while (true) {
                    object = object3;
                    if (n2 >= ((StackTraceElement[])object2).length) break;
                    if ("check".equals(object2[n2].getMethodName())) {
                        object = object3;
                        if (++n2 < ((StackTraceElement[])object2).length) {
                            object = object2[n2].getMethodName();
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                object = object3;
            }
            if (object != null) {
                object2 = Gdx.app;
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Error ");
                ((StringBuilder)object3).append(GLInterceptor.resolveErrorNumber(n));
                ((StringBuilder)object3).append(" from ");
                ((StringBuilder)object3).append((String)object);
                object2.error("GLProfiler", ((StringBuilder)object3).toString());
                return;
            }
            object = Gdx.app;
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Error ");
            ((StringBuilder)object3).append(GLInterceptor.resolveErrorNumber(n));
            ((StringBuilder)object3).append(" at: ");
            object.error("GLProfiler", ((StringBuilder)object3).toString(), new Exception());
        }
    };
    public static final GLErrorListener THROWING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GLProfiler: Got GL error ");
            stringBuilder.append(GLInterceptor.resolveErrorNumber(n));
            throw new GdxRuntimeException(stringBuilder.toString());
        }
    };

    public void onError(int var1);
}

