/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.IntArray;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class VertexBufferObjectWithVAO
implements VertexData {
    static final IntBuffer tmpHandle = BufferUtils.newIntBuffer(1);
    final VertexAttributes attributes;
    final FloatBuffer buffer;
    int bufferHandle;
    final ByteBuffer byteBuffer;
    IntArray cachedLocations = new IntArray();
    boolean isBound = false;
    boolean isDirty = false;
    final boolean isStatic;
    final boolean ownsBuffer;
    final int usage;
    int vaoHandle = -1;

    public VertexBufferObjectWithVAO(boolean bl, int n, VertexAttributes vertexAttributes) {
        this.isStatic = bl;
        this.attributes = vertexAttributes;
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(this.attributes.vertexSize * n);
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.ownsBuffer = true;
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        n = bl ? 35044 : 35048;
        this.usage = n;
        this.createVAO();
    }

    public VertexBufferObjectWithVAO(boolean bl, int n, VertexAttribute ... vertexAttributeArray) {
        this(bl, n, new VertexAttributes(vertexAttributeArray));
    }

    public VertexBufferObjectWithVAO(boolean bl, ByteBuffer byteBuffer, VertexAttributes vertexAttributes) {
        this.isStatic = bl;
        this.attributes = vertexAttributes;
        this.byteBuffer = byteBuffer;
        this.ownsBuffer = false;
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        int n = bl ? 35044 : 35048;
        this.usage = n;
        this.createVAO();
    }

    private void bindAttributes(ShaderProgram shaderProgram, int[] nArray) {
        int n = this.cachedLocations.size;
        int n2 = 0;
        n = n != 0 ? 1 : 0;
        int n3 = this.attributes.size();
        int n4 = n;
        if (n != 0) {
            int n5;
            if (nArray == null) {
                n5 = 0;
                while (true) {
                    n4 = n;
                    if (n != 0) {
                        n4 = n;
                        if (n5 < n3) {
                            n = shaderProgram.getAttributeLocation(this.attributes.get((int)n5).alias) == this.cachedLocations.get(n5) ? 1 : 0;
                            ++n5;
                            continue;
                        }
                    }
                    break;
                }
            } else {
                n = nArray.length == this.cachedLocations.size ? 1 : 0;
                n5 = 0;
                while (true) {
                    n4 = n;
                    if (n == 0) break;
                    n4 = n;
                    if (n5 >= n3) break;
                    n = nArray[n5] == this.cachedLocations.get(n5) ? 1 : 0;
                    ++n5;
                }
            }
        }
        if (n4 == 0) {
            Gdx.gl.glBindBuffer(34962, this.bufferHandle);
            this.unbindAttributes(shaderProgram);
            this.cachedLocations.clear();
            for (n = n2; n < n3; ++n) {
                VertexAttribute vertexAttribute = this.attributes.get(n);
                if (nArray == null) {
                    this.cachedLocations.add(shaderProgram.getAttributeLocation(vertexAttribute.alias));
                } else {
                    this.cachedLocations.add(nArray[n]);
                }
                n4 = this.cachedLocations.get(n);
                if (n4 < 0) continue;
                shaderProgram.enableVertexAttribute(n4);
                shaderProgram.setVertexAttribute(n4, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.attributes.vertexSize, vertexAttribute.offset);
            }
        }
    }

    private void bindData(GL20 gL20) {
        if (this.isDirty) {
            gL20.glBindBuffer(34962, this.bufferHandle);
            this.byteBuffer.limit(this.buffer.limit() * 4);
            gL20.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
    }

    private void bufferChanged() {
        if (this.isBound) {
            Gdx.gl20.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
    }

    private void createVAO() {
        tmpHandle.clear();
        Gdx.gl30.glGenVertexArrays(1, tmpHandle);
        this.vaoHandle = tmpHandle.get();
    }

    private void deleteVAO() {
        if (this.vaoHandle != -1) {
            tmpHandle.clear();
            tmpHandle.put(this.vaoHandle);
            tmpHandle.flip();
            Gdx.gl30.glDeleteVertexArrays(1, tmpHandle);
            this.vaoHandle = -1;
        }
    }

    private void unbindAttributes(ShaderProgram shaderProgram) {
        if (this.cachedLocations.size == 0) {
            return;
        }
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.cachedLocations.get(i);
            if (n2 < 0) continue;
            shaderProgram.disableVertexAttribute(n2);
        }
    }

    @Override
    public void bind(ShaderProgram shaderProgram) {
        this.bind(shaderProgram, null);
    }

    @Override
    public void bind(ShaderProgram shaderProgram, int[] nArray) {
        GL30 gL30 = Gdx.gl30;
        gL30.glBindVertexArray(this.vaoHandle);
        this.bindAttributes(shaderProgram, nArray);
        this.bindData(gL30);
        this.isBound = true;
    }

    @Override
    public void dispose() {
        GL30 gL30 = Gdx.gl30;
        gL30.glBindBuffer(34962, 0);
        gL30.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
        if (this.ownsBuffer) {
            BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
        }
        this.deleteVAO();
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public FloatBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public int getNumMaxVertices() {
        return this.byteBuffer.capacity() / this.attributes.vertexSize;
    }

    @Override
    public int getNumVertices() {
        return this.buffer.limit() * 4 / this.attributes.vertexSize;
    }

    @Override
    public void invalidate() {
        this.bufferHandle = Gdx.gl30.glGenBuffer();
        this.createVAO();
        this.isDirty = true;
    }

    @Override
    public void setVertices(float[] fArray, int n, int n2) {
        this.isDirty = true;
        BufferUtils.copy(fArray, this.byteBuffer, n2, n);
        this.buffer.position(0);
        this.buffer.limit(n2);
        this.bufferChanged();
    }

    @Override
    public void unbind(ShaderProgram shaderProgram) {
        this.unbind(shaderProgram, null);
    }

    @Override
    public void unbind(ShaderProgram shaderProgram, int[] nArray) {
        Gdx.gl30.glBindVertexArray(0);
        this.isBound = false;
    }

    @Override
    public void updateVertices(int n, float[] fArray, int n2, int n3) {
        this.isDirty = true;
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 4);
        BufferUtils.copy(fArray, n2, n3, (Buffer)this.byteBuffer);
        this.byteBuffer.position(n4);
        this.buffer.position(0);
        this.bufferChanged();
    }
}

