/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;

public class FrameBuffer
extends GLFrameBuffer<Texture> {
    FrameBuffer() {
    }

    public FrameBuffer(Pixmap.Format format, int n, int n2, boolean bl) {
        this(format, n, n2, bl, false);
    }

    public FrameBuffer(Pixmap.Format format, int n, int n2, boolean bl, boolean bl2) {
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(n, n2);
        frameBufferBuilder.addBasicColorTextureAttachment(format);
        if (bl) {
            frameBufferBuilder.addBasicDepthRenderBuffer();
        }
        if (bl2) {
            frameBufferBuilder.addBasicStencilRenderBuffer();
        }
        this.bufferBuilder = frameBufferBuilder;
        this.build();
    }

    protected FrameBuffer(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>> gLFrameBufferBuilder) {
        super(gLFrameBufferBuilder);
    }

    public static void unbind() {
        GLFrameBuffer.unbind();
    }

    @Override
    protected void attachFrameBufferColorTexture(Texture texture) {
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, 3553, texture.getTextureObjectHandle(), 0);
    }

    @Override
    protected Texture createTexture(GLFrameBuffer.FrameBufferTextureAttachmentSpec object) {
        object = new Texture(new GLOnlyTextureData(this.bufferBuilder.width, this.bufferBuilder.height, 0, ((GLFrameBuffer.FrameBufferTextureAttachmentSpec)object).internalFormat, ((GLFrameBuffer.FrameBufferTextureAttachmentSpec)object).format, ((GLFrameBuffer.FrameBufferTextureAttachmentSpec)object).type));
        ((GLTexture)object).setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        ((GLTexture)object).setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        return object;
    }

    @Override
    protected void disposeColorTexture(Texture texture) {
        texture.dispose();
    }
}

