/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class CameraInputController
extends GestureDetector {
    public int activateKey = 0;
    protected boolean activatePressed;
    public boolean alwaysScroll = true;
    public boolean autoUpdate = true;
    public int backwardKey = 47;
    protected boolean backwardPressed;
    protected int button = -1;
    public Camera camera;
    public int forwardButton = 2;
    public int forwardKey = 51;
    protected boolean forwardPressed;
    public boolean forwardTarget = true;
    protected final CameraGestureListener gestureListener;
    private boolean multiTouch;
    public float pinchZoomFactor = 10.0f;
    public float rotateAngle = 360.0f;
    public int rotateButton = 0;
    public int rotateLeftKey = 32;
    protected boolean rotateLeftPressed;
    public int rotateRightKey = 29;
    protected boolean rotateRightPressed;
    public float scrollFactor = -0.1f;
    public boolean scrollTarget = false;
    private float startX;
    private float startY;
    public Vector3 target = new Vector3();
    private final Vector3 tmpV1 = new Vector3();
    private final Vector3 tmpV2 = new Vector3();
    private int touched;
    public int translateButton = 1;
    public boolean translateTarget = true;
    public float translateUnits = 10.0f;

    public CameraInputController(Camera camera) {
        this(new CameraGestureListener(), camera);
    }

    protected CameraInputController(CameraGestureListener cameraGestureListener, Camera camera) {
        super(cameraGestureListener);
        this.gestureListener = cameraGestureListener;
        this.gestureListener.controller = this;
        this.camera = camera;
    }

    @Override
    public boolean keyDown(int n) {
        if (n == this.activateKey) {
            this.activatePressed = true;
        }
        if (n == this.forwardKey) {
            this.forwardPressed = true;
        } else if (n == this.backwardKey) {
            this.backwardPressed = true;
        } else if (n == this.rotateRightKey) {
            this.rotateRightPressed = true;
        } else if (n == this.rotateLeftKey) {
            this.rotateLeftPressed = true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int n) {
        if (n == this.activateKey) {
            this.activatePressed = false;
            this.button = -1;
        }
        if (n == this.forwardKey) {
            this.forwardPressed = false;
        } else if (n == this.backwardKey) {
            this.backwardPressed = false;
        } else if (n == this.rotateRightKey) {
            this.rotateRightPressed = false;
        } else if (n == this.rotateLeftKey) {
            this.rotateLeftPressed = false;
        }
        return false;
    }

    protected boolean pinchZoom(float f) {
        return this.zoom(this.pinchZoomFactor * f);
    }

    protected boolean process(float f, float f2, int n) {
        if (n == this.rotateButton) {
            this.tmpV1.set((Vector3)this.camera.direction).crs((Vector3)this.camera.up).y = 0.0f;
            this.camera.rotateAround(this.target, this.tmpV1.nor(), f2 * this.rotateAngle);
            this.camera.rotateAround(this.target, Vector3.Y, f * -this.rotateAngle);
        } else if (n == this.translateButton) {
            Camera camera = this.camera;
            camera.translate(this.tmpV1.set(camera.direction).crs(this.camera.up).nor().scl(-f * this.translateUnits));
            camera = this.camera;
            camera.translate(this.tmpV2.set(camera.up).scl(-f2 * this.translateUnits));
            if (this.translateTarget) {
                this.target.add(this.tmpV1).add(this.tmpV2);
            }
        } else if (n == this.forwardButton) {
            Camera camera = this.camera;
            camera.translate(this.tmpV1.set(camera.direction).scl(f2 * this.translateUnits));
            if (this.forwardTarget) {
                this.target.add(this.tmpV1);
            }
        }
        if (this.autoUpdate) {
            this.camera.update();
        }
        return true;
    }

    @Override
    public boolean scrolled(int n) {
        return this.zoom((float)n * this.scrollFactor * this.translateUnits);
    }

    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        int n5 = this.touched;
        boolean bl = true;
        this.touched = n5 | 1 << n3;
        this.multiTouch = MathUtils.isPowerOfTwo(this.touched) ^ true;
        if (this.multiTouch) {
            this.button = -1;
        } else if (this.button < 0 && (this.activateKey == 0 || this.activatePressed)) {
            this.startX = n;
            this.startY = n2;
            this.button = n4;
        }
        boolean bl2 = bl;
        if (!super.touchDown(n, n2, n3, n4)) {
            bl2 = bl;
            if (this.activateKey != 0) {
                bl2 = this.activatePressed ? bl : false;
            }
        }
        return bl2;
    }

    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        boolean bl = super.touchDragged(n, n2, n3);
        if (!bl && this.button >= 0) {
            float f = n;
            float f2 = (f - this.startX) / (float)Gdx.graphics.getWidth();
            float f3 = this.startY;
            float f4 = n2;
            f3 = (f3 - f4) / (float)Gdx.graphics.getHeight();
            this.startX = f;
            this.startY = f4;
            return this.process(f2, f3, this.button);
        }
        return bl;
    }

    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        int n5 = this.touched;
        boolean bl = true;
        this.touched = n5 & ~(1 << n3);
        this.multiTouch = MathUtils.isPowerOfTwo(this.touched) ^ true;
        if (n4 == this.button) {
            this.button = -1;
        }
        boolean bl2 = bl;
        if (!super.touchUp(n, n2, n3, n4)) {
            bl2 = this.activatePressed ? bl : false;
        }
        return bl2;
    }

    public void update() {
        if (this.rotateRightPressed || this.rotateLeftPressed || this.forwardPressed || this.backwardPressed) {
            Camera camera;
            float f = Gdx.graphics.getDeltaTime();
            if (this.rotateRightPressed) {
                camera = this.camera;
                camera.rotate(camera.up, -f * this.rotateAngle);
            }
            if (this.rotateLeftPressed) {
                camera = this.camera;
                camera.rotate(camera.up, this.rotateAngle * f);
            }
            if (this.forwardPressed) {
                camera = this.camera;
                camera.translate(this.tmpV1.set(camera.direction).scl(this.translateUnits * f));
                if (this.forwardTarget) {
                    this.target.add(this.tmpV1);
                }
            }
            if (this.backwardPressed) {
                camera = this.camera;
                camera.translate(this.tmpV1.set(camera.direction).scl(-f * this.translateUnits));
                if (this.forwardTarget) {
                    this.target.add(this.tmpV1);
                }
            }
            if (this.autoUpdate) {
                this.camera.update();
            }
        }
    }

    public boolean zoom(float f) {
        if (!this.alwaysScroll && this.activateKey != 0 && !this.activatePressed) {
            return false;
        }
        Camera camera = this.camera;
        camera.translate(this.tmpV1.set(camera.direction).scl(f));
        if (this.scrollTarget) {
            this.target.add(this.tmpV1);
        }
        if (this.autoUpdate) {
            this.camera.update();
        }
        return true;
    }

    protected static class CameraGestureListener
    extends GestureDetector.GestureAdapter {
        public CameraInputController controller;
        private float previousZoom;

        protected CameraGestureListener() {
        }

        @Override
        public boolean fling(float f, float f2, int n) {
            return false;
        }

        @Override
        public boolean longPress(float f, float f2) {
            return false;
        }

        @Override
        public boolean pan(float f, float f2, float f3, float f4) {
            return false;
        }

        @Override
        public boolean pinch(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
            return false;
        }

        @Override
        public boolean tap(float f, float f2, int n, int n2) {
            return false;
        }

        @Override
        public boolean touchDown(float f, float f2, int n, int n2) {
            this.previousZoom = 0.0f;
            return false;
        }

        @Override
        public boolean zoom(float f, float f2) {
            float f3 = f2 - f;
            float f4 = this.previousZoom;
            this.previousZoom = f3;
            float f5 = Gdx.graphics.getWidth();
            f2 = Gdx.graphics.getHeight();
            CameraInputController cameraInputController = this.controller;
            f = f5;
            if (f5 > f2) {
                f = f2;
            }
            return cameraInputController.pinchZoom((f3 - f4) / f);
        }
    }
}

