/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.values.ParticleValue;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public abstract class MeshSpawnShapeValue
extends SpawnShapeValue {
    protected Mesh mesh;
    protected Model model;

    public MeshSpawnShapeValue() {
    }

    public MeshSpawnShapeValue(MeshSpawnShapeValue meshSpawnShapeValue) {
        super(meshSpawnShapeValue);
    }

    @Override
    public void load(AssetManager disposable, ResourceData serializable) {
        AssetDescriptor assetDescriptor = ((ResourceData.SaveData)(serializable = ((ResourceData)serializable).getSaveData())).loadAsset();
        if (assetDescriptor != null) {
            disposable = (Model)disposable.get(assetDescriptor);
            this.setMesh(((Model)disposable).meshes.get((Integer)((ResourceData.SaveData)serializable).load("index")), (Model)disposable);
        }
    }

    @Override
    public void load(ParticleValue particleValue) {
        super.load(particleValue);
        particleValue = (MeshSpawnShapeValue)particleValue;
        this.setMesh(((MeshSpawnShapeValue)particleValue).mesh, ((MeshSpawnShapeValue)particleValue).model);
    }

    @Override
    public void save(AssetManager assetManager, ResourceData serializable) {
        if (this.model != null) {
            serializable = ((ResourceData)serializable).createSaveData();
            ((ResourceData.SaveData)serializable).saveAsset(assetManager.getAssetFileName(this.model), Model.class);
            ((ResourceData.SaveData)serializable).save("index", this.model.meshes.indexOf(this.mesh, true));
        }
    }

    public void setMesh(Mesh mesh) {
        this.setMesh(mesh, null);
    }

    public void setMesh(Mesh mesh, Model model) {
        if (mesh.getVertexAttribute(1) != null) {
            this.model = model;
            this.mesh = mesh;
            return;
        }
        throw new GdxRuntimeException("Mesh vertices must have Usage.Position");
    }

    public static class Triangle {
        float x1;
        float x2;
        float x3;
        float y1;
        float y2;
        float y3;
        float z1;
        float z2;
        float z3;

        public Triangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
            this.x1 = f;
            this.y1 = f2;
            this.z1 = f3;
            this.x2 = f4;
            this.y2 = f5;
            this.z2 = f6;
            this.x3 = f7;
            this.y3 = f8;
            this.z3 = f9;
        }

        public static Vector3 pick(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector3 vector3) {
            float f10 = MathUtils.random();
            float f11 = MathUtils.random();
            return vector3.set((f4 - f) * f10 + f + (f7 - f) * f11, (f5 - f2) * f10 + f2 + (f8 - f2) * f11, f10 * (f6 - f3) + f3 + f11 * (f9 - f3));
        }

        public Vector3 pick(Vector3 vector3) {
            float f = MathUtils.random();
            float f2 = MathUtils.random();
            float f3 = this.x1;
            float f4 = this.x2;
            float f5 = this.x3;
            float f6 = this.y1;
            float f7 = this.y2;
            float f8 = this.y3;
            float f9 = this.z1;
            return vector3.set((f4 - f3) * f + f3 + (f5 - f3) * f2, (f7 - f6) * f + f6 + (f8 - f6) * f2, f * (this.z2 - f9) + f9 + f2 * (this.z3 - f9));
        }
    }
}

