/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ParticleShader
extends BaseShader {
    static final Vector3 TMP_VECTOR3;
    private static String defaultFragmentShader;
    private static String defaultVertexShader;
    protected static long implementedFlags;
    private static final long optionalAttributes;
    protected final Config config;
    Material currentMaterial;
    private long materialMask;
    private Renderable renderable;
    private long vertexMask;

    static {
        implementedFlags = BlendingAttribute.Type | TextureAttribute.Diffuse;
        TMP_VECTOR3 = new Vector3();
        optionalAttributes = IntAttribute.CullFace | DepthTestAttribute.Type;
    }

    public ParticleShader(Renderable renderable) {
        this(renderable, new Config());
    }

    public ParticleShader(Renderable renderable, Config config) {
        this(renderable, config, ParticleShader.createPrefix(renderable, config));
    }

    public ParticleShader(Renderable object, Config config, ShaderProgram shaderProgram) {
        long l;
        long l2;
        this.config = config;
        this.program = shaderProgram;
        this.renderable = object;
        this.materialMask = ((Renderable)object).material.getMask() | optionalAttributes;
        this.vertexMask = ((Renderable)object).meshPart.mesh.getVertexAttributes().getMask();
        if (!config.ignoreUnimplemented && ((l2 = implementedFlags) & (l = this.materialMask)) != l) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Some attributes not implemented yet (");
            ((StringBuilder)object).append(this.materialMask);
            ((StringBuilder)object).append(")");
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        this.register(DefaultShader.Inputs.viewTrans, DefaultShader.Setters.viewTrans);
        this.register(DefaultShader.Inputs.projViewTrans, DefaultShader.Setters.projViewTrans);
        this.register(DefaultShader.Inputs.projTrans, DefaultShader.Setters.projTrans);
        this.register(Inputs.screenWidth, Setters.screenWidth);
        this.register(DefaultShader.Inputs.cameraUp, Setters.cameraUp);
        this.register(Inputs.cameraRight, Setters.cameraRight);
        this.register(Inputs.cameraInvDirection, Setters.cameraInvDirection);
        this.register(DefaultShader.Inputs.cameraPosition, Setters.cameraPosition);
        this.register(DefaultShader.Inputs.diffuseTexture, DefaultShader.Setters.diffuseTexture);
    }

    public ParticleShader(Renderable renderable, Config config, String string2) {
        String string3 = config.vertexShader != null ? config.vertexShader : ParticleShader.getDefaultVertexShader();
        String string4 = config.fragmentShader != null ? config.fragmentShader : ParticleShader.getDefaultFragmentShader();
        this(renderable, config, string2, string3, string4);
    }

    public ParticleShader(Renderable renderable, Config config, String string2, String charSequence, String string3) {
        CharSequence charSequence2 = new StringBuilder();
        charSequence2.append(string2);
        charSequence2.append((String)charSequence);
        charSequence2 = charSequence2.toString();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(string3);
        this(renderable, config, new ShaderProgram((String)charSequence2, ((StringBuilder)charSequence).toString()));
    }

    public static String createPrefix(Renderable object, Config config) {
        String string2;
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            object = new StringBuilder();
            ((StringBuilder)object).append("");
            ((StringBuilder)object).append("#version 120\n");
            string2 = ((StringBuilder)object).toString();
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append("");
            ((StringBuilder)object).append("#version 100\n");
            string2 = ((StringBuilder)object).toString();
        }
        object = string2;
        if (config.type == ParticleType.Billboard) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("#define billboard\n");
            string2 = ((StringBuilder)object).toString();
            if (config.align == AlignMode.Screen) {
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("#define screenFacing\n");
                object = ((StringBuilder)object).toString();
            } else {
                object = string2;
                if (config.align == AlignMode.ViewPoint) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("#define viewPointFacing\n");
                    object = ((StringBuilder)object).toString();
                }
            }
        }
        return object;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/particles/particles.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/particles/particles.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    @Override
    public void begin(Camera camera, RenderContext renderContext) {
        super.begin(camera, renderContext);
    }

    protected void bindMaterial(Renderable object) {
        if (this.currentMaterial == ((Renderable)object).material) {
            return;
        }
        int n = this.config.defaultCullFace == -1 ? 1029 : this.config.defaultCullFace;
        int n2 = this.config.defaultDepthFunc == -1 ? 515 : this.config.defaultDepthFunc;
        float f = 0.0f;
        float f2 = 1.0f;
        this.currentMaterial = ((Renderable)object).material;
        object = this.currentMaterial.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            Object object2;
            Attribute attribute = (Attribute)object.next();
            long l = attribute.type;
            if (BlendingAttribute.is(l)) {
                object2 = this.context;
                attribute = (BlendingAttribute)attribute;
                ((RenderContext)object2).setBlending(true, ((BlendingAttribute)attribute).sourceFunction, ((BlendingAttribute)attribute).destFunction);
                continue;
            }
            if ((l & DepthTestAttribute.Type) == DepthTestAttribute.Type) {
                object2 = (DepthTestAttribute)attribute;
                n2 = ((DepthTestAttribute)object2).depthFunc;
                f = ((DepthTestAttribute)object2).depthRangeNear;
                f2 = ((DepthTestAttribute)object2).depthRangeFar;
                bl = ((DepthTestAttribute)object2).depthMask;
                continue;
            }
            if (this.config.ignoreUnimplemented) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown material attribute: ");
            ((StringBuilder)object).append(attribute.toString());
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        this.context.setCullFace(n);
        this.context.setDepthTest(n2, f, f2);
        this.context.setDepthMask(bl);
    }

    @Override
    public boolean canRender(Renderable renderable) {
        boolean bl = this.materialMask == (renderable.material.getMask() | optionalAttributes) && this.vertexMask == renderable.meshPart.mesh.getVertexAttributes().getMask();
        return bl;
    }

    @Override
    public int compareTo(Shader shader) {
        if (shader == null) {
            return -1;
        }
        if (shader == this) {
            // empty if block
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.program.dispose();
        super.dispose();
    }

    @Override
    public void end() {
        this.currentMaterial = null;
        super.end();
    }

    public boolean equals(ParticleShader particleShader) {
        boolean bl = particleShader == this;
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof ParticleShader && this.equals((ParticleShader)object);
        return bl;
    }

    public int getDefaultCullFace() {
        int n = this.config.defaultCullFace == -1 ? 1029 : this.config.defaultCullFace;
        return n;
    }

    public int getDefaultDepthFunc() {
        int n = this.config.defaultDepthFunc == -1 ? 515 : this.config.defaultDepthFunc;
        return n;
    }

    @Override
    public void init() {
        ShaderProgram shaderProgram = this.program;
        this.program = null;
        this.init(shaderProgram, this.renderable);
        this.renderable = null;
    }

    @Override
    public void render(Renderable renderable) {
        if (!renderable.material.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.bindMaterial(renderable);
        super.render(renderable);
    }

    public void setDefaultCullFace(int n) {
        this.config.defaultCullFace = n;
    }

    public void setDefaultDepthFunc(int n) {
        this.config.defaultDepthFunc = n;
    }

    public static enum AlignMode {
        Screen,
        ViewPoint;

    }

    public static class Config {
        public AlignMode align = AlignMode.Screen;
        public int defaultCullFace = -1;
        public int defaultDepthFunc = -1;
        public String fragmentShader = null;
        public boolean ignoreUnimplemented = true;
        public ParticleType type = ParticleType.Billboard;
        public String vertexShader = null;

        public Config() {
        }

        public Config(AlignMode alignMode) {
            this.align = alignMode;
        }

        public Config(AlignMode alignMode, ParticleType particleType) {
            this.align = alignMode;
            this.type = particleType;
        }

        public Config(ParticleType particleType) {
            this.type = particleType;
        }

        public Config(String string2, String string3) {
            this.vertexShader = string2;
            this.fragmentShader = string3;
        }
    }

    public static class Inputs {
        public static final BaseShader.Uniform cameraInvDirection;
        public static final BaseShader.Uniform cameraRight;
        public static final BaseShader.Uniform regionSize;
        public static final BaseShader.Uniform screenWidth;

        static {
            cameraRight = new BaseShader.Uniform("u_cameraRight");
            cameraInvDirection = new BaseShader.Uniform("u_cameraInvDirection");
            screenWidth = new BaseShader.Uniform("u_screenWidth");
            regionSize = new BaseShader.Uniform("u_regionSize");
        }
    }

    public static enum ParticleType {
        Billboard,
        Point;

    }

    public static class Setters {
        public static final BaseShader.Setter cameraInvDirection;
        public static final BaseShader.Setter cameraPosition;
        public static final BaseShader.Setter cameraRight;
        public static final BaseShader.Setter cameraUp;
        public static final BaseShader.Setter screenWidth;
        public static final BaseShader.Setter worldViewTrans;

        static {
            cameraRight = new BaseShader.Setter(){

                @Override
                public boolean isGlobal(BaseShader baseShader, int n) {
                    return true;
                }

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, TMP_VECTOR3.set(baseShader.camera.direction).crs(baseShader.camera.up).nor());
                }
            };
            cameraUp = new BaseShader.Setter(){

                @Override
                public boolean isGlobal(BaseShader baseShader, int n) {
                    return true;
                }

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, TMP_VECTOR3.set(baseShader.camera.up).nor());
                }
            };
            cameraInvDirection = new BaseShader.Setter(){

                @Override
                public boolean isGlobal(BaseShader baseShader, int n) {
                    return true;
                }

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, TMP_VECTOR3.set(-baseShader.camera.direction.x, -baseShader.camera.direction.y, -baseShader.camera.direction.z).nor());
                }
            };
            cameraPosition = new BaseShader.Setter(){

                @Override
                public boolean isGlobal(BaseShader baseShader, int n) {
                    return true;
                }

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.position);
                }
            };
            screenWidth = new BaseShader.Setter(){

                @Override
                public boolean isGlobal(BaseShader baseShader, int n) {
                    return true;
                }

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, (float)Gdx.graphics.getWidth());
                }
            };
            worldViewTrans = new BaseShader.Setter(){
                final Matrix4 temp = new Matrix4();

                @Override
                public boolean isGlobal(BaseShader baseShader, int n) {
                    return false;
                }

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, this.temp.set(baseShader.camera.view).mul(renderable.worldTransform));
                }
            };
        }
    }
}

