/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.GroupStrategy;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Sort;

public class SimpleOrthoGroupStrategy
implements GroupStrategy {
    private static final int GROUP_BLEND = 1;
    private static final int GROUP_OPAQUE = 0;
    private Comparator comparator = new Comparator();

    @Override
    public void afterGroup(int n) {
        if (n == 1) {
            Gdx.gl.glDepthMask(true);
            Gdx.gl.glDisable(3042);
        }
    }

    @Override
    public void afterGroups() {
        Gdx.gl.glDisable(3553);
    }

    @Override
    public void beforeGroup(int n, Array<Decal> array) {
        if (n == 1) {
            Sort.instance().sort(array, this.comparator);
            Gdx.gl.glEnable(3042);
            Gdx.gl.glDepthMask(false);
        }
    }

    @Override
    public void beforeGroups() {
        Gdx.gl.glEnable(3553);
    }

    @Override
    public int decideGroup(Decal decal) {
        return decal.getMaterial().isOpaque() ^ 1;
    }

    @Override
    public ShaderProgram getGroupShader(int n) {
        return null;
    }

    class Comparator
    implements java.util.Comparator<Decal> {
        Comparator() {
        }

        @Override
        public int compare(Decal decal, Decal decal2) {
            if (decal.getZ() == decal2.getZ()) {
                return 0;
            }
            int n = decal.getZ() - decal2.getZ() < 0.0f ? -1 : 1;
            return n;
        }
    }
}

